<?php

namespace App\Services\Main\Brands;

use App\Models\Brand;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class BrandsService
{
    /** seo meta data */
    public array $seo = [
        'schema' => null,
        'site_name' => null,
        'title' => null,
        'description' => null,
        'keywords' => null,
        'canonical' => null,
        'image' => null,
        'type' => null,
    ];

    /** get seo infromation */
    public function seo(Brand $brand)
    {
        // schema
        $this->seo['schema'] = $this->brandSchema($brand);

        $shopTitle = Cache::remember('setting_shop_title', now()->addMonth(), function () {
            return Setting::where('key', 'shop_title')->first() != null ? Setting::where('key', 'shop_title')->first()->value : null;
        });

        // main
        $this->seo['site_name'] = $shopTitle;
        $this->seo['title'] = ($brand->seo_title != null ? $brand->seo_title : $brand->title) . ' - ' . $shopTitle;
        $this->seo['description'] = $brand->seo_description;
        $this->seo['keywords'] = $brand->get_seo_keywords;
        $this->seo['canonical'] = $brand->seo_canonical;
        $this->seo['image'] = $brand->get_logo;
        $this->seo['type'] = 'brand';

        // return information
        return $this->seo;
    }

    /** Product List Schema */
    public function brandSchema(Brand $brand)
    {
        $shopFullTitle = Setting::where('key', 'shop_full_title')->first() != null ? Setting::where('key', 'shop_full_title')->first()->value : null;

        $schema = [
            "@context" => "https://schema.org",
            "@type" => "BreadcrumbList",
            "itemListElement" => [
                [
                    "@type" => "ListItem",
                    "position" => 1,
                    "name" => $shopFullTitle,
                    "item" => [
                        "@type" => "Corporation",
                        "@id" => asset("/#corporation")
                    ]
                ],
                [
                    "@type" => "ListItem",
                    "position" => 2,
                    "name" => $brand->title,
                ]
            ],
        ];

        return json_encode($schema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
}
