<?php

namespace App\Services\Plugins\Sms;

use GuzzleHttp\Client;

class MelipayamakService
{
    private static $url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";
    private static $username = null;
    private static $password = null;

    // service construct
    private static function init($smsPanel)
    {
        static::$username = $smsPanel['fields']['information']['username'];
        static::$password = $smsPanel['fields']['information']['password'];
    }

    /** send sms */
    public static function send($smsPanel, $receptor, $template, $params)
    {
        // init
        static::init($smsPanel);

        // validate template pattern
        $template = $smsPanel['fields']['pattern'][$template]['value'];

        // guzzle client
        $client = new Client();

        // data
        $data = [
            'username' => static::$username,
            'password' => static::$password,
            'text' => implode(';', array_values($params)),
            'to' => $receptor,
            'bodyId' => $template,
        ];

        // send request
        $result = $client->request('POST', static::$url, [
            'verify' => false,
            'form_params' => $data,
        ]);

        return $result->getStatusCode() == 200 ? true : false;
    }
}
