<?php

namespace App\Services\Plugins\Sms;

use App\Models\Setting;

class SmsService
{
    /** send sms */
    public static function send($receptor, $template, $params)
    {
        $smsPanel = Setting::where('key', 'sms_panel')->first() != null ? unserialize(Setting::where('key', 'sms_panel')->first()->value) : null;

        // select active sms gateway
        $filteredArray = array_filter($smsPanel['panels'], function ($item) use ($smsPanel) {
            return $item['id'] === $smsPanel['active'];
        });
        $smsPanel = array_values($filteredArray)[0];

        if ($smsPanel != null) {
            switch ($smsPanel['id']) {
                case "kavenegar":
                    return KavenegarService::send($smsPanel, $receptor, $template, $params);
                    break;
                case "farazsms":
                    return FarazsmsService::send($smsPanel, $receptor, $template, $params);
                    break;
                case "ghasedak":
                    return GhasedakService::send($smsPanel, $receptor, $template, $params);
                    break;
                case "melipayamak":
                    return MelipayamakService::send($smsPanel, $receptor, $template, $params);
                    break;
                case "smsir":
                    return SmsirService::send($smsPanel, $receptor, $template, $params);
                    break;
            }
        }
    }
}
