<?php

namespace App\Services\User\CustomerClub;

use Illuminate\Http\Request;

class ScoresService
{
    /** get user customer club scores */
    public function getScores(Request $request)
    {
        /** @var \App\Models\User $user */
        $user = auth()->user();

        $scores = $user->scores()->when($request->input('increase'), function ($query, $increase) {
            if ($increase) {
                $query->where('type', 'increase');
            }
        })->when($request->input('decrease'), function ($query, $decrease) {
            if ($decrease) {
                $query->where('type', 'decrease');
            }
        })->orderBy('created_at', 'DESC')->paginate(10);
        $scores->withQueryString();

        return $scores;
    }
}
