import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Admin",
  __ssrInlineRender: true,
  props: {
    admins: {},
    roles: {},
    keyword: {}
  },
  setup(__props) {
    const props = __props;
    const rolesList = ref([]);
    for (let role in props.roles) {
      rolesList.value.push(props.roles[role]);
    }
    const promoteForm = useForm({
      role: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.admin_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.admin_list")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.username_or_phone") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.avatar"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.name"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.phone"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.username"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.role"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.register_date"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.admins.data, (user) => {
        _push(`<tr><td><img width="35" height="35" class="br-15 shadow-1"${ssrRenderAttr("src", user.get_avatar)}${ssrRenderAttr("alt", user.get_name)}></td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.users.show", user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>${ssrInterpolate(user.phone)}</td><td>${ssrInterpolate(user.username)}</td>`);
        if (user.type == "owner") {
          _push(`<td>${ssrInterpolate(_ctx.$t("messages.word.owner"))}</td>`);
        } else {
          _push(`<td>${ssrInterpolate(user.role.label)}</td>`);
        }
        _push(`<td>${ssrInterpolate(user.jalali_created_at[0])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item lts-05",
          href: _ctx.route("admin.users.show", user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-eye-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.show_and_edit"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-eye-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.show_and_edit")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li><li>`);
        if (user.type != "owner") {
          _push(`<a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#promote-user-" + user.id)}><i class="ri-user-star-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.change_role"))}</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</li><li>`);
        if (user.type == "admin") {
          _push(`<a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#demote-user-" + user.id)}><i class="ri-user-unfollow-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.demote_admin"))}</a>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</li></ul></div><div class="modal fade promote-user-modal"${ssrRenderAttr("id", "promote-user-" + user.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.change_user_role"))}: <span class="ms-1">${ssrInterpolate(user.get_name)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.select_role"))}: </label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown",
          modelValue: unref(promoteForm).role,
          "onUpdate:modelValue": ($event) => unref(promoteForm).role = $event,
          options: rolesList.value,
          display: "chip",
          optionLabel: "label",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_role")
        }, null, _parent));
        _push(`</div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.change_role"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "demote-user-" + user.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_demote_user"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.admin.demote", user.id),
          method: "post",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.demote"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.demote")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.admins.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.admins.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Roles/Admin.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
