import { defineComponent, mergeProps, unref, withCtx, createTextVNode, createVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrInterpolate, ssrRenderAttr, ssrRenderComponent, ssrRenderClass } from "vue/server-renderer";
import { Link, usePage } from "@inertiajs/vue3";
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Sidebar",
  __ssrInlineRender: true,
  setup(__props) {
    const isActive = (values) => {
      for (let value of values) {
        if (typeof window !== "undefined") {
          if (!usePage().props.currentRouteName.includes(value)) {
            continue;
          }
          return usePage().props.currentRouteName.includes(value);
        }
      }
      return false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "dropdown user-sidebar" }, _attrs))}><div class="menu-toggle w-100 d-md-none d-flex" aria-expanded="false" data-bs-toggle="dropdown"><button class="user-sidebar-toggle btn btn-white shadow-1 d-flex align-items-center justify-content-center w-100" style="${ssrRenderStyle({ "border": "1px solid #ebf1f6" })}"><i class="ri-menu-4-line me-2"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.user_panel_menu"))}</button></div><div class="dropdown-menu d-md-block d-none card shadow-1 panel-sidebar" style="${ssrRenderStyle({ "z-index": "4" })}"><div class="card-body"><div class="panel-sidebar--header"><div class="d-flex align-items-center"><div class="profile-avatar me-3"><img class="shadow-1"${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)}${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)}></div><div class="profile-info"><span class="text-decoration-none text-dark fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span><div class="text-gray fs-8 fw-normal">${ssrInterpolate(_ctx.$page.props.auth.user.phone)}</div></div></div><div class="wallet-options"><div>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.customer_club.scores"),
        class: "wallet-options--key link"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.customer_club"))} <i class="ri-external-link-line link-icon"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.customer_club")) + " ", 1),
              createVNode("i", { class: "ri-external-link-line link-icon" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<span class="wallet-options--value lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$page.props.auth.user.get_score.formatted_score)} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.score"))}</span></span></div><div><span class="wallet-options--key">${ssrInterpolate(_ctx.$t("messages.word.level"))}</span><span class="wallet-options--value lts-05 text-dark fw-bold">`);
      if (_ctx.$page.props.auth.user.get_level == "gold") {
        _push(`<span class="d-inline-flex align-items-center lts-05"><span class="d-inline-block gold-circle me-1"></span><span class="text-gray fw-normal fs-8 lh-15">${ssrInterpolate(_ctx.$t("messages.word.gold"))}</span></span>`);
      } else if (_ctx.$page.props.auth.user.get_level == "silver") {
        _push(`<span class="d-inline-flex align-items-center lts-05"><span class="d-inline-block silver-circle me-1"></span><span class="text-gray fw-normal fs-8 lh-15">${ssrInterpolate(_ctx.$t("messages.word.silver"))}</span></span>`);
      } else {
        _push(`<span class="d-inline-flex align-items-center lts-05"><span class="d-inline-block bronze-circle me-1"></span><span class="text-gray fw-normal fs-8 lh-15">${ssrInterpolate(_ctx.$t("messages.word.bronze"))}</span></span>`);
      }
      _push(`</span></div><div><span class="wallet-options--key">${ssrInterpolate(_ctx.$t("messages.word.wallet"))}</span><span class="wallet-options--value lts-05 text-dark fw-bold">${ssrInterpolate(_ctx.$page.props.auth.user.wallet.get_formatted_amount)} <span class="unit"></span></span></div>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.wallet.index"),
        class: "wallet-options--charge"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.charge_wallet_question"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.charge_wallet_question")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="panel-sidebar--content"><ul class="nav nav-items-with-icon flex-column"><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.dashboard"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.dashboard"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-home-8-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.dashboard"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-home-8-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.dashboard")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.profile.edit"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.profile.edit"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-profile-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_profile"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-profile-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.edit_profile")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.notifications.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.notifications.index"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-notification-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.notifications"))} `);
            if (_ctx.$page.props.notificationCount > 0) {
              _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.notificationCount)}</span>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-notification-3-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.notifications")) + " ", 1),
              _ctx.$page.props.notificationCount > 0 ? (openBlock(), createBlock("span", {
                key: 0,
                class: "count-badge shadow-1"
              }, toDisplayString(_ctx.$page.props.notificationCount), 1)) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.orders.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.orders"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-archive-2-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.my_orders"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-archive-2-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.my_orders")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.transactions.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.transactions.index"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-bank-card-2-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.transactions"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-bank-card-2-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.transactions")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.prefactor.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.prefactor.index"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-file-list-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.prefactors"))} `);
            if (_ctx.$page.props.auth.userBadge["waiting-prefactors"] > 0) {
              _push2(`<span class="count-badge shadow-1"${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.userBadge["waiting-prefactors"])}</span>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-file-list-3-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.prefactors")) + " ", 1),
              _ctx.$page.props.auth.userBadge["waiting-prefactors"] > 0 ? (openBlock(), createBlock("span", {
                key: 0,
                class: "count-badge shadow-1"
              }, toDisplayString(_ctx.$page.props.auth.userBadge["waiting-prefactors"]), 1)) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.wallet.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.wallet.index"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-wallet-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.wallet"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-wallet-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.wallet")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.tickets.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.tickets"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-message-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.tickets"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-message-3-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.tickets")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.favorites.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.favorites"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-heart-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.favorites"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-heart-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.favorites")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.comments.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.comments"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-question-answer-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.your_comments"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-question-answer-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.your_comments")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.addresses.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.addresses"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-map-pin-user-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.addresses"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-map-pin-user-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.addresses")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.history.index"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.history"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-history-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.last_seens"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-history-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.last_seens")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.profile.sessions"),
        class: { "nav-link": true, "lts-05": true, active: isActive(["user.profile.sessions"]) }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-device-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.active_sessions"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-device-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.active_sessions")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="nav-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("logout"),
        method: "post",
        as: "button",
        class: "nav-link lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="nav-link-icon ri-logout-box-r-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.logout"))}`);
          } else {
            return [
              createVNode("i", { class: "nav-link-icon ri-logout-box-r-line" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.logout")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></div></div></div></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/User/Sidebar.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "BottomNavigation",
  __ssrInlineRender: true,
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "bottom-navigation-bar d-block d-md-none" }, _attrs))}><div class="bottom-navigation"><ul><li class="${ssrRenderClass({ active: _ctx.$page.props.currentRouteName.includes("blog") })}">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("blog.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-blogger-line"${_scopeId}></i><span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.blog"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-blogger-line" }),
              createVNode("span", null, toDisplayString(_ctx.$t("messages.word.blog")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="${ssrRenderClass({ active: _ctx.$page.props.currentRouteName.includes("main.categories") })}">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("main.categories")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-apps-2-line"${_scopeId}></i><span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.category"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-apps-2-line" }),
              createVNode("span", null, toDisplayString(_ctx.$t("messages.word.category")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="${ssrRenderClass({ active: _ctx.$page.props.currentRouteName == "index" })}">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-home-6-line"${_scopeId}></i><span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.home"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-home-6-line" }),
              createVNode("span", null, toDisplayString(_ctx.$t("messages.word.home")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="${ssrRenderClass({ active: _ctx.$page.props.currentRouteName.includes("cart") })}">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("cart")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-shopping-basket-line"${_scopeId}></i><span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.shopping_cart"))} `);
            if (_ctx.$page.props.cart.items.length > 0) {
              _push2(`<span class="count-badge"${_scopeId}>${ssrInterpolate(_ctx.$page.props.cart.items.length)}</span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-shopping-basket-line" }),
              createVNode("span", null, [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.shopping_cart")) + " ", 1),
                _ctx.$page.props.cart.items.length > 0 ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge"
                }, toDisplayString(_ctx.$page.props.cart.items.length), 1)) : createCommentVNode("", true)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="${ssrRenderClass({ active: _ctx.$page.props.currentRouteName.includes("user.") })}">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.dashboard")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-user-smile-line"${_scopeId}></i><span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.user_area"))}</span>`);
          } else {
            return [
              createVNode("i", { class: "ri-user-smile-line" }),
              createVNode("span", null, toDisplayString(_ctx.$t("messages.word.user_area")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li></ul></div></section>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Widgets/BottomNavigation.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "AdminNavigation",
  __ssrInlineRender: true,
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.$page.props.auth.user != null && _ctx.$page.props.template != null && (_ctx.$page.props.auth.user.type == "owner" || _ctx.$page.props.auth.user.type == "admin")) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "admin-navigation d-flex align-items-center" }, _attrs))}><div class="container"><div class="row"><div class="col-12 d-flex align-items-center justify-content-between"><ul class="nav lts-05">`);
        if (_ctx.$page.props.auth.can["manage-products"]) {
          _push(`<li><a${ssrRenderAttr("href", _ctx.route("admin.products.index"))}>${ssrInterpolate(_ctx.$t("messages.word.products"))} <i class="ri-arrow-down-s-line lh-15"></i></a><div class="sub-nav shadow-1"><ul><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.products.index"))}><i class="ri-list-check-2"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.product_list"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.products.create"))}><i class="ri-add-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.create_product"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.brands.index"))}><i class="ri-instance-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.brands"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.product.categories.index"))}><i class="ri-list-check"></i> ${ssrInterpolate(_ctx.$t("messages.word.categories"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.storages.index"))}><i class="ri-home-4-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.warehousing"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.product.comments.index"))}><i class="ri-message-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.comments"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.article.comments.index"))}><i class="ri-question-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.questions_and_answers"))}</a></li></ul></div></li>`);
        } else {
          _push(`<!---->`);
        }
        if (_ctx.$page.props.auth.can["manage-articles"]) {
          _push(`<li><a${ssrRenderAttr("href", _ctx.route("admin.articles.index"))}>${ssrInterpolate(_ctx.$t("messages.word.articles"))} <i class="ri-arrow-down-s-line lh-15"></i></a><div class="sub-nav shadow-1"><ul><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.articles.index"))}><i class="ri-list-check-2"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.article_list"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.articles.create"))}><i class="ri-add-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.create_article"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.article.categories.index"))}><i class="ri-list-check"></i> ${ssrInterpolate(_ctx.$t("messages.word.categories"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.article.comments.index"))}><i class="ri-message-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.comments"))}</a></li></ul></div></li>`);
        } else {
          _push(`<!---->`);
        }
        if (_ctx.$page.props.currentRouteName.includes("main.products.show")) {
          _push(`<!--[-->`);
          if (_ctx.$page.props.auth.can["manage-products"]) {
            _push(`<li><a${ssrRenderAttr("href", _ctx.route("admin.products.edit", _ctx.$page.props.currentRouteParams["product"]))}>${ssrInterpolate(_ctx.$t("messages.sentence.edit_product"))}</a></li>`);
          } else {
            _push(`<!---->`);
          }
          if (_ctx.$page.props.auth.can["manage-products"]) {
            _push(`<li><a${ssrRenderAttr("href", _ctx.route("admin.inventories.index", _ctx.$page.props.currentRouteParams["product"]))}>${ssrInterpolate(_ctx.$t("messages.sentence.manage_inventories"))}</a></li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        } else if (_ctx.$page.props.currentRouteName.includes("blog.articles.show")) {
          _push(`<!--[-->`);
          if (_ctx.$page.props.auth.can["manage-articles"]) {
            _push(`<li><a${ssrRenderAttr("href", _ctx.route("admin.articles.edit", _ctx.$page.props.currentRouteParams["article"]))}>${ssrInterpolate(_ctx.$t("messages.sentence.edit_article"))}</a></li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        } else {
          _push(`<!--[-->`);
          if (_ctx.$page.props.auth.can["change-settings"]) {
            _push(`<li><a${ssrRenderAttr("href", _ctx.route("admin.settings.edit"))}>${ssrInterpolate(_ctx.$t("messages.word.settings"))}</a></li>`);
          } else {
            _push(`<!---->`);
          }
          if (_ctx.$page.props.auth.can["manage-template"]) {
            _push(`<li><a${ssrRenderAttr("href", _ctx.route("admin.templates.edit", _ctx.$page.props.template.id))}>${ssrInterpolate(_ctx.$t("messages.sentence.edit_template"))}</a></li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</ul><div class="profile d-inline-flex align-items-center justify-content-end"><a${ssrRenderAttr("href", _ctx.route("admin.dashboard"))}><img class="avatar shadow-1 clickable"${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)} width="40" height="40"${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)}></a><div class="d-md-block d-none ms-2 lts-05"><a${ssrRenderAttr("href", _ctx.route("admin.dashboard"))} class="user-name link d-inline-flex align-items-center justify-content-center clickable">${ssrInterpolate(_ctx.$page.props.auth.user.get_name)} <i class="ri-arrow-down-s-line lh-15"></i></a></div><div class="admin-menu shadow-1"><ul><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.dashboard"))}><i class="ri-home-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.dashboard"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.profile.edit"))}><i class="ri-user-smile-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_profile"))}</a></li><li><a class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"${ssrRenderAttr("href", _ctx.route("admin.profile.sessions"))}><i class="ri-device-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.active_sessions"))}</a></li><li><a${ssrRenderAttr("href", _ctx.route("admin.notifications.index"))} class="${ssrRenderClass({ "dropdown-item": true, "lts-05": true })}"><i class="ri-notification-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.notifications"))}</a></li><li>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item lts-05",
          method: "post",
          href: _ctx.route("logout"),
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-logout-circle-r-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.logout"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-logout-circle-r-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.logout")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</li></ul></div></div></div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Widgets/AdminNavigation.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _,
  _sfc_main$2 as a,
  _sfc_main$1 as b
};
