import { defineComponent, resolveDirective, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Articles",
  __ssrInlineRender: true,
  props: {
    articlesVisit: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.articles_statistics")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.articles_statistics")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex fw-bold fs-6 lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.x_most_viewed_articles", { count: "20" }))}</div><div class="border mb-3"></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: {
          visit_today: _ctx.$t("messages.word.today"),
          visit_week: _ctx.$t("messages.word.week"),
          visit_month: _ctx.$t("messages.word.month")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.articlesVisit, (article) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", article.get_image.url)}${ssrRenderAttr("alt", article.get_image.alt)}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, article.editor_choice ? _ctx.$t("messages.sentence.editor_choice") : null, void 0, { top: true }))}><a class="product-title product-title-min-300"${ssrRenderAttr("href", _ctx.route("blog.articles.show", article.slug))} target="_blank">${ssrInterpolate(article.title)}</a>`);
        if (article.editor_choice) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="first-small white-space-nowrap">${ssrInterpolate(article.get_formatted_view_count)}</td><td class="first-small white-space-nowrap">${ssrInterpolate(article.jalali_updated_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.articlesVisit.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Statistics/Articles.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
