import { defineComponent, ref, computed, watch, onMounted, unref, withCtx, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderSlot } from "vue/server-renderer";
import { usePage, router, Head } from "@inertiajs/vue3";
import { u as useToast } from "./useToastify-D_n0s7Uc.js";
import { u as useHexToRgb } from "./useHexToRgb-G7J9N7Ap.js";
/* empty css             */
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "AuthLayout",
  __ssrInlineRender: true,
  setup(__props) {
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      $(() => {
        let config = { attributes: true, attributeFilter: ["id"] };
        let callback = function(mutationsList, observer2) {
          for (let mutation of mutationsList) {
            if (mutation.type === "attributes" && mutation.attributeName === "id") {
              if (document.body.id == "dark") dark.value = true;
              else dark.value = false;
            }
          }
        };
        let observer = new MutationObserver(callback);
        observer.observe(document.body, config);
      });
    }
    const errorMessages = computed(() => usePage().props.errors);
    watch(errorMessages, (errors) => {
      for (let i in errors) {
        useToast(errors[i], "fail", 4e3);
      }
      if (errorMessages.value != null && Object.keys(errorMessages.value).length > 0) {
        router.reload({ only: ["errors"] });
      }
    });
    const flashMessage = computed(() => {
      if (typeof usePage().props.flash !== "undefined") return usePage().props.flash.message;
      return [];
    });
    watch(flashMessage, (messages) => {
      for (let i in messages) useToast(messages[i], "success", 4e3);
      if (flashMessage.value != null && Object.keys(flashMessage.value).length > 0) {
        router.reload({ only: ["flash"] });
      }
    });
    onMounted(() => {
      if (usePage().props.template != null) {
        const options = usePage().props.template.get_options;
        document.documentElement.style.setProperty("--main-background", options.style.site_background_color);
        document.documentElement.style.setProperty("--primary", options.style.site_main_color);
        document.documentElement.style.setProperty("--primary-rgb", useHexToRgb(options.style.site_main_color));
        document.documentElement.style.setProperty("--secondary", usePage().props.template.get_options.style.site_secondary_color);
        document.documentElement.style.setProperty("--secondary-rgb", useHexToRgb(usePage().props.template.get_options.style.site_secondary_color));
        document.documentElement.style.setProperty("--shadow-1", options.style.site_main_shadow);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="icon" type="image/x-icon"${ssrRenderAttr("href", _ctx.$page.props.appFavicon)}${_scopeId}><meta name="theme-color"${ssrRenderAttr("content", dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25")}${_scopeId}><meta name="robots" content="noindex,nofollow"${_scopeId}><meta name="googlebot" content="noindex"${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "icon",
                type: "image/x-icon",
                href: _ctx.$page.props.appFavicon
              }, null, 8, ["href"]),
              createVNode("meta", {
                name: "theme-color",
                content: dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25"
              }, null, 8, ["content"]),
              createVNode("meta", {
                name: "robots",
                content: "noindex,nofollow"
              }),
              createVNode("meta", {
                name: "googlebot",
                content: "noindex"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="page-wrapper"><div class="page-content auth-page-content">`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/AuthLayout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
