import { defineComponent, onMounted, onUnmounted, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
import ApexCharts from "apexcharts";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BarAndLineChart",
  __ssrInlineRender: true,
  props: {
    id: {},
    color: {},
    labels: {},
    datasets: {}
  },
  setup(__props) {
    const props = __props;
    var lineBarChartOptions = {
      series: [
        {
          name: props.datasets.bar.label,
          type: "column",
          data: props.datasets.bar.data
        },
        {
          name: props.datasets.line.label,
          type: "line",
          data: props.datasets.line.data
        }
      ],
      chart: {
        height: 275,
        type: "line",
        toolbar: { show: false },
        zoom: { enabled: false },
        fontFamily: "IRANYekanX"
      },
      plotOptions: {
        bar: {
          horizontal: false,
          endingShape: "rounded",
          columnWidth: "8%",
          borderRadius: 2
        }
      },
      dataLabels: { enabled: false },
      stroke: {
        curve: "smooth",
        width: [0, 3]
      },
      colors: props.color,
      labels: props.labels,
      xaxis: {
        type: "text",
        axisBorder: {
          show: true,
          color: "#f1f1f1"
        },
        axisTicks: {
          show: true
        },
        labels: {
          show: true,
          style: {
            fontSize: "12px",
            fontFamily: "IRANYekanX",
            fontWeight: 400
          }
        }
      },
      yaxis: [
        {},
        {
          opposite: true
        }
      ],
      legend: {
        position: "top",
        horizontalAlign: "center",
        fontFamily: "IRANYekanX",
        offsetY: 0
      },
      grid: {
        row: { colors: ["transparent", "transparent"], opacity: 0.1 },
        borderColor: "#f1f1f1"
      },
      tooltip: {
        style: {
          fontSize: "12px",
          fontFamily: "IRANYekanX"
        },
        y: {
          formatter: function(o) {
            return "" + o;
          }
        }
      },
      markers: {
        size: 4.5,
        colors: "#1c1c25",
        strokeColors: "#fff",
        strokeWidth: 3,
        hover: {
          size: 6,
          sizeOffset: 3
        }
      }
    };
    let chart;
    onMounted(() => {
      chart = new ApexCharts(document.querySelector("#line-bar-chart-" + props.id), lineBarChartOptions);
      chart.render();
    });
    onUnmounted(() => {
      chart.destroy();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "line-bar-chart-" + _ctx.id
      }, _attrs))}></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Chart/BarAndLineChart.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
