import { defineComponent, onMounted, inject, ref, computed, watch, unref, withCtx, createVNode, resolveDynamicComponent, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderClass, ssrRenderVNode, ssrRenderStyle, ssrRenderSlot, ssrInterpolate } from "vue/server-renderer";
/* empty css                       */
/* empty css                           */
/* empty css             */
/* empty css              */
import SimpleBar from "simplebar";
import ResizeObserver from "resize-observer-polyfill";
import { u as useToast } from "./useToastify-D_n0s7Uc.js";
import { usePage, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$1, a as _sfc_main$2, b as _sfc_main$3 } from "./AdminNavigation-BYBoZNuA.js";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
import { u as useHexToRgb } from "./useHexToRgb-G7J9N7Ap.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "BlogLayout",
  __ssrInlineRender: true,
  setup(__props) {
    let Bootstrap = null;
    onMounted(() => {
      if (typeof window !== "undefined") {
        Bootstrap = inject("bootstrap");
        new Bootstrap.Tooltip(document.body, {
          selector: "[data-bs-toggle='tooltip']",
          trigger: "hover"
        });
      }
    });
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      $(() => {
        let config = { attributes: true, attributeFilter: ["id"] };
        let callback = function(mutationsList, observer2) {
          for (let mutation of mutationsList) {
            if (mutation.type === "attributes" && mutation.attributeName === "id") {
              if (document.body.id == "dark") dark.value = true;
              else dark.value = false;
            }
          }
        };
        let observer = new MutationObserver(callback);
        observer.observe(document.body, config);
      });
    }
    if (typeof window !== "undefined") {
      onMounted(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: true
          });
        });
      });
    }
    if (typeof window !== "undefined") {
      onMounted(() => {
        window.jalaliDatepicker.startWatch({});
      });
    }
    const errorMessages = computed(() => {
      return usePage().props.errors;
    });
    watch(errorMessages, (errors) => {
      for (let i in errors) {
        useToast(errors[i], "fail", 4e3);
      }
      if (errorMessages.value != null && Object.keys(errorMessages.value).length > 0) ;
    });
    const flashMessage = computed(() => {
      if (typeof usePage().props.flash !== "undefined") {
        return usePage().props.flash.message;
      }
      return [];
    });
    watch(flashMessage, (messages) => {
      for (let i in messages) {
        useToast(messages[i], "success", 4e3);
      }
      if (flashMessage.value != null && Object.keys(flashMessage.value).length > 0) ;
    });
    onMounted(() => {
      if (usePage().props.template != null) {
        document.documentElement.style.setProperty("--main-background", usePage().props.template.get_options.style.site_background_color);
        document.documentElement.style.setProperty("--primary", usePage().props.template.get_options.style.site_main_color);
        document.documentElement.style.setProperty("--primary-rgb", useHexToRgb(usePage().props.template.get_options.style.site_main_color));
        document.documentElement.style.setProperty("--secondary", usePage().props.template.get_options.style.site_secondary_color);
        document.documentElement.style.setProperty("--secondary-rgb", useHexToRgb(usePage().props.template.get_options.style.site_secondary_color));
        document.documentElement.style.setProperty("--shadow-1", usePage().props.template.get_options.style.site_main_shadow);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="icon" type="image/x-icon"${ssrRenderAttr("href", _ctx.$page.props.appFavicon)}${_scopeId}><meta name="theme-color"${ssrRenderAttr("content", dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25")}${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "icon",
                type: "image/x-icon",
                href: _ctx.$page.props.appFavicon
              }, null, 8, ["href"]),
              createVNode("meta", {
                name: "theme-color",
                content: dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25"
              }, null, 8, ["content"])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (_ctx.$page.props.template != null) {
        _push(`<div class="${ssrRenderClass({
          "page-wrapper": true,
          "admin-loggedin": _ctx.$page.props.auth.user != null && _ctx.$page.props.template != null && (_ctx.$page.props.auth.user.type == "owner" || _ctx.$page.props.auth.user.type == "admin")
        })}">`);
        _push(ssrRenderComponent(_sfc_main$1, {
          key: unref(useRandomStr)(10)
        }, null, _parent));
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$page.props.template.header), { status: "prod" }, null), _parent);
        _push(`<div class="page-content" style="${ssrRenderStyle(_ctx.$page.props.currentRouteName == "index" || _ctx.$page.props.currentRouteName == "blog.index" ? "" : "padding-top: 20px")}">`);
        if ((_a = _ctx.route().current()) == null ? void 0 : _a.includes("user.")) {
          _push(`<div class="container mb-5"><div class="row"><div class="col-xl-3 col-lg-4 col-md-4 mb-md-0 mb-4">`);
          _push(ssrRenderComponent(_sfc_main$2, null, null, _parent));
          _push(`</div><div class="col-xl-9 col-lg-8 col-md-8">`);
          ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
          _push(`</div></div></div>`);
        } else {
          ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
        }
        _push(`</div>`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$page.props.template.footer), { status: "prod" }, null), _parent);
        if (_ctx.$page.props.currentRouteName.includes("blog.articles.show")) {
          _push(`<!--[--><!--]-->`);
        } else {
          _push(ssrRenderComponent(_sfc_main$3, {
            key: unref(useRandomStr)(10)
          }, null, _parent));
        }
        _push(`</div>`);
      } else {
        _push(`<div class="page-wrapper d-flex align-items-center justify-content-center"><p class="fw-bold fs-6">${ssrInterpolate(_ctx.$t("messages.sentence.no_template_has_been_activated"))}</p></div>`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/BlogLayout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
