import { defineComponent, unref, withCtx, createVNode, resolveDynamicComponent, createTextVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderVNode, ssrInterpolate, ssrRenderList, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Categories",
  __ssrInlineRender: true,
  props: {
    seo: {},
    productCategories: {},
    articleCategories: {},
    brands: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      if (_ctx.seo) {
        _push(ssrRenderComponent(unref(Head), null, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (_ctx.seo.description != null) {
                _push2(`<meta name="description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
              } else {
                _push2(`<!---->`);
              }
              if (_ctx.seo.title != null) {
                _push2(`<meta property="og:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
              } else {
                _push2(`<!---->`);
              }
              if (_ctx.seo.description != null) {
                _push2(`<meta property="og:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<meta property="og:url"${ssrRenderAttr("content", _ctx.$page.props.currentUrl)}${_scopeId}><meta property="og:site_name"${ssrRenderAttr("content", _ctx.seo.site_name)}${_scopeId}><meta property="og:locale" content="fa_IR"${_scopeId}><meta name="twitter:site"${ssrRenderAttr("content", _ctx.$page.props.appUrl)}${_scopeId}>`);
              if (_ctx.seo.title != null) {
                _push2(`<meta name="twitter:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
              } else {
                _push2(`<!---->`);
              }
              if (_ctx.seo.description != null) {
                _push2(`<meta name="twitter:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<meta name="robots" content="index, follow"${_scopeId}>`);
              if (_ctx.seo.schema != null) {
                ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.seo.schema)}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                      ];
                    }
                  }),
                  _: 1
                }), _parent2, _scopeId);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                  key: 0,
                  name: "description",
                  content: _ctx.seo.description
                }, null, 8, ["content"])) : createCommentVNode("", true),
                _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                  key: 1,
                  property: "og:title",
                  content: _ctx.seo.title
                }, null, 8, ["content"])) : createCommentVNode("", true),
                _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                  key: 2,
                  property: "og:description",
                  content: _ctx.seo.description
                }, null, 8, ["content"])) : createCommentVNode("", true),
                createVNode("meta", {
                  property: "og:url",
                  content: _ctx.$page.props.currentUrl
                }, null, 8, ["content"]),
                createVNode("meta", {
                  property: "og:site_name",
                  content: _ctx.seo.site_name
                }, null, 8, ["content"]),
                createVNode("meta", {
                  property: "og:locale",
                  content: "fa_IR"
                }),
                createVNode("meta", {
                  name: "twitter:site",
                  content: _ctx.$page.props.appUrl
                }, null, 8, ["content"]),
                _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                  key: 3,
                  name: "twitter:title",
                  content: _ctx.seo.title
                }, null, 8, ["content"])) : createCommentVNode("", true),
                _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                  key: 4,
                  name: "twitter:description",
                  content: _ctx.seo.description
                }, null, 8, ["content"])) : createCommentVNode("", true),
                createVNode("meta", {
                  name: "robots",
                  content: "index, follow"
                }),
                _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                  key: 5,
                  type: "application/ld+json"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                  ]),
                  _: 1
                })) : createCommentVNode("", true)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="container responsive-categories"><div class="row pb-3 mb-5"><div class="col-12"><ul class="nav nav-tabs nav-pager" id="categoriesTab" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link active" id="product-categories-tab" data-bs-toggle="tab" data-bs-target="#product-categories-tab-pane" type="button" role="tab" aria-controls="product-categories-tab-pane" aria-selected="true">${ssrInterpolate(_ctx.$t("messages.word.products"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="brands-tab" data-bs-toggle="tab" data-bs-target="#brands-tab-pane" type="button" role="tab" aria-controls="brands-tab-pane">${ssrInterpolate(_ctx.$t("messages.word.brands"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="article-categories-tab" data-bs-toggle="tab" data-bs-target="#article-categories-tab-pane" type="button" role="tab" aria-controls="article-categories-tab-pane">${ssrInterpolate(_ctx.$t("messages.word.articles"))}</button></li></ul><div class="tab-content" id="categoriesTabContent"><div class="tab-pane fade show active" id="product-categories-tab-pane" role="tabpanel" aria-labelledby="product-categories-tab" tabindex="0"><div class="accordion" id="accordionMenu"><!--[-->`);
      ssrRenderList(_ctx.productCategories, (category, index) => {
        _push(`<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-menu-" + category.id)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-menu-" + category.id)}>${ssrInterpolate(category.title)}</button></h2><div${ssrRenderAttr("id", "collapse-menu-" + category.id)} class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body pt-0"><div class="divider"></div>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link fs-9 lts-05",
          href: _ctx.route("main.products.index", { cat: category.slug })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.show_category_all_products", { cat: category.title }))} <i class="ri-arrow-drop-left-line"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.show_category_all_products", { cat: category.title })) + " ", 1),
                createVNode("i", { class: "ri-arrow-drop-left-line" })
              ];
            }
          }),
          _: 2
        }, _parent));
        if (category.childs.length > 0) {
          _push(`<div class="accordion accordion-sub mt-3"${ssrRenderAttr("id", "accordionMenu-" + index)}><!--[-->`);
          ssrRenderList(category.childs, (sub1, i1) => {
            _push(`<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-sub-menu-" + sub1.id)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-sub-menu-" + sub1.id)}>${ssrInterpolate(sub1.title)}</button></h2><div${ssrRenderAttr("id", "collapse-sub-menu-" + sub1.id)} class="accordion-collapse collapse"${ssrRenderAttr("data-bs-parent", "#accordionMenu-" + index)}><div class="accordion-body pt-0"><div class="divider"></div>`);
            _push(ssrRenderComponent(unref(Link), {
              class: "link fs-9 lts-05",
              href: _ctx.route("main.products.index", { cat: sub1.slug })
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.show_category_all_products", { cat: sub1.title }))} <i class="ri-arrow-drop-left-line"${_scopeId}></i>`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("messages.sentence.show_category_all_products", { cat: sub1.title })) + " ", 1),
                    createVNode("i", { class: "ri-arrow-drop-left-line" })
                  ];
                }
              }),
              _: 2
            }, _parent));
            if (sub1.childs.length > 0) {
              _push(`<div class="row mt-3"><!--[-->`);
              ssrRenderList(sub1.childs, (sub2) => {
                _push(`<div class="category-section col-lg-2 col-md-3 col-4 mb-2"><div class="card"><div class="card-body el-center"><img class="product-simple--img"${ssrRenderAttr("src", sub2.get_image)}${ssrRenderAttr("alt", sub2.title)} loading="lazy"><h2 class="product-simple--title">${ssrInterpolate(sub2.title)}</h2>`);
                _push(ssrRenderComponent(unref(Link), {
                  class: "product-simple--link",
                  href: _ctx.route("main.products.index", { cat: sub2.slug })
                }, null, _parent));
                _push(`</div></div></div>`);
              });
              _push(`<!--]--></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div></div></div>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div></div><div class="tab-pane fade mt-3" id="brands-tab-pane" role="tabpanel" aria-labelledby="brands-tab" tabindex="0"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.brands, (brand) => {
        _push(`<div class="category-section col-lg-2 col-md-3 col-4 mb-2"><div class="card"><div class="card-body el-center"><img class="product-simple--img"${ssrRenderAttr("src", brand.get_logo)}${ssrRenderAttr("alt", brand.title)} loading="lazy"><h2 class="product-simple--title">${ssrInterpolate(brand.title)}</h2>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "product-simple--link",
          href: _ctx.route("main.products.index", { brand: brand.slug })
        }, null, _parent));
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div></div><div class="tab-pane fade mt-3" id="article-categories-tab-pane" role="tabpanel" aria-labelledby="article-categories-tab" tabindex="0"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.articleCategories, (category) => {
        _push(`<div class="category-section col-lg-2 col-md-3 col-4 mb-2"><div class="card full-image"><div class="card-body el-center"><div class="img" style="${ssrRenderStyle("background-image: url(" + category.get_last_article_image.url + ");")}"></div><img class="product-simple--img d-none"${ssrRenderAttr("src", category.get_last_article_image.url)}${ssrRenderAttr("alt", category.title)} loading="lazy"><div class="back-drop"></div><div class="title-section"><h2>${ssrInterpolate(category.title)}</h2></div>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "product-simple--link",
          href: _ctx.route("blog.articles.index", { cat: category.slug })
        }, null, _parent));
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Mobile/Categories.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
