import { defineComponent, useModel, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderAttr, ssrRenderStyle } from "vue/server-renderer";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ChooseTopBanner",
  __ssrInlineRender: true,
  props: {
    "modelValue": { required: true },
    "modelModifiers": {}
  },
  emits: ["update:modelValue"],
  setup(__props) {
    const top_banner = useModel(__props, "modelValue");
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "modal fade ui-elements-modal",
        id: "topBannerModal",
        tabindex: "-1",
        "aria-hidden": "true"
      }, _attrs))}><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.select_top_banner"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><button data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="top-banner-desktop" class="btn btn-light fs-8 lts-05 me-2">`);
      if (top_banner.value.desktop.file_id != null) {
        _push(`<!--[-->${ssrInterpolate(_ctx.$t("messages.sentence.change_desktop_banner"))}<!--]-->`);
      } else {
        _push(`<!--[-->${ssrInterpolate(_ctx.$t("messages.sentence.select_desktop_banner"))}<!--]-->`);
      }
      _push(`</button><button data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="top-banner-mobile" class="btn btn-light fs-8 lts-05">`);
      if (top_banner.value.mobile.file_id != null) {
        _push(`<!--[-->${ssrInterpolate(_ctx.$t("messages.sentence.change_mobile_banner"))}<!--]-->`);
      } else {
        _push(`<!--[-->${ssrInterpolate(_ctx.$t("messages.sentence.select_mobile_banner"))}<!--]-->`);
      }
      _push(`</button></div><div class="col-12"><label for="eaTopBannerLink" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.banner_link"))}</label><input${ssrRenderAttr("value", top_banner.value.link)} type="text" class="form-control" style="${ssrRenderStyle({ "direction": "ltr" })}" id="eaTopBannerLink"></div></div></div><div class="modal-footer">`);
      if (top_banner.value.desktop.file_id != null || top_banner.value.mobile.file_id != null) {
        _push(`<button class="btn btn-danger">${ssrInterpolate(_ctx.$t("messages.sentence.delete_banner"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<button class="btn btn-primary" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.finish"))}</button></div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Templates/Components/ChooseTopBanner.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
