import { defineComponent, useModel, computed, ref, inject, resolveComponent, unref, mergeProps, watch, useSSRContext } from "vue";
import { ssrRenderComponent } from "vue/server-renderer";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Ckeditor",
  __ssrInlineRender: true,
  props: {
    "modelValue": { required: true },
    "modelModifiers": {}
  },
  emits: ["update:modelValue"],
  setup(__props) {
    const editorDataModel = useModel(__props, "modelValue");
    const safeContent = computed({
      get: () => editorDataModel.value ?? "",
      set: (val) => editorDataModel.value = val ?? ""
    });
    let CKEditor = null;
    let editor = null;
    const editorConfig = ref({
      toolbar: {
        shouldNotGroupWhenFull: true
      },
      language: "fa",
      contentsLangDirection: "rtl",
      image: {
        toolbar: ["imageTextAlternative", "toggleImageCaption", "imageStyle:inline", "imageStyle:block", "imageStyle:side"]
      },
      table: {
        contentToolbar: ["tableColumn", "tableRow", "mergeTableCells"]
      }
    });
    if (typeof window !== "undefined") {
      CKEditor = inject("CKEditor");
      editor = CKEditor;
    }
    const editorId = useRandomStr(10);
    const mediaReactive = inject("mediaData");
    ref({ type: editorId, file: null });
    const onReady = (editorInstance) => {
      var _a;
      const toolbarEl = editorInstance.ui.view.toolbar.element;
      const thrdSeparator = toolbarEl.querySelectorAll(".ck-toolbar__separator")[2];
      const imageButton = document.createElement("div");
      imageButton.classList.add("ckeditor-media-library");
      imageButton.innerHTML = `
    <button type="button" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="${editorId}">
      <i class="ri-image-2-fill"></i>
    </button>
  `;
      (_a = thrdSeparator == null ? void 0 : thrdSeparator.parentNode) == null ? void 0 : _a.insertBefore(imageButton, thrdSeparator.nextSibling);
      if (mediaReactive) {
        watch(
          mediaReactive,
          (media) => {
            if (media.type === editorId && media.file) {
              editorInstance.execute("insertImage", {
                source: [{ src: media.file.url, alt: media.file.description }]
              });
              mediaReactive.type = editorId;
              mediaReactive.file = null;
            }
          },
          { deep: true }
        );
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ckeditor = resolveComponent("ckeditor", true);
      if (unref(editor)) {
        _push(ssrRenderComponent(_component_ckeditor, mergeProps({
          editor: unref(editor),
          modelValue: safeContent.value,
          "onUpdate:modelValue": ($event) => safeContent.value = $event,
          config: editorConfig.value,
          name: unref(editorId),
          onReady
        }, _attrs), null, _parent));
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Common/Ckeditor.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
