import { defineComponent, onMounted, unref, withCtx, createVNode, toDisplayString, createTextVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import Swiper from "swiper/bundle";
import { _ as _sfc_main$2 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Compare",
  __ssrInlineRender: true,
  props: {
    products: {},
    compares: {},
    keyword: {}
  },
  setup(__props) {
    const swiperCompareContainer = () => {
      const sliderProducts = new Swiper(".swiper-compare-slider", {
        slidesPerView: 4,
        spaceBetween: 0,
        loop: false,
        breakpoints: {
          120: {
            slidesPerView: 1,
            spaceBetween: 5
          },
          575: {
            slidesPerView: 2,
            spaceBetween: 1
          },
          768: {
            slidesPerView: 3,
            spaceBetween: 1
          },
          992: {
            slidesPerView: 4,
            spaceBetween: 1
          }
        },
        on: {
          slideNextTransitionEnd: () => {
            sliderDetails.slideNext(100, false);
          },
          slidePrevTransitionEnd: () => {
            sliderDetails.slidePrev(100, false);
          }
        },
        observer: true
      });
      const sliderDetails = new Swiper(".swiper-compare-slider--details", {
        slidesPerView: 4,
        spaceBetween: 0,
        loop: false,
        breakpoints: {
          120: {
            slidesPerView: 1,
            spaceBetween: 5
          },
          575: {
            slidesPerView: 2,
            spaceBetween: 1
          },
          768: {
            slidesPerView: 3,
            spaceBetween: 1
          },
          992: {
            slidesPerView: 4,
            spaceBetween: 1
          }
        },
        on: {
          slideNextTransitionEnd: () => {
            sliderProducts.slideNext(100, false);
          },
          slidePrevTransitionEnd: () => {
            sliderProducts.slidePrev(100, false);
          }
        },
        observer: true
      });
    };
    onMounted(() => {
      swiperCompareContainer();
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<meta name="robots" content="noindex"${_scopeId}>`);
          } else {
            return [
              createVNode("meta", {
                name: "robots",
                content: "noindex"
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="container mb-4"><div class="card compare"><div class="card-body"><div class="compare-title"><span>${ssrInterpolate(_ctx.$t("messages.sentence.compare_products"))}</span><button class="btn btn-dark shadow-2" data-bs-toggle="modal" data-bs-target="#addProductToCompare"><i class="ri-add-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.add_product"))}</button></div><div class="modal fade" id="addProductToCompare" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><div class="modal-header pt-2"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.this_category_product_for_compare"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="search-container flex-grow-1">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.search_products")
      }, null, _parent));
      _push(`</div>`);
      if (_ctx.products.data.length > 0) {
        _push(`<div class="archive-products simplebar-container mb-4"><div class="row shadow-1 mx-0"><!--[-->`);
        ssrRenderList(_ctx.products.data, (product) => {
          _push(`<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6"><div class="card product"><div class="card-body"><div class="product-thumbnail"><img${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])} loading="lazy"></div><div class="product-body"><h2 class="product-title"><a class="lts-05"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))} target="_blank">${ssrInterpolate(product.title)}</a></h2></div><div class="product-footer d-flex justify-content-between"><div class="d-flex flex-row align-items-end"><a class="add-to-basket d-lg-flex d-none shadow-2 el-center" href="#"><i class="ri-shopping-basket-fill"></i></a><span class="product-rating-average">${ssrInterpolate(product.comments_info.rating == "0" ? "-" : product.comments_info.rating)} <i class="ri-star-fill"></i></span></div>`);
          if (!product.in_stock_status) {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span></div>`);
          } else if (product.inventory) {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now lts-05">${ssrInterpolate(product.best_normal_price.price)} <span class="unit unit-sm"></span></span></div>`);
          } else {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span></div>`);
          }
          _push(`</div><ul class="product-colors"><!--[-->`);
          ssrRenderList(product.unique_color, (color, index) => {
            _push(`<li style="${ssrRenderStyle("background-color:" + color.value.color)}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)} class="${ssrRenderClass({ "color-is-white": color.value.color == "#ffffff" })}"></li>`);
          });
          _push(`<!--]--></ul><form><button type="submit" class="btn add-item-to-compare shadow-2"><i class="ri-add-line"></i></button></form></div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.products.data.length == 0) {
        _push(`<div class="d-flex align-items-center justify-content-center p-4"><span class="fs-6 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.products.data.length > 0) {
        _push(`<div>`);
        _push(ssrRenderComponent(_sfc_main$3, {
          links: _ctx.products.links
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div>`);
      if (_ctx.compares.length > 0) {
        _push(`<div class="swiper swiper-compare-slider swiper-compare-slider--product"><div class="swiper-wrapper"><!--[-->`);
        ssrRenderList(_ctx.compares, (product) => {
          _push(`<div class="swiper-slide"><div><div class="compare-product"><div class="product-thumbnail"><img${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])} loading="lazy"></div><div class="product-title">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<h2${_scopeId}>${ssrInterpolate(product.title)}</h2>`);
              } else {
                return [
                  createVNode("h2", null, toDisplayString(product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div><div class="product-footer">`);
          if (!product.in_stock_status) {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold mb-2 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span></div>`);
          } else if (product.inventory) {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fs-6 fw-bold mb-2 lts-05">${ssrInterpolate(product.best_normal_price.price)} <span class="unit"></span></span></div>`);
          } else {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now fw-bold mb-2 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span></div>`);
          }
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", product.slug),
            class: "btn btn-light fs-8 shadow-1 lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.show_product"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.sentence.show_product")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.compare.delete", product["compare_id"]),
            method: "post",
            as: "button",
            class: "remove-product"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-close-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-close-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.compares.length > 0) {
        _push(`<div class="swiper swiper-compare-slider--details"><div class="swiper-wrapper"><!--[-->`);
        ssrRenderList(_ctx.compares, (product, index) => {
          _push(`<div class="swiper-slide"><div class="compare-lists"><!--[-->`);
          ssrRenderList(product.get_specifications, (specification) => {
            _push(`<!--[--><div class="${ssrRenderClass({ "compare-main-title": true, invisible: false })}">${ssrInterpolate(specification.title)}</div><ul class="compare-list"><!--[-->`);
            ssrRenderList(specification.keys, (key) => {
              _push(`<!--[--><li><div class="compare-list-title">${ssrInterpolate(key.key)}</div></li><li><div class="compare-list-value"><span class="block">${ssrInterpolate(key.value != null ? key.value : "-")}</span></div></li><!--]-->`);
            });
            _push(`<!--]--></ul><!--]-->`);
          });
          _push(`<!--]--></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.compares.length == 0) {
        _push(`<div class="d-flex align-items-center justify-content-center p-5"><span class="text-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_product_in_compare_table"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Products/Compare.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
