import { defineComponent, ref, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { useForm, Head } from "@inertiajs/vue3";
import "laravel-vue-i18n";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Create",
  __ssrInlineRender: true,
  props: {
    priorityList: {}
  },
  setup(__props) {
    ref();
    ref();
    const imageUrl = ref();
    ref();
    const createTicketForm = useForm({
      title: null,
      priority: "normal",
      content: null,
      attachment: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.create_ticket")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title mb-5 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.create_ticket"))}</div><form class="add-ticket-form"><div class="row"><div class="col-md-6"><div class="form-element-row mb-4"><label class="label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(createTicketForm).title)} type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.ticket_title"))}></div></div><div class="col-md-6"><div class="form-element-row mb-4"><label class="label">${ssrInterpolate(_ctx.$t("messages.word.priority"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        modelValue: unref(createTicketForm).priority,
        "onUpdate:modelValue": ($event) => unref(createTicketForm).priority = $event,
        options: _ctx.priorityList,
        optionLabel: "label",
        optionValue: "id",
        type: "text",
        readonly: "",
        class: "pvc-dropdown"
      }, null, _parent));
      _push(`</div></div></div><div class="row"><div class="col-12"><div class="form-element-row mb-4"><label class="label">${ssrInterpolate(_ctx.$t("messages.word.message"))}</label><textarea rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_message"))}>${ssrInterpolate(unref(createTicketForm).content)}</textarea></div></div><div class="col-12"><div class="form-element-row form-element-row-file mb-4"><div class="text-center"><div class="fs-6 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.upload_your_image_as_attachment_to_ticket"))}</div><div class="fs-9 text-muted mb-4">(${ssrInterpolate(_ctx.$t("messages.sentence.ticket_attachment_hint"))})</div></div>`);
      if (imageUrl.value != null) {
        _push(`<div class="selected-image"><img class="shadow-1"${ssrRenderAttr("src", imageUrl.value)}><i class="ri-close-line shadow-1 remove-image"></i></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="custom-input-file"><input type="file" class="custom-input-file-input" id="attachment" accept=".png,.jpg,.jpeg,.webp,.svg"><label for="attachment" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></label></div></div></div><div class="col-12 text-end"><button type="submit"${ssrIncludeBooleanAttr(unref(createTicketForm).processing) ? " disabled" : ""} class="btn btn-primary shadow-1 px-4">${ssrInterpolate(_ctx.$t("messages.word.send"))} <i class="ri-send-plane-2-line ms-2"></i></button></div></div></form></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Tickets/Create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
