import { defineComponent, onMounted, ref, inject, watch, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$3 } from "./StoreLayout-D2_RagXW.js";
import { _ as _sfc_main$2 } from "./Tagify-DYepU4nx.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$4 } from "./Ckeditor-BEPE8WxA.js";
import axios from "axios";
import AutoComplete from "primevue/autocomplete/autocomplete.esm.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "@yaireo/tagify";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Create",
  __ssrInlineRender: true,
  props: {
    categories: {}
  },
  setup(__props) {
    const props = __props;
    onMounted(() => {
      document.querySelectorAll(".tags").forEach((elem) => {
        new _sfc_main$2(elem);
      });
    });
    const categoriesList = ref([]);
    for (let category2 in props.categories) {
      categoriesList.value.push(props.categories[category2]);
    }
    const image = ref();
    const category = ref();
    const brandItems = ref([]);
    const searchBrand = (event) => {
      axios.get(route("seller.brands.search"), {
        params: {
          search: event.query
        }
      }).then(function(response) {
        let brands = response.data;
        brandItems.value = brands;
        if (brands.length > 0) {
          $(".p-autocomplete-panel").show();
        } else {
          $(".p-autocomplete-panel").hide();
        }
      }).catch(function(error) {
        console.log(error);
      });
    };
    const createArticleForm = useForm({
      title: null,
      slug: null,
      category: category.value,
      tags: "",
      content: "",
      source: null,
      read_time: null,
      brand: null,
      image: "",
      seo_title: null,
      seo_description: null,
      seo_keywords: "",
      seo_canonical: null,
      comment_status: true
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "article" && media.file != null) {
        image.value = media.file.url;
        createArticleForm.image = media.file.id + "";
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.create_article")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        title: _ctx.$t("messages.sentence.create_article")
      }, null, _parent));
      _push(`<div class="add-product row mb-4"><div class="col-12"><form><div class="card mb-4"><div class="card-body"><div class="pills-tab-container d-flex align-items-start"><div class="action-sidebar"><div class="nav flex-column nav-pills mb-md-4 mb-5" id="v-pills-tab" role="tablist" aria-orientation="vertical"><button class="nav-link active" id="v-pills-main-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main" type="button" role="tab" aria-controls="v-pills-main" aria-selected="true"><i class="ri-keyboard-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.main_information"))}</button><button class="nav-link" id="v-pills-seo-tab" data-bs-toggle="pill" data-bs-target="#v-pills-seo" type="button" role="tab" aria-controls="v-pills-seo" aria-selected="false"><i class="ri-seo-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.seo_settings"))}</button><button class="nav-link" id="v-pills-images-tab" data-bs-toggle="pill" data-bs-target="#v-pills-images" type="button" role="tab" aria-controls="v-pills-images" aria-selected="false"><i class="ri-image-edit-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.media_and_images"))}</button></div><div class="action-container d-md-block d-none mb-4"><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(createArticleForm).comment_status) ? ssrLooseContain(unref(createArticleForm).comment_status, null) : unref(createArticleForm).comment_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><button${ssrIncludeBooleanAttr(unref(createArticleForm).processing) ? " disabled" : ""} class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.submit_for_approval"))}</button></div></div><div class="tab-content" id="v-pills-tabContent"><div class="tab-pane fade show active" id="v-pills-main" role="tabpanel" aria-labelledby="v-pills-main-tab" tabindex="0"><div class="row"><div class="col-12 mb-4"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.article"))}</label><input${ssrRenderAttr("value", unref(createArticleForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.article"))} class="form-control" id="eaTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaEnSlug" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrRenderAttr("value", unref(createArticleForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaEnSlug"></div><div class="col-sm-6 col-12 mb-4"><label for="eaCategories" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.categories"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: category.value,
        "onUpdate:modelValue": ($event) => category.value = $event,
        options: categoriesList.value,
        filter: "",
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionLabel: "title",
        placeholder: _ctx.$t("messages.sentence.select_category")
      }, null, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaSource" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.source"))}</label><input${ssrRenderAttr("value", unref(createArticleForm).source)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.source") + " " + _ctx.$t("messages.word.article"))} class="form-control" id="eaSource"></div><div class="col-sm-6 col-12 mb-4"><label for="eaReadTime" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.read_time"))}</label><input${ssrRenderAttr("value", unref(createArticleForm).read_time)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.example_six_min"))} class="form-control" id="eaReadTime"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTags" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.tags"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        modelValue: unref(createArticleForm).tags,
        "onUpdate:modelValue": ($event) => unref(createArticleForm).tags = $event
      }, null, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.brand"))} <span class="text-gray fs-9">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></label>`);
      _push(ssrRenderComponent(unref(AutoComplete), {
        modelValue: unref(createArticleForm).brand,
        "onUpdate:modelValue": ($event) => unref(createArticleForm).brand = $event,
        dropdown: "",
        suggestions: brandItems.value,
        onComplete: searchBrand,
        placeholder: _ctx.$t("messages.sentence.product_brand")
      }, null, _parent));
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.type_and_search_brand"))}</span></div><div class="col-12 mb-4"><label class="form-label mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.content"))}</label><span class="d-flex alert alert-dark text-dark lh-25 fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.example_inject_product_inside_article_content"))}</span>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(createArticleForm).content,
        "onUpdate:modelValue": ($event) => unref(createArticleForm).content = $event
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="v-pills-seo" role="tabpanel" aria-labelledby="v-pills-seo-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(createArticleForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        modelValue: unref(createArticleForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(createArticleForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(createArticleForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(createArticleForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div></div><div class="tab-pane fade" id="v-pills-images" role="tabpanel" aria-labelledby="v-pills-images-tab" tabindex="0"><div class="row image-container"><div class="row image-container"><div class="col-12 mb-4"><div class="image-grid percent-60 select-image"><div class="image-grid--level-one" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="article"><div class="image-grid--level-two">`);
      if (image.value != null) {
        _push(`<div class="image" style="${ssrRenderStyle(`background-image: url('${image.value}');`)}"></div>`);
      } else {
        _push(`<!---->`);
      }
      if (image.value == null) {
        _push(`<div class="select-image-details"><i class="ri-image-2-fill"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.choose_article_image"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (image.value != null) {
        _push(`<i class="remove-image ri-close-line"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div></div><div class="action-container d-md-none d-block mt-4"><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(createArticleForm).comment_status) ? ssrLooseContain(unref(createArticleForm).comment_status, null) : unref(createArticleForm).comment_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><button${ssrIncludeBooleanAttr(unref(createArticleForm).processing) ? " disabled" : ""} class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.submit_for_approval"))}</button></div></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Blog/Articles/Create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
