import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$5 } from "./ApextBarChart-pRumOpuR.js";
import { _ as _sfc_main$6 } from "./BarAndLineChart-BNn4O1Ev.js";
import { _ as _sfc_main$4 } from "./LineChart-CIYq_-2s.js";
import { _ as _sfc_main$3 } from "./SingleTopChart-DsD8dN-3.js";
import { u as useNumberFormat } from "../ssr.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "apexcharts";
import "chart.js/auto";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "swiper";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Dashboard",
  __ssrInlineRender: true,
  props: {
    counts: {},
    pageView: {},
    pageUniqueView: {},
    totalSales: {},
    orders: {},
    mostViewedProductsOfMonth: {}
  },
  setup(__props) {
    const props = __props;
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.dashboard")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.dashboard")
      }, null, _parent));
      _push(`<div class="row intro-welcome"><div class="col-xl-8 col-lg-6 col-md-12 col-12 mb-4 user-welcome"><div class="card"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/man_laptop_blue.png")} class="welcome-bg"><div class="card-body"><span class="user-name mb-3"><img${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)}${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)}><span>${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span> ${ssrInterpolate(_ctx.$t("messages.sentence.dear_welcome"))}</span><span class="task-desc mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_154895"))}</span><ul><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-orders"])} <span>${ssrInterpolate(_ctx.$t("messages.word.order"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-tickets"])} <span>${ssrInterpolate(_ctx.$t("messages.word.ticket"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-products"])} <span>${ssrInterpolate(_ctx.$t("messages.word.product"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_publish"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.adminBadges["waiting-articles"])} <span>${ssrInterpolate(_ctx.$t("messages.word.article"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_publish"))}</span></li></ul></div></div></div><div class="col-xl-4 col-lg-6 col-md-12 col-12"><div class="row" style="${ssrRenderStyle({ "height": "100%" })}"><div class="col-xl-6 col-lg-12 col-md-6 col-sm-6 col-12 repository-chart-squre mb-4"><div class="card shadow-1"><div class="card-body"><div class="repository"><span class="repository--count">${ssrInterpolate(unref(useNumberFormat)(_ctx.counts.transactions))}</span><span class="repository--desc">${ssrInterpolate(_ctx.$t("messages.sentence.successful_transactions"))}</span></div><div id="squreBiutyChart" style="${ssrRenderStyle({ "position": "relative", "left": "-3px" })}">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 10,
        size: { width: 130, height: 80 },
        color: ["#0060ff", "#49beff", "#eaeff4"],
        type: "squre"
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-xl-6 col-lg-12 col-md-6 col-sm-6 col-12 repository-chart-squre mb-4"><div class="card shadow-1"><div class="card-body"><div class="repository"><span class="repository--count price">${ssrInterpolate(unref(useNumberFormat)(_ctx.counts.sellers))}</span><span class="repository--desc"> کل فروشنده ها </span></div><div id="SalesChart">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 11,
        size: { width: 0, height: 100 },
        color: ["#5d87ff"],
        type: "area"
      }, null, _parent));
      _push(`</div></div></div></div></div></div></div><div class="row top-simple-chart"><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold" style="${ssrRenderStyle({ "color": "#ffae1f" })}">${ssrInterpolate(_ctx.$t("messages.sentence.users_count"))}</span><span class="value big">${ssrInterpolate(unref(useNumberFormat)(_ctx.counts.users))} <span>${ssrInterpolate(_ctx.$t("messages.word.person"))}</span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.users.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.show"))} <i class="ri-external-link-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.show")) + " ", 1),
              createVNode("i", { class: "ri-external-link-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 1,
        size: { width: 70, height: 40 },
        color: ["#ffae1f"],
        type: "bar"
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold lts-05" style="${ssrRenderStyle({ "color": "#32abc3" })}">${ssrInterpolate(_ctx.$t("messages.sentence.published_products"))}</span><span class="value big">${ssrInterpolate(unref(useNumberFormat)(_ctx.counts.products))} <span>${ssrInterpolate(_ctx.$t("messages.word.number"))}</span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.products.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.show"))} <i class="ri-external-link-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.show")) + " ", 1),
              createVNode("i", { class: "ri-external-link-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 4,
        size: { width: 70, height: 45 },
        color: ["#32abc3"],
        type: "line"
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold lts-05" style="${ssrRenderStyle({ "color": "#fc5b61" })}">${ssrInterpolate(_ctx.$t("messages.sentence.published_articles"))}</span><span class="value big">${ssrInterpolate(unref(useNumberFormat)(_ctx.counts.articles))} <span>${ssrInterpolate(_ctx.$t("messages.word.number"))}</span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.articles.index"),
        class: "mb-2"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.show"))} <i class="ri-external-link-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.show")) + " ", 1),
              createVNode("i", { class: "ri-external-link-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div style="${ssrRenderStyle({ "position": "relative", "left": "-15px" })}">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 2,
        size: { width: 80, height: 80 },
        color: ["#fc5b61", "#ffaeb1", "#fde2e3"],
        type: "pie"
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold" style="${ssrRenderStyle({ "color": "#49beff" })}">${ssrInterpolate(_ctx.$t("messages.word.orders"))}</span><span class="value big">${ssrInterpolate(unref(useNumberFormat)(_ctx.counts.orders))} <span>${ssrInterpolate(_ctx.$t("messages.word.number"))}</span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.orders.processing")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.show"))} <i class="ri-external-link-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.show")) + " ", 1),
              createVNode("i", { class: "ri-external-link-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 3,
        size: { width: 70, height: 35 },
        color: ["#49beff", "#b4e2fc", "#eaeff4"],
        type: "squre"
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="row statistics"><div class="col-lg-6 col-md-12 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details mb-2"><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.page_unique_view_for_last_week"))}</span><span class="value">${ssrInterpolate(props.pageUniqueView.totalPageUniqueView)}</span></div><div class="el-chart">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        id: 142369,
        labels: props.pageUniqueView.dates,
        datasets: {
          one: { data: props.pageUniqueView.shop.views, label: props.pageUniqueView.shop.label, color: "#ffae1f" },
          two: { data: props.pageUniqueView.blog.views, label: props.pageUniqueView.blog.label, color: "#757ad1" }
        }
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-lg-6 col-md-12 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details mb-2"><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.page_view_for_last_week"))}</span><span class="value">${ssrInterpolate(props.pageView.totalPageView)}</span></div><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr" })}">`);
      _push(ssrRenderComponent(_sfc_main$5, {
        id: 748596,
        labels: props.pageView.dates,
        color: ["#5d87ff", "#49beff"],
        datasets: {
          one: { data: props.pageView.shop.views, label: props.pageView.shop.label },
          two: { data: props.pageView.blog.views, label: props.pageView.blog.label }
        }
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="row income-payments"><div class="col-lg-6 col-md-12 mb-4"><div class="card income shadow-1"><div class="card-body" style="${ssrRenderStyle({ "padding-bottom": "10px" })}"><ul class="mb-4 mt-3"><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.today_sale"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalSales.counts.today))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.month_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalSales.counts.month))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.total_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalSales.counts.total))}</span></li></ul><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "height": "100%" })}">`);
      _push(ssrRenderComponent(_sfc_main$6, {
        id: 1,
        color: ["#34495E", "#1abc9c"],
        labels: _ctx.totalSales.dates,
        datasets: {
          bar: { data: _ctx.totalSales.chart.sales, label: "مبلغ فروش" },
          line: { data: _ctx.totalSales.chart.count, label: "تعداد فروش" }
        }
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-lg-6 col-md-12 mb-4"><div class="card payments shadow-1" style="${ssrRenderStyle({ "height": "100%" })}"><div class="card-body"><div class="card-title mb-4"><span>${ssrInterpolate(_ctx.$t("messages.sentence.latest_order_list"))}</span></div><div class="table-responsive simplebar-container"><table class="table" style="${ssrRenderStyle({ "min-width": "500px" })}"><thead><tr><th class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.orders, (order, index) => {
        _push(`<tr><td class="white-space-nowrap">${ssrInterpolate(order.uuid)}</td><td>`);
        if (order.status == "registered") {
          _push(`<div>`);
          if (order.is_all_item_cancelled) {
            _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_final_cancel"))}</span>`);
          } else if (order.is_ready_to_send) {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.ready_to_send"))}</span>`);
          } else if (order.is_awaiting_request_from_seller) {
            _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_request_from_seller"))}</span>`);
          } else if (order.is_awaiting_seller) {
            _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_seller"))}</span>`);
          } else if (order.is_awaiting_receipt_from_seller) {
            _push(`<span class="badge bg-purple">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_receipt_from_seller"))}</span>`);
          } else {
            _push(`<span class="badge bg-info me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span>`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "sent") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "delivered") {
          _push(`<span class="badge bg-success text-info">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "cancelled") {
          _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (order.status == "returned") {
          _push(`<span class="badge bg-danger text-info">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(order.jalali_created_at[2])}</td><td class="first-small" style="${ssrRenderStyle({ "width": "90px" })}">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.orders.show", order.id),
          as: "button",
          class: "btn btn-sm btn-outline-light pt-1 pb-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.details"))} <i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.details")) + " ", 1),
                createVNode("i", { class: "ri-arrow-left-s-fill" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.orders.length == 0) {
        _push(`<div class="cart-empty" style="${ssrRenderStyle({ "padding": "32px 15px" })}"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><div class="row"><div class="col-12 mb-4"><div class="card last-month-most-viewed product-list"><div class="card-body"><div class="card-title mb-4"><span>${ssrInterpolate(_ctx.$t("messages.sentence.most_viewed_products"))}</span>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.products.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.show_all"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.show_all")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "min-width": "1000px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.by"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.mostViewedProductsOfMonth, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { top: true }))}><a class="product-title link fw-normal product-title-min-300"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))} target="_blank">${ssrInterpolate(product.title)}</a>`);
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="white-space-nowrap">${ssrInterpolate(product.get_formatted_view_count)}</td><td class="white-space-nowrap">`);
        if (product.user.type == "owner" || product.user.type == "admin") {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.users.show", product.user_id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.get_name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.get_name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else if (product.user.seller) {
          _push(ssrRenderComponent(unref(Link), {
            class: "link fs-8 fw-normal",
            href: _ctx.route("admin.stores.show", product.user.store.uuid)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.user.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.user.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05">`);
        if (product.status == "publish") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else if (product.status == "draft") {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.draft"))}</span>`);
        } else if (product.status == "awaiting") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        } else if (product.status == "rejected") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(product.jalali_updated_at[3])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.mostViewedProductsOfMonth.length == 0) {
        _push(`<div class="cart-empty" style="${ssrRenderStyle({ "padding": "32px 15px" })}"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Dashboard.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
