import { defineComponent, unref, withCtx, createVNode, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderList, ssrRenderStyle } from "vue/server-renderer";
import { u as useNumberFormat } from "../ssr.js";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "jquery";
import "swiper";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Dashboard",
  __ssrInlineRender: true,
  props: {
    orders: {},
    product_favorites: {},
    product_hitsory: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.dashboard")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="row"><div class="col-lg-6 col-12 mb-4 user-welcome"><div class="card"><div class="card-body"><span class="user-name mb-3"><img${ssrRenderAttr("src", _ctx.$page.props.auth.user.get_avatar)}${ssrRenderAttr("alt", _ctx.$page.props.auth.user.get_name)} class="shadow-1"><span>${ssrInterpolate(_ctx.$page.props.auth.user.get_name)}</span> ${ssrInterpolate(_ctx.$t("messages.sentence.dear_welcome"))}</span><span class="task-desc mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_552158"))}</span><ul><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.userBadge["waiting-orders"])} <span>${ssrInterpolate(_ctx.$t("messages.word.order"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.userBadge["waiting-tickets"])} <span>${ssrInterpolate(_ctx.$t("messages.word.ticket"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.userBadge["waiting-comments"])} <span>${ssrInterpolate(_ctx.$t("messages.word.comment"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_publish"))}</span></li><li><span class="value">${ssrInterpolate(_ctx.$page.props.auth.userBadge["waiting-questions"])} <span>${ssrInterpolate(_ctx.$t("messages.word.question"))}</span></span><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_publish"))}</span></li></ul></div></div></div><div class="col-lg-6 col-12 mb-4"><div class="card wallet-widget shadow-1"><div class="card-body"><div class="wallet-pattern"></div><div class="top-section"><h6>${ssrInterpolate(_ctx.$t("messages.word.wallet"))} ${ssrInterpolate(_ctx.$page.props.appName)}</h6><span>**** ****</span></div><div class="bottom-section"><div><h6 class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.wallet_amount"))}</h6><h4>${ssrInterpolate(_ctx.$page.props.auth.wallet.get_formatted_amount)} <span>${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></h4></div><div class="left"><p class="lts-05 fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.sentence.increase_amount"))}</p>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("user.wallet.index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="ri-add-line"${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "ri-add-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div></div></div></div><div class="row"><div class="col-12 last-order-list mb-4"><div class="panel-content--title lts-05 mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.latest_order_list"))}</div><div class="last-order-list--container">`);
      if (_ctx.orders.length == 0) {
        _push(`<div class="empty-list"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.orders.length > 0) {
        _push(`<div class="table-responsive"><table class="table"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.row"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.price"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.actions"))}</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(_ctx.orders, (order, index) => {
          _push(`<tr><td class="first-small">${ssrInterpolate(index + 1)}</td><td>${ssrInterpolate(unref(useNumberFormat)(order.get_total_bill.price + order.get_total_bill.send_price - (order.get_discount != null ? order.get_discount["amount"] : 0)))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td><td>${ssrInterpolate(order.uuid)}</td><td>`);
          if (order.status == "registered") {
            _push(`<span class="badge bg-info me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_review"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (order.status == "sent") {
            _push(`<span class="badge bg-success me-1">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (order.status == "cancelled") {
            _push(`<span class="badge bg-danger me-1">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (order.status == "delivered") {
            _push(`<span class="badge bg-success me-1">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (order.status == "returned") {
            _push(`<span class="badge bg-danger me-1">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</td><td>${ssrInterpolate(order.jalali_created_at[2])}</td><td class="first-small" style="${ssrRenderStyle({ "width": "150px" })}">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("user.orders.show", order.id),
            as: "button",
            class: "btn btn-sm btn-outline-light pt-1 pb-1 lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.details"))} <i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.details")) + " ", 1),
                  createVNode("i", { class: "ri-arrow-left-s-fill" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</td></tr>`);
        });
        _push(`<!--]--></tbody></table></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="col-lg-6 recent-viewed-list mb-4"><div class="panel-content--title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.recently_viewed"))}</div><div class="product-list">`);
      if (_ctx.product_hitsory.length == 0) {
        _push(`<div class="empty-list"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(_ctx.product_hitsory, (product) => {
        _push(`<!--[-->`);
        if (product.status == "publish") {
          _push(`<div class="card product-horizontal"><div class="card-body"><div class="product-horizontal--content d-flex flex-row align-items-center"><img${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.title)}><h3>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</h3></div><div class="product-horizontal--footer d-flex flex-row align-items-center justify-content-between"><div><ul class="product-colors el-center"><!--[-->`);
          ssrRenderList(product.unique_color, (color, index) => {
            _push(`<li style="${ssrRenderStyle({ "background-color": color.value.color })}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)}></li>`);
          });
          _push(`<!--]--></ul></div><div><span class="product-rating-average">${ssrInterpolate(product.comments_info.rating == "0" ? "-" : product.comments_info.rating)} <i class="ri-star-fill"></i></span><span class="divider">|</span>`);
          if (!product.in_stock_status) {
            _push(`<span class="product-price-now fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span>`);
          } else if (product.inventory) {
            _push(`<span class="product-price-now lts-05">${ssrInterpolate(unref(useNumberFormat)(product.best_price))} <span class="unit"></span></span>`);
          } else {
            _push(`<span class="product-price-now fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span>`);
          }
          _push(`</div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></div><div class="col-lg-6 favorite-list mb-4"><div class="panel-content--title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.recent_favorites"))}</div><div class="product-list">`);
      if (_ctx.product_favorites.length == 0) {
        _push(`<div class="empty-list"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(_ctx.product_favorites, (favorite, index) => {
        _push(`<!--[-->`);
        if (favorite.product.status == "publish") {
          _push(`<div class="card product-horizontal"><div class="card-body"><div class="product-horizontal--content d-flex flex-row align-items-center"><img${ssrRenderAttr("src", favorite.product.get_images[0]["link"])}${ssrRenderAttr("alt", favorite.product.title)}><h3>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", favorite.product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(favorite.product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(favorite.product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</h3></div><div class="product-horizontal--footer d-flex flex-row align-items-center justify-content-between"><div><ul class="product-colors el-center"><!--[-->`);
          ssrRenderList(favorite.product.unique_color, (color, index2) => {
            _push(`<li style="${ssrRenderStyle({ "background-color": color.value.color })}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)}></li>`);
          });
          _push(`<!--]--></ul></div><div><span class="product-rating-average">${ssrInterpolate(favorite.product.comments_info.rating == "0" ? "-" : favorite.product.comments_info.rating)} <i class="ri-star-fill"></i></span><span class="divider">|</span>`);
          if (!favorite.product.in_stock_status) {
            _push(`<span class="product-price-now fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span>`);
          } else if (favorite.product.inventory) {
            _push(`<span class="product-price-now lts-05">${ssrInterpolate(unref(useNumberFormat)(favorite.product.best_price))} <span class="unit"></span></span>`);
          } else {
            _push(`<span class="product-price-now fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span>`);
          }
          _push(`</div></div>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.favorites", favorite.product.slug),
            as: "button",
            method: "post",
            class: "remove-item btn"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-close-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-close-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Dashboard.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
