import { defineComponent, onMounted, reactive, ref, inject, watch, resolveDirective, unref, mergeProps, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderList, ssrRenderAttrs, ssrGetDirectiveProps, ssrRenderClass } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import $ from "jquery";
import { useForm, Head, Link } from "@inertiajs/vue3";
import SimpleBar from "simplebar";
import * as Coloris from "@melloware/coloris";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./FormatedNumInput-D4wHj270.js";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import { u as useNumberFormat } from "../ssr.js";
import { u as useNl2br } from "./useNl2br-BIw8h5gy.js";
import MultiSelect from "primevue/multiselect/multiselect.esm.js";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "./useRandomStr-4MeWbtRd.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    settings: {},
    paymentGatewayList: {},
    smsPanelList: {},
    smsPanelData: {},
    abandonedCartTimePeriodList: {}
  },
  setup(__props) {
    const props = __props;
    if (typeof window !== "undefined") {
      onMounted(() => {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: false
          });
        });
      });
    }
    $(() => {
      Coloris.init();
      Coloris.coloris({
        el: "#siteMainColor",
        alpha: false,
        selectInput: false,
        defaultColor: "#0060ff",
        swatches: ["#ffc107", "#f4a261", "#ff9c22", "#e76f51", "#fc5b61", "#dc3545", "#264653", "#2a9d8f", "#21d9c0", "#0097e6", "#07b", "#0060ff"]
      });
      Coloris.close();
    });
    const paymentGateway = reactive(
      props.settings["payment_gateway"] != null ? props.settings["payment_gateway"] : []
    );
    const selectedPaymentGateway = ref(null);
    const smsPanel = ref(props.settings["sms_panel"]);
    props.smsPanelList.forEach((item1) => {
      if (!smsPanel.value.panels.some((item2) => item2.id === item1.id)) {
        smsPanel.value.panels.push(item1);
      }
    });
    smsPanel.value.panels = JSON.parse(JSON.stringify(smsPanel.value.panels.filter((item2) => props.smsPanelList.some((item1) => item1.id === item2.id))));
    for (let panel of smsPanel.value.panels) {
      let newPanelPatterns = props.smsPanelList.find((item) => item.id === panel.id);
      if (newPanelPatterns != void 0) {
        newPanelPatterns = newPanelPatterns.fields["pattern"];
        if (newPanelPatterns != void 0) {
          for (let key in newPanelPatterns) {
            if (newPanelPatterns.hasOwnProperty(key) && !panel.fields["pattern"].hasOwnProperty(key)) {
              panel.fields["pattern"][key] = newPanelPatterns[key];
            }
          }
          for (let key in panel.fields["pattern"]) {
            if (panel.fields["pattern"].hasOwnProperty(key) && !newPanelPatterns.hasOwnProperty(key)) {
              delete panel.fields["pattern"][key];
            }
          }
        }
      }
    }
    const settingsForm = useForm({
      // main tab
      shop_full_title: props.settings["shop_full_title"],
      shop_title: props.settings["shop_title"],
      shop_h1: props.settings["shop_h1"],
      shop_description: props.settings["shop_description"],
      support_phone: props.settings["support_phone"],
      response_time: props.settings["response_time"],
      support_email: props.settings["support_email"],
      shop_address: props.settings["shop_address"],
      shop_address_town: props.settings["shop_address_town"],
      shop_address_city: props.settings["shop_address_city"],
      shop_address_postal_code: props.settings["shop_address_postal_code"],
      header_meta: props.settings["header_meta"],
      footer_meta: props.settings["footer_meta"],
      shop_map_location: props.settings["shop_map_location"],
      blog_title: props.settings["blog_title"],
      blog_description: props.settings["blog_description"],
      script_enamad: props.settings["script_enamad"],
      script_samandehi: props.settings["script_samandehi"],
      script_union: props.settings["script_union"],
      social_instagram: props.settings["social_instagram"],
      social_telegram: props.settings["social_telegram"],
      social_twitter: props.settings["social_twitter"],
      social_facebook: props.settings["social_facebook"],
      social_whatsapp: props.settings["social_whatsapp"],
      social_eita: props.settings["social_eita"],
      social_rubika: props.settings["social_rubika"],
      support_floating_button: Boolean(Number(props.settings["support_floating_button"])),
      instagram_support: props.settings["instagram_support"],
      telegram_phone: props.settings["telegram_phone"],
      whatsapp_phone: props.settings["whatsapp_phone"],
      static_phone: props.settings["static_phone"],
      mobile_phone: props.settings["mobile_phone"],
      // customer club tab
      customer_club: props.settings["customer_club"],
      silver_level: props.settings["silver_level"],
      gold_level: props.settings["gold_level"],
      // media tab
      logo: props.settings["logo"],
      logo_dark: props.settings["logo_dark"],
      watermark: props.settings["watermark"],
      favicon: props.settings["favicon"],
      site_main_color: props.settings["site_main_color"],
      // plugin tab
      payment_gateway_price_limit: props.settings["payment_gateway_price_limit"],
      payment_gateway: props.settings["payment_gateway"],
      sms_panel: props.settings["sms_panel"],
      neshan: props.settings["neshan"],
      // financial and stores tab
      store_register_status: props.settings["store_register_status"] + "",
      withdrawal_limit: useNumberFormat(props.settings["withdrawal_limit"]),
      wallet_charge_limit: useNumberFormat(props.settings["wallet_charge_limit"]),
      release_of_order_amounts: props.settings["release_of_order_amounts"],
      cashback_percent: props.settings["cashback_percent"],
      // cart
      vpn_warning: props.settings["vpn_warning"],
      abandoned_cart: props.settings["abandoned_cart"],
      product_statistics_status: props.settings["product_statistics_status"] === "1" ? true : false
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "logo" && media.file != null) {
        settingsForm.logo = {
          id: media.file.id,
          url: media.file.url
        };
      }
      if (media.type == "logo_dark" && media.file != null) {
        settingsForm.logo_dark = {
          id: media.file.id,
          url: media.file.url
        };
      }
      if (media.type == "watermark" && media.file != null) {
        settingsForm.watermark = {
          id: media.file.id,
          url: media.file.url
        };
      }
      if (media.type == "favicon" && media.file != null) {
        settingsForm.favicon = {
          id: media.file.id,
          url: media.file.url
        };
      }
    });
    const Map = ref();
    onMounted(() => {
      setTimeout(() => {
        var _a;
        (_a = Map.value) == null ? void 0 : _a.reverse([settingsForm.shop_map_location.longitude, settingsForm.shop_map_location.latitude], {
          useMarker: true
        });
      }, 1500);
    });
    const mapResult = (event) => {
      var _a;
      if (event.apiData !== void 0) {
        settingsForm.shop_map_location.longitude = event.coords[0];
        settingsForm.shop_map_location.latitude = event.coords[1];
        settingsForm.shop_map_location.zoom = (_a = Map.value) == null ? void 0 : _a.state.zoom;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.settings")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.settings")
      }, null, _parent));
      _push(`<div class="settings mb-5"><div class="simplebar-container"><ul class="nav nav-tabs nav-pager" id="settingsTab" role="tablist" style="${ssrRenderStyle({ "min-width": "900px" })}"><li class="nav-item" role="presentation"><button class="nav-link active" id="main-tab" data-bs-toggle="tab" data-bs-target="#main-tab-pane" type="button" role="tab" aria-controls="main-tab-pane" aria-selected="true">${ssrInterpolate(_ctx.$t("messages.word.main"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="customer-club-tab" data-bs-toggle="tab" data-bs-target="#customer-club-tab-pane" type="button" role="tab" aria-controls="customer-club-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="media-tab" data-bs-toggle="tab" data-bs-target="#media-tab-pane" type="button" role="tab" aria-controls="media-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.media"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="payment-tab" data-bs-toggle="tab" data-bs-target="#payment-tab-pane" type="button" role="tab" aria-controls="payment-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.payment_gateway"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="sms-tab" data-bs-toggle="tab" data-bs-target="#sms-tab-pane" type="button" role="tab" aria-controls="sms-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.sms_gateway"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="map-tab" data-bs-toggle="tab" data-bs-target="#map-tab-pane" type="button" role="tab" aria-controls="map-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.map"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="stores-tab" data-bs-toggle="tab" data-bs-target="#stores-tab-pane" type="button" role="tab" aria-controls="stores-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.financial_and_stores"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="cart-tab" data-bs-toggle="tab" data-bs-target="#cart-tab-pane" type="button" role="tab" aria-controls="cart-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.word.cart"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="torob-tab" data-bs-toggle="tab" data-bs-target="#torob-tab-pane" type="button" role="tab" aria-controls="torob-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.torob_and_emalls"))}</button></li></ul></div><form class="tab-content card" id="settingsTabContent"><div class="tab-pane fade show active" id="main-tab-pane" role="tabpanel" aria-labelledby="main-tab" tabindex="0"><div class="card-body pb-2"><div class="tab-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.shop_main_information"))}</div><div class="row"><div class="col-md-4 col-12 mb-4"><label for="eaStoreFullTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.shop_main_title"))}</label><input${ssrRenderAttr("value", unref(settingsForm).shop_full_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.shop_main_title_placeholder"))} class="form-control" id="eaStoreFullTitle"></div><div class="col-md-4 col-12 mb-4"><label for="eaStoreTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.shop_short_title"))}</label><input${ssrRenderAttr("value", unref(settingsForm).shop_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.shop_short_title_placeholder"))} class="form-control" id="eaStoreTitle"></div><div class="col-md-4 col-12 mb-4"><label for="eaStoreH1Title" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.shop_h1"))}</label><input${ssrRenderAttr("value", unref(settingsForm).shop_h1)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.shop_h1"))} class="form-control" id="eaStoreH1Title"></div><div class="col-sm-12 col-12 mb-4"><label for="eaStorDescription" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.shop_description"))}</label><textarea class="form-control lh-25" rows="4"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.shop_description_placeholder"))} id="eaStorDescription">${ssrInterpolate(unref(settingsForm).shop_description)}</textarea></div><div class="col-12 mb-4"><label for="eaStoreSupportTime" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.response_hours"))}</label><input${ssrRenderAttr("value", unref(settingsForm).response_time)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.response_hours_placeholder"))} class="form-control" id="eaStoreSupportTime"></div><div class="col-sm-6 col-12 mb-4"><label for="eaStorePhone" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.support_phone"))}</label><input${ssrRenderAttr("value", unref(settingsForm).support_phone)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.support_phone"))} class="form-control" id="eaStorePhone"></div><div class="col-sm-6 col-12 mb-4"><label for="eaStoreEmail" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.support_email"))}</label><input${ssrRenderAttr("value", unref(settingsForm).support_email)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.support_email"))} class="form-control" id="eaStoreEmail"></div></div><div class="col-12 mb-5"><div class="border"></div></div><div class="tab-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.blog_main_information"))}</div><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaBlogTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(settingsForm).blog_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.blog_main_title"))} class="form-control" id="eaBlogTitle"></div><div class="col-12 mb-4"><label for="eaBlogDescription" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label><textarea class="form-control lh-25" rows="4"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.blog_summary"))} id="eaBlogDescription">${ssrInterpolate(unref(settingsForm).blog_description)}</textarea></div></div><div class="col-12 mb-5"><div class="border"></div></div><div class="tab-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.header_and_footer_meta_tags"))}</div><div class="row"><div class="col-xl-6 col-12 mb-4"><label for="eaStorHeaderCode" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.head_codes"))}</label><textarea class="form-control" style="${ssrRenderStyle({ "direction": "ltr" })}"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.header_codes_placeholder"))} id="eaStorHeaderCode">${ssrInterpolate(unref(settingsForm).header_meta)}</textarea></div><div class="col-xl-6 col-12 mb-5"><label for="eaStorFooterCode" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.footer_codes"))}</label><textarea class="form-control" style="${ssrRenderStyle({ "direction": "ltr" })}"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.footer_codes_placeholder"))} id="eaStorFooterCode">${ssrInterpolate(unref(settingsForm).footer_meta)}</textarea></div></div><div class="col-12 mb-5"><div class="border"></div></div><div class="tab-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.shop_address_container"))}</div><div class="row"><div class="col-12 mb-4"><label for="eaStoreAddress" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}</label><input${ssrRenderAttr("value", unref(settingsForm).shop_address)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.shop_address"))} class="form-control" id="eaStoreAddress"></div><div class="col-sm-4 col-12 mb-4"><label for="eaStoreAddressTown" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.town"))}</label><input${ssrRenderAttr("value", unref(settingsForm).shop_address_town)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.town"))} class="form-control" id="eaStoreAddressTown"></div><div class="col-sm-4 col-12 mb-4"><label for="eaStoreAddressCity" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.city"))}</label><input${ssrRenderAttr("value", unref(settingsForm).shop_address_city)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.city"))} class="form-control" id="eaStoreAddressCity"></div><div class="col-sm-4 col-12 mb-4"><label for="eaStoreAddressPostalCode" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</label><input${ssrRenderAttr("value", unref(settingsForm).shop_address_postal_code)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.postal_code"))} class="form-control" id="eaStoreAddressPostalCode"></div><div class="col-12 mb-5"><div class="tab-title fs-8 fw-normal lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.select_main_address_from_map"))}</div><div class="map-container">`);
      _push(ssrRenderComponent(unref(NeshanMap), {
        ref_key: "Map",
        ref: Map,
        mapKey: _ctx.$page.props.neshan.map_key,
        serviceKey: _ctx.$page.props.neshan.service_key,
        center: unref(settingsForm).shop_map_location,
        zoom: unref(settingsForm).shop_map_location.zoom,
        defaultType: "neshan",
        hideLayers: true,
        traffic: false,
        cluster: false,
        hideSearchContainer: true,
        onOnClick: mapResult,
        class: "map"
      }, null, _parent));
      _push(`</div></div></div><div class="col-12 mb-5"><div class="border"></div></div><div class="tab-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.permissions_script_code"))}</div><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaStoreEnamad" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.enamad_script"))}</label><textarea class="form-control" id="eaStoreEnamad">${ssrInterpolate(unref(settingsForm).script_enamad)}</textarea></div><div class="col-sm-6 col-12 mb-4"><label for="eaStoreSamandehi" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.samandehi_script"))}</label><textarea class="form-control" id="eaStoreSamandehi">${ssrInterpolate(unref(settingsForm).script_samandehi)}</textarea></div><div class="col-sm-6 col-12 mb-4"><label for="eaStoreUnion" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.union_script"))}</label><textarea class="form-control" id="eaStoreUnion">${ssrInterpolate(unref(settingsForm).script_union)}</textarea></div></div><div class="col-12 mb-5"><div class="border"></div></div><div class="tab-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.social_links"))}</div><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaInstagram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.instagram"))}</label><input${ssrRenderAttr("value", unref(settingsForm).social_instagram)} type="text" class="form-control" id="eaInstagram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTelegram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.telegram"))}</label><input${ssrRenderAttr("value", unref(settingsForm).social_telegram)} type="text" class="form-control" id="eaTelegram"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTwitter" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.twitter"))}</label><input${ssrRenderAttr("value", unref(settingsForm).social_twitter)} type="text" class="form-control" id="eaTwitter"></div><div class="col-sm-6 col-12 mb-5"><label for="eaFacebook" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.facebook"))}</label><input${ssrRenderAttr("value", unref(settingsForm).social_facebook)} type="text" class="form-control" id="eaFacebook"></div><div class="col-sm-6 col-12 mb-5"><label for="eawhatsapp" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.whatsapp"))}</label><input${ssrRenderAttr("value", unref(settingsForm).social_whatsapp)} type="text" class="form-control" id="eawhatsapp"></div><div class="col-sm-6 col-12 mb-5"><label for="eaeita" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.eita"))}</label><input${ssrRenderAttr("value", unref(settingsForm).social_eita)} type="text" class="form-control" id="eaeita"></div><div class="col-sm-6 col-12 mb-5"><label for="earubika" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.rubika"))}</label><input${ssrRenderAttr("value", unref(settingsForm).social_rubika)} type="text" class="form-control" id="earubika"></div></div><div class="col-12 mb-5"><div class="border"></div></div><div class="tab-title lts-05 mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.support_floating_button"))}</div><div class="row"><div class="col-12 mb-3"><div class="form-check form-switch"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.support_floating_button_status"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(settingsForm).support_floating_button) ? ssrLooseContain(unref(settingsForm).support_floating_button, null) : unref(settingsForm).support_floating_button) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch"></label></div></div><div class="col-md-3 col-12 mb-4"><label for="eaTelegram" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.static_phone"))}</label><input${ssrRenderAttr("value", unref(settingsForm).static_phone)} type="text" class="form-control" id="eaTelegram"></div><div class="col-md-3 col-12 mb-4"><label for="eaTwitter" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.mobile_phone"))}</label><input${ssrRenderAttr("value", unref(settingsForm).mobile_phone)} type="text" class="form-control" id="eaTwitter"></div><div class="col-md-3 col-12 mb-4"><label for="eaFacebook" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.whatsapp_phone"))}</label><input${ssrRenderAttr("value", unref(settingsForm).whatsapp_phone)} type="text" class="form-control" id="eaFacebook"></div><div class="col-md-3 col-12 mb-4"><label for="eaFacebook" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.telegram_phone"))}</label><input${ssrRenderAttr("value", unref(settingsForm).telegram_phone)} type="text" class="form-control" id="eaFacebook"></div><div class="col-md-3 col-12 mb-4"><label for="eaFacebook" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.instagram_support"))}</label><input${ssrRenderAttr("value", unref(settingsForm).instagram_support)} type="text" class="form-control" id="eaFacebook"></div></div></div></div><div class="tab-pane fade" id="customer-club-tab-pane" role="tabpanel" aria-labelledby="customer-club-tab" tabindex="0"><div class="card-body row"><div class="col-12"><div class="tab-title lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.customer_club_score_by_price"))}</div><div class="row mb-3"><div class="col-sm-6 col-12 mb-2"><label for="eaCCPrice" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.price"))} <span class="currency">تومان</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(settingsForm).customer_club["price"],
        "onUpdate:modelValue": ($event) => unref(settingsForm).customer_club["price"] = $event,
        type: "text",
        class: "form-control",
        id: "eaCCPrice"
      }, null, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-2"><label for="eaCCScore" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.score"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(settingsForm).customer_club["score"],
        "onUpdate:modelValue": ($event) => unref(settingsForm).customer_club["score"] = $event,
        type: "text",
        class: "form-control",
        id: "eaCCScore"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><p class="lts-05 fs-8 text-gray mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_956611"))}</p></div></div><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.user_level_scores"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.msg_558154"))}</span></div></div><div class="row"><div class="col-sm-4 col-12 mb-2"><label for="eaBronzeLevel" class="form-label d-flex align-items-center">${ssrInterpolate(_ctx.$t("messages.word.bronze"))} <span class="d-inline-block bronze-circle ms-2"></span></label><input disabled value="سطح پیشفرض" type="text" class="form-control" id="eaBronzeLevel"></div><div class="col-sm-4 col-12 mb-2"><label for="eaSilverLevel" class="form-label d-flex align-items-center">${ssrInterpolate(_ctx.$t("messages.word.silver"))} <span class="d-inline-block silver-circle ms-2"></span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(settingsForm).silver_level,
        "onUpdate:modelValue": ($event) => unref(settingsForm).silver_level = $event,
        type: "text",
        class: "form-control",
        id: "eaSilverLevel"
      }, null, _parent));
      _push(`</div><div class="col-sm-4 col-12 mb-2"><label for="eaGoldLevel" class="form-label d-flex align-items-center">${ssrInterpolate(_ctx.$t("messages.word.gold"))} <span class="d-inline-block gold-circle ms-2"></span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(settingsForm).gold_level,
        "onUpdate:modelValue": ($event) => unref(settingsForm).gold_level = $event,
        type: "text",
        class: "form-control",
        id: "eaGoldLevel"
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="tab-pane fade" id="media-tab-pane" role="tabpanel" aria-labelledby="media-tab" tabindex="0"><div class="card-body row pb-2"><div class="col-12"><div class="row"><div class="col-lg-6 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.select_logo"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_logo_hint"))}</span></div></div><div class="mb-4"><div class="upload-box-container"><label class="form-label mb-0">${ssrInterpolate(_ctx.$t("messages.word.logo"))}</label><img class="logo-temp"${ssrRenderAttr("src", _ctx.$page.props.appUrl + unref(settingsForm).logo.url)} data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="logo"></div></div></div><div class="col-lg-6 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.select_logo_dark"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_logo_hint"))}</span></div></div><div class="mb-4"><div class="upload-box-container dark-always"><label class="form-label mb-0">${ssrInterpolate(_ctx.$t("messages.word.logo_dark"))}</label><img class="logo-temp"${ssrRenderAttr("src", _ctx.$page.props.appUrl + unref(settingsForm).logo_dark.url)} data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="logo_dark"></div></div></div><div class="col-lg-6 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.select_favicon"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_favicon_hint"))}</span></div></div><div class="mb-4"><div class="upload-box-container"><label class="form-label mb-0"> favicon </label><img class="logo-temp" style="${ssrRenderStyle({ "max-width": "30%" })}"${ssrRenderAttr("src", _ctx.$page.props.appUrl + unref(settingsForm).favicon.url)} data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="favicon"></div></div></div><div class="col-lg-6 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.select_watermark"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_watermark_hint"))}</span></div></div><div class="mb-4"><div class="upload-box-container"><label class="form-label mb-0">${ssrInterpolate(_ctx.$t("messages.word.watermark"))}</label><img class="logo-temp"${ssrRenderAttr("src", _ctx.$page.props.appUrl + unref(settingsForm).watermark.url)} data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="watermark"></div></div></div></div></div></div></div><div class="tab-pane fade" id="payment-tab-pane" role="tabpanel" aria-labelledby="payment-tab" tabindex="0"><div class="card-body pb-2"><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.payments_gateway"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_active_payment_gateway"))}</span></div></div><div class="select-gateway row"><div class="col-sm-6 col-12 mb-4"><label class="form-label lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.payment_gateway"))}</label><div class="d-flex">`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown flex-grow-1",
        modelValue: selectedPaymentGateway.value,
        "onUpdate:modelValue": ($event) => selectedPaymentGateway.value = $event,
        options: _ctx.paymentGatewayList,
        display: "chip",
        optionLabel: "label",
        placeholder: _ctx.$t("messages.sentence.select_payment_gateway")
      }, null, _parent));
      _push(`<button type="button" class="btn btn-primary btn-square shadow-1 ms-2"><i class="ri-add-line"></i></button></div></div><div class="col-sm-6 col-12 mb-4"><label for="eaPGPriceLimit" class="form-label mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.payment_gateway_price_limit"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(settingsForm).payment_gateway_price_limit,
        "onUpdate:modelValue": ($event) => unref(settingsForm).payment_gateway_price_limit = $event,
        type: "text",
        class: "form-control",
        id: "eaPGPriceLimit"
      }, null, _parent));
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_544112"))}</span></div><div class="col-12 mb-4"><!--[-->`);
      ssrRenderList(paymentGateway, (pg, index) => {
        _push(`<div class="gateway-information mb-3"><div class="row"><div class="col-12 mb-2"><span class="gateway--title d-flex align-items-center justify-content-between lts-05"><span>${ssrInterpolate(pg.label)}</span><span></span></span></div>`);
        if (pg.id == "snapppay") {
          _push(`<div class="mb-4 mt-3"><div class="bg-dark br-20 d-inline-flex flex-column py-3 px-3"><span class="text-dark lts-05 fs-8 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_550021250"))}:</span><div class="clickable alert alert-info mb-0">${ssrInterpolate(_ctx.route("snapppay.products"))}</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--[-->`);
        ssrRenderList(pg.fields, (field, field_index) => {
          _push(`<div class="col-sm-6 col-12 mb-4">`);
          if (field_index == "mode" || field_index == "sandbox") {
            _push(`<!--[--><!--]-->`);
          } else {
            _push(`<label class="form-label">${ssrInterpolate(field.label)} <input${ssrRenderAttr("value", field.value)} type="text" name="pygt" class="form-control payment-gateway-field" style="${ssrRenderStyle({ "direction": "ltr" })}"></label>`);
          }
          _push(`</div>`);
        });
        _push(`<!--]--><div class="col-12 mb-3"><div class="d-flex align-items-center justify-content-end">`);
        if (pg.status) {
          _push(`<button type="button" class="btn btn-switch btn-on fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.active"))}</button>`);
        } else {
          _push(`<button type="button" class="btn btn-switch btn-off fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</button>`);
        }
        _push(`<button type="button" class="btn btn-white btn-square btn-xs"><i class="ri-close-line"></i></button></div></div></div></div>`);
      });
      _push(`<!--]--></div><div class="col-12 mb-4"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.payment_gateway_callback_url"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.payment_gateway_callback_url_hint"))}</span></div></div><div class="row"><div class="col-12"><div${ssrRenderAttrs(mergeProps({
        class: "alert alert-info d-inline-block clickable",
        draggable: "false",
        style: { "direction": "ltr", "user-select": "none" }
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.click_to_copy"), void 0, { top: true })))}>${ssrInterpolate(_ctx.route("cart.payment.callback_get"))}</div></div></div></div></div></div></div><div class="tab-pane fade" id="sms-tab-pane" role="tabpanel" aria-labelledby="sms-tab" tabindex="0"><div class="card-body pb-2"><div class="tab-title d-flex align-items-center justify-content-between lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.sms_panel"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.select_active_sms_panel"))}</span></div></div><div class="select-gateway row"><div class="col-12 mb-4"><!--[-->`);
      ssrRenderList(smsPanel.value.panels, (panel, index) => {
        _push(`<div class="gateway-information mb-4"><div class="row"><div class="col-12 d-flex align-items-center justify-content-between mb-3"><span class="gateway--title lts-05"><span>${ssrInterpolate(panel["label"])}</span></span><div class="d-flex align-items-center justify-content-end"><button type="button" class="${ssrRenderClass({ "btn btn-switch fs-9 ms-2": true, "btn-on": smsPanel.value.active == panel.id, "btn-off": smsPanel.value.active != panel.id })}">${ssrInterpolate(smsPanel.value.active == panel.id ? _ctx.$t("messages.word.active") : _ctx.$t("messages.word.deactive"))}</button></div></div><div class="col-12 mb-4"><div>`);
        if (_ctx.smsPanelData[panel["id"]]["data"]["credit"] == "timeout") {
          _push(`<span class="text-danger lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.panel_not_connected_timeout"))}</span>`);
        } else {
          _push(`<!--[-->`);
          if (_ctx.smsPanelData[panel["id"]]["data"]["credit"] != null) {
            _push(`<div><span class="text-success lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.credit"))}: </span><span class="fw-bold text-dark">${ssrInterpolate(unref(useNumberFormat)(_ctx.smsPanelData[panel["id"]]["data"]["credit"]))}</span>`);
            if (panel.id == "smsir" || panel.id == "melipayamak") {
              _push(`<span class="text-gray fs-8 lts-05 ms-1">${ssrInterpolate(_ctx.$t("messages.word.sms"))}</span>`);
            } else {
              _push(`<span class="unit unit-sm"></span>`);
            }
            _push(`</div>`);
          } else {
            _push(`<div><span class="text-danger lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.panel_not_connected"))}</span></div>`);
          }
          _push(`<!--]-->`);
        }
        _push(`</div></div>`);
        if (smsPanel.value.active == panel.id) {
          _push(`<!--[--><!--[-->`);
          ssrRenderList(panel["fields"]["information"], (field, field_index) => {
            _push(`<div class="col-sm-6 col-12 mb-4"><label class="form-label">${ssrInterpolate(field_index)} <input${ssrRenderAttr("value", panel["fields"]["information"][field_index])} type="text" name="smsinf" class="form-control payment-gateway-field" style="${ssrRenderStyle({ "direction": "ltr" })}"></label></div>`);
          });
          _push(`<!--]--><div class="col-12 mb-4"><div class="px-3"><div class="row" style="${ssrRenderStyle({ "background-color": "#e6e9ed" })}"><div class="col-12 mb-3"><span class="fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.sms_pattern_codes"))}</span></div><!--[-->`);
          ssrRenderList(panel["fields"]["pattern"], (pattern, pattern_index) => {
            _push(`<!--[--><div class="sms-pattern-field col-md-3 col-sm-6 col-12 mb-3"><label class="form-label"><div class="d-flex align-items-center mb-2"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.pattern_code_number"))}:</span><span class="fw-bold ms-1">${ssrInterpolate(pattern["id"])}</span></div><div class="input-container"><input${ssrRenderAttr("value", panel["fields"]["pattern"][pattern_index]["value"])} type="text" name="smsptrn" class="form-control payment-gateway-field m-0" style="${ssrRenderStyle({ "direction": "ltr" })}"><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#pattern-guide-" + pattern["id"])} type="button" class="info-button btn btn-square btn-light btn-xs"><i class="ri-file-list-2-line"></i></button></div></label></div><div class="modal fade sms-pattern-guide-modal"${ssrRenderAttr("id", "pattern-guide-" + pattern["id"])} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5"><span>${ssrInterpolate(_ctx.$t("messages.sentence.sms_pattern_guide_number"))}: </span> ${ssrInterpolate(pattern["id"])}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row" style="${ssrRenderStyle({ "background-color": "transparent !important" })}"><div class="col-12 mb-4"><span class="fs-8 lh-25 text-gray lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_540051"))}</span></div><div class="col-12 mb-4"><div class="d-flex align-items-center justify-content-between"><span class="fw-bold mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.pattern_text"))}:</span></div><div class="pattern-text card bg-light"><div class="card-body p-3 px-4"><button${ssrRenderAttrs(mergeProps({
              type: "button",
              class: "btn btn-square btn-xs btn-white"
            }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.copy_pattern"))))}><i class="ri-clipboard-line"></i></button><div class="fs-7 fw-bold lh-25 mt-4 pt-3">${unref(useNl2br)(_ctx.smsPanelData[panel["id"]]["patterns"].find((p) => p.id === pattern["id"])["text"]) ?? ""}</div></div></div></div><div class="col-12 mb-4"><span class="alert alert-warning d-flex lts-05 lh-25">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_123963"))}</span></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" type="button">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></div></div></div><!--]-->`);
          });
          _push(`<!--]--></div></div></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div></div></div></div><div class="tab-pane fade" id="map-tab-pane" role="tabpanel" aria-labelledby="map-tab" tabindex="0"><div class="card-body"><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.neshan_map"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.neshan_map_api_information"))}</span></div></div><div class="select-gateway row"><div class="col-sm-6 col-12 mb-4"><label for="eaNeshanMapKey" class="form-label">map key</label><input${ssrRenderAttr("value", unref(settingsForm).neshan.map_key)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.type_of_web_map"))} class="form-control" id="eaNeshanMapKey"></div><div class="col-sm-6 col-12 mb-4"><label for="eaNeshanServiceKey" class="form-label">service key</label><input${ssrRenderAttr("value", unref(settingsForm).neshan.service_key)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.type_of_services"))} class="form-control" id="eaNeshanServiceKey"></div><div class="col-12"><p class="alert alert-warning fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_866325"))}</p></div></div></div></div><div class="tab-pane fade" id="stores-tab-pane" role="tabpanel" aria-labelledby="stores-tab" tabindex="0"><div class="card-body"><div class="row"><div class="col-sm-6 col-12 mb-4"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.marketplace_status"))}</div></div><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.is_register_new_seller_active"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(settingsForm).store_register_status) ? ssrLooseContain(unref(settingsForm).store_register_status, null) : unref(settingsForm).store_register_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch"></label></div></div><div class="col-sm-6 col-12 mb-4"><label for="eaReleaseOfOrderAmounts" class="form-label fw-bold"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.change_to_delivered"))}: </span><span class="badge bg-info" style="${ssrRenderStyle({ "font-size": "13px !important", "font-weight": "bold !important" })}">${ssrInterpolate(unref(settingsForm).release_of_order_amounts + " " + _ctx.$t("messages.word.day"))}</span><span class="text-gray lts-05 fs-10 fw-normal ms-1">${ssrInterpolate(_ctx.$t("messages.sentence.after_send"))}</span></label><input${ssrRenderAttr("value", unref(settingsForm).release_of_order_amounts)} id="eaReleaseOfOrderAmounts" type="range" class="form-range" min="0" max="30" step="1"><span class="lts-05 fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548025"))}</span></div><div class="col-sm-6 col-12 mb-5"><label for="eaWithdrawalLimit" class="form-label d-flex align-items-center fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.withdrawal_limit"))} <span class="badge bg-light text-dark ms-1">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(settingsForm).withdrawal_limit,
        "onUpdate:modelValue": ($event) => unref(settingsForm).withdrawal_limit = $event,
        type: "text",
        class: "form-control",
        id: "eaWithdrawalLimit"
      }, null, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-5"><label for="eaWalletChargeLimit" class="form-label d-flex align-items-center fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.max_wallet_charge_limit"))} <span class="badge bg-light text-dark ms-1">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(settingsForm).wallet_charge_limit,
        "onUpdate:modelValue": ($event) => unref(settingsForm).wallet_charge_limit = $event,
        type: "text",
        class: "form-control",
        id: "eaWalletChargeLimit"
      }, null, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaReleaseOfOrderAmounts" class="form-label fw-bold"><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.cashback_percent"))}: </span><span class="badge bg-info" style="${ssrRenderStyle({ "font-size": "13px !important", "font-weight": "bold !important" })}">${ssrInterpolate(unref(settingsForm).cashback_percent + "%")}</span></label><input${ssrRenderAttr("value", unref(settingsForm).cashback_percent)} id="eaReleaseOfOrderAmounts" type="range" class="form-range" min="0" max="100" step="1"><span class="lts-05 fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_10021540"))}</span></div></div></div></div><div class="tab-pane fade" id="cart-tab-pane" role="tabpanel" aria-labelledby="cart-tab" tabindex="0"><div class="card-body p-4 pb-2"><div class="row mb-4"><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.vpn_warning"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.vpn_warning_hint"))}</span></div></div><div class="col-12 mb-4"><div class="d-inline-block bg-light p-3 br-15">`);
      if (unref(settingsForm).vpn_warning == "1") {
        _push(`<button type="button" class="btn btn-switch btn-on fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.active"))}</button>`);
      } else {
        _push(`<button type="button" class="btn btn-switch btn-off fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</button>`);
      }
      _push(`</div></div></div><div class="row mb-4"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.abandoned_cart_settings"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.abandoned_cart_settings_hint"))}</span></div></div><div class="row"><div class="col-12 mb-4"><span class="d-inline-block lts-05 alert alert-info text-info fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_519996"))}</span></div><div class="col-md-3 col-12 mb-4"><label class="form-label lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.word.status"))}</label><div class="col-12 mb-4"><div class="d-inline-block bg-light p-3 br-15">`);
      if (unref(settingsForm).abandoned_cart.status) {
        _push(`<button type="button" class="btn btn-switch btn-on fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.active"))}</button>`);
      } else {
        _push(`<button type="button" class="btn btn-switch btn-off fs-9 me-2">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</button>`);
      }
      _push(`</div></div></div><div class="col-md-9 col-12 mb-4"><label class="form-label lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.abandoned_cart_time_period"))}</label>`);
      _push(ssrRenderComponent(unref(MultiSelect), {
        class: "pvc-dropdown flex-grow-1",
        modelValue: unref(settingsForm).abandoned_cart.time_period,
        "onUpdate:modelValue": ($event) => unref(settingsForm).abandoned_cart.time_period = $event,
        options: _ctx.abandonedCartTimePeriodList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_payment_gateway")
      }, null, _parent));
      _push(`</div></div><div class="row mb-4"><div class="col-sm-6 col-12"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.product_statistics"))}</div></div><div class="form-check form-switch"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_statistics_status"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(settingsForm).product_statistics_status) ? ssrLooseContain(unref(settingsForm).product_statistics_status, null) : unref(settingsForm).product_statistics_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch"></label></div></div></div></div></div></div><div class="tab-pane fade" id="torob-tab-pane" role="tabpanel" aria-labelledby="torob-tab" tabindex="0"><div class="card-body pb-2"><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.torob_api_link"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.torob_hint"))}</span></div></div><div class="row mb-4"><div class="col-12"><div${ssrRenderAttrs(mergeProps({
        class: "alert alert-info d-inline-block clickable",
        draggable: "false",
        style: { "direction": "ltr", "user-select": "none" }
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.click_to_copy"), void 0, { top: true })))}>${ssrInterpolate(_ctx.route("torob.products"))}</div></div></div><div class="tab-title lts-05 mb-3"><div>${ssrInterpolate(_ctx.$t("messages.sentence.emalls_api_link"))} <span>${ssrInterpolate(_ctx.$t("messages.sentence.emalls_hint"))}</span></div></div><div class="row mb-4"><div class="col-12"><div${ssrRenderAttrs(mergeProps({
        class: "alert alert-info d-inline-block clickable",
        draggable: "false",
        style: { "direction": "ltr", "user-select": "none" }
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.click_to_copy"), void 0, { top: true })))}>${ssrInterpolate(_ctx.route("emalls.products"))}</div></div></div></div></div><div class="float-button-bar card d-inline-flex"><div class="card-body"><div class="col-12 d-flex align-items-center justify-content-center">`);
      _push(ssrRenderComponent(unref(Link), {
        as: "button",
        href: _ctx.route("admin.dashboard"),
        class: "btn btn-white lts-05 shadow-1 me-3"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.word.cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.word.cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<button type="submit" class="btn btn-primary lts-05 shadow-1"${ssrIncludeBooleanAttr(unref(settingsForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))} `);
      if (unref(settingsForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></div></div></form></div><div class="w-100 d-block mb-5" style="${ssrRenderStyle({ "height": "15px" })}"></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Settings/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
