import { defineComponent, ref, inject, watch, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./Ckeditor-BEPE8WxA.js";
import { _ as _sfc_main$4 } from "./Tagify-DYepU4nx.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "./useRandomStr-4MeWbtRd.js";
import "@yaireo/tagify";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    brand: {}
  },
  setup(__props) {
    const props = __props;
    const logoImage = ref(props.brand.get_logo);
    const logoImageID = ref(props.brand.logo);
    const bannerImage = ref(props.brand.get_banner);
    const bannerImageID = ref(props.brand.banner);
    const editBrandForm = useForm({
      banner: bannerImageID.value,
      logo: logoImageID.value,
      title: props.brand.title,
      title_en: props.brand.title_en,
      website: props.brand.website,
      slug: props.brand.slug,
      content: props.brand.content,
      seo_title: props.brand.seo_title,
      seo_description: props.brand.seo_description,
      seo_keywords: props.brand.seo_keywords,
      seo_canonical: props.brand.seo_canonical
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "logo" && media.file != null) {
        logoImage.value = media.file.url;
        logoImageID.value = media.file.id + "";
      }
      if (media.type == "banner" && media.file != null) {
        bannerImage.value = media.file.url;
        bannerImageID.value = media.file.id + "";
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_brand")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_brand")
      }, null, _parent));
      _push(`<div class="category-add mb-4"><div class="card"><form class="card-body p-4"><div class="row"><div class="col-12 brand-header mb-5">`);
      if (bannerImage.value != null) {
        _push(`<button type="button" class="btn btn-square btn-xs btn-danger remove-banner mb-2"><i class="ri-close-line"></i></button>`);
      } else {
        _push(`<!---->`);
      }
      if (bannerImage.value != null) {
        _push(`<div class="image clickable" style="${ssrRenderStyle("background-image: url(" + bannerImage.value + ")")}" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="banner"></div>`);
      } else {
        _push(`<div class="upload-file-container upload"><div class="form-element-row form-element-row-file"><div class="text-center"><div class="fs-6 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.select_brand_banner"))}</div><div class="fs-7 text-muted mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.image_allowed_size"))}</div></div><div class="custom-input-file"><span data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="banner" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></span></div></div></div>`);
      }
      _push(`</div><div class="col-12 icon-container d-flex align-items-center mb-5"><img width="100" height="100"${ssrRenderAttr("src", logoImage.value)} class="shadow-1 br-15"><div class="edit-link"><button type="button" class="btn btn-light shadow-1 lts-05" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="logo"><i class="ri-add-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_logo"))}</button><div class="image-information">(${ssrInterpolate(_ctx.$t("messages.sentence.brand_logo_is_optional"))})</div></div></div><div class="col-sm-12 col-12 mb-4"><label for="eaTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(editBrandForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.brand"))} class="form-control" id="eaTitle"></div><div class="col-sm-4 col-12 mb-4"><label for="eaTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.english"))}</label><input${ssrRenderAttr("value", unref(editBrandForm).title_en)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.english"))} class="form-control" id="eaTitle"></div><div class="col-sm-4 col-12 mb-4"><label for="eaWebsite" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.official_website"))}</label><input${ssrRenderAttr("value", unref(editBrandForm).website)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.official_website"))} class="form-control" id="eaWebsite"></div><div class="col-sm-4 col-12 mb-4"><label for="eaSlug" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrRenderAttr("value", unref(editBrandForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaSlug"></div></div><div class="row"><div class="col-12 mb-4"><label class="form-label mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editBrandForm).content,
        "onUpdate:modelValue": ($event) => unref(editBrandForm).content = $event
      }, null, _parent));
      _push(`</div></div><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(editBrandForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(editBrandForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(editBrandForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(editBrandForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(editBrandForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div><div class="row mt-4"><div class="col-12 d-flex align-items-center justify-content-end"><button${ssrIncludeBooleanAttr(unref(editBrandForm).processing) ? " disabled" : ""} type="submit" class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.edit_brand"))}</button></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Brand/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
