import { defineComponent, ref, reactive, watch, inject, unref, withCtx, createVNode, createBlock, createCommentVNode, createTextVNode, openBlock, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderClass, ssrRenderList, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { _ as _sfc_main$3 } from "./Tagify-DYepU4nx.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import AutoComplete from "primevue/autocomplete/autocomplete.esm.js";
import axios from "axios";
import $ from "jquery";
import { _ as _sfc_main$4 } from "./Ckeditor-BEPE8WxA.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "@yaireo/tagify";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    product: {},
    categories: {}
  },
  setup(__props) {
    const props = __props;
    const brandItems = ref([]);
    const searchBrand = (event) => {
      axios.get(route("seller.brands.search"), {
        params: {
          search: event.query
        }
      }).then(function(response) {
        let brands = response.data;
        brandItems.value = brands;
        if (brands.length > 0) {
          $(".p-autocomplete-panel").show();
        } else {
          $(".p-autocomplete-panel").hide();
        }
      }).catch(function(error) {
        console.log(error);
      });
    };
    const categoriesList = ref([]);
    for (let category2 in props.categories) {
      categoriesList.value.push(props.categories[category2]);
    }
    const imagesID = ref(props.product.get_images_id);
    const imagesUrls = ref(props.product.get_images_link);
    const attrs = reactive(props.product.get_attrs);
    let findCategory = props.categories.filter((cat) => {
      if (cat.id == props.product.category["id"]) {
        return true;
      } else {
        return false;
      }
    })[0];
    const category = ref(findCategory);
    let specificationsGroups = reactive(category.value.specifications);
    let priceModel = reactive(props.product.price_model);
    const editProductForm = useForm({
      title: props.product.title,
      title_en: props.product.title_en,
      slug: props.product.slug,
      tags: props.product.get_tags_string,
      brand: props.product.brand != null ? props.product.brand.title : props.product.brand,
      category: category.value,
      content: props.product.content,
      warnings: props.product.warnings,
      images: imagesID.value,
      attrs,
      specifications: specificationsGroups,
      seo_title: props.product.seo_title,
      seo_description: props.product.seo_description,
      seo_keywords: props.product.seo_keywords,
      seo_canonical: props.product.seo_canonical,
      in_stock_status: props.product.in_stock_status,
      inquiry_options: props.product.get_inquiry_options,
      question_status: props.product.question_status ? true : false,
      comment_status: props.product.comment_status ? true : false,
      status: props.product.status
    });
    watch(category, (value) => {
      specificationsGroups = value.specifications;
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "product" && media.file != null) {
        imagesID.value.push(media.file.id);
        imagesUrls.value.push(media.file.url);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_product")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_product")
      }, null, _parent));
      if (_ctx.product.status == "rejected") {
        _push(`<div class="d-block mb-1"><div class="d-inline-flex text-danger alert alert-danger"><span class="lts-05 d-flex flex-column lh-25 fs-8"><span class="fw-bold mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.product_rejection_reason"))}:</span><span>${_ctx.product.reason ?? ""}</span></span></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="add-product row mb-4"><div class="col-12"><form><div class="card mb-4"><div class="card-body"><div class="pills-tab-container d-flex align-items-start"><div class="action-sidebar"><div class="nav flex-column nav-pills mb-md-4 mb-5" id="v-pills-tab" role="tablist" aria-orientation="vertical"><button class="nav-link active" id="v-pills-main-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main" type="button" role="tab" aria-controls="v-pills-main" aria-selected="true"><i class="ri-keyboard-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.main_information"))}</button><button class="nav-link" id="v-pills-seo-tab" data-bs-toggle="pill" data-bs-target="#v-pills-seo" type="button" role="tab" aria-controls="v-pills-seo" aria-selected="false"><i class="ri-seo-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.seo_settings"))}</button><button class="nav-link" id="v-pills-images-tab" data-bs-toggle="pill" data-bs-target="#v-pills-images" type="button" role="tab" aria-controls="v-pills-images" aria-selected="false"><i class="ri-image-edit-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.media_and_images"))}</button><button class="nav-link" id="v-pills-specification-tab" data-bs-toggle="pill" data-bs-target="#v-pills-specification" type="button" role="tab" aria-controls="v-pills-specification" aria-selected="false"><i class="ri-list-check-2"></i> ${ssrInterpolate(_ctx.$t("messages.word.specifications"))}</button><button class="nav-link" id="v-pills-price-tab" data-bs-toggle="pill" data-bs-target="#v-pills-price" type="button" role="tab" aria-controls="v-pills-price" aria-selected="false"><i class="ri-price-tag-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.price_model"))}</button></div><div class="action-container d-md-block d-none mb-4"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_questions"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editProductForm).question_status) ? ssrLooseContain(unref(editProductForm).question_status, null) : unref(editProductForm).question_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editProductForm).comment_status) ? ssrLooseContain(unref(editProductForm).comment_status, null) : unref(editProductForm).comment_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><button class="btn btn-primary mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.submit_for_approval"))}</button><span class="lts-05 fs-9 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_853265"))}</span></div></div><div class="tab-content" id="v-pills-tabContent"><div class="tab-pane fade show active" id="v-pills-main" role="tabpanel" aria-labelledby="v-pills-main-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(editProductForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.product_main_title"))} class="form-control" id="eaTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaEnTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.english_title"))}</label><input${ssrRenderAttr("value", unref(editProductForm).title_en)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.product_english_title"))} class="form-control" id="eaEnTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaCategories" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.categories"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: category.value,
        "onUpdate:modelValue": ($event) => category.value = $event,
        options: categoriesList.value,
        filter: "",
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionLabel: "title",
        placeholder: _ctx.$t("messages.sentence.select_category")
      }, {
        option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="category-template flex align-items-center"${_scopeId}><div class="${ssrRenderClass({
              "category-level-one": slotProps.option.level == "one",
              "category-level-two": slotProps.option.level == "two",
              "category-level-three": slotProps.option.level == "three"
            })}"${_scopeId}>`);
            if (slotProps.option.level == "three") {
              _push2(`<span${_scopeId}><i class="ri-arrow-drop-left-line"${_scopeId}></i></span>`);
            } else if (slotProps.option.level == "two") {
              _push2(`<span${_scopeId}><i class="circle-icon ri-circle-fill"${_scopeId}></i></span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(` ${ssrInterpolate(slotProps.option.title)}</div></div>`);
          } else {
            return [
              createVNode("div", { class: "category-template flex align-items-center" }, [
                createVNode("div", {
                  class: {
                    "category-level-one": slotProps.option.level == "one",
                    "category-level-two": slotProps.option.level == "two",
                    "category-level-three": slotProps.option.level == "three"
                  }
                }, [
                  slotProps.option.level == "three" ? (openBlock(), createBlock("span", { key: 0 }, [
                    createVNode("i", { class: "ri-arrow-drop-left-line" })
                  ])) : slotProps.option.level == "two" ? (openBlock(), createBlock("span", { key: 1 }, [
                    createVNode("i", { class: "circle-icon ri-circle-fill" })
                  ])) : createCommentVNode("", true),
                  createTextVNode(" " + toDisplayString(slotProps.option.title), 1)
                ], 2)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaEnTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrRenderAttr("value", unref(editProductForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaEnTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTags" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.tags"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editProductForm).tags,
        "onUpdate:modelValue": ($event) => unref(editProductForm).tags = $event
      }, null, _parent));
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.write_tag_name_and_press_enter"))}</span></div><div class="col-sm-6 col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.brand"))}</label>`);
      _push(ssrRenderComponent(unref(AutoComplete), {
        onKeydown: () => {
        },
        modelValue: unref(editProductForm).brand,
        "onUpdate:modelValue": ($event) => unref(editProductForm).brand = $event,
        dropdown: "",
        suggestions: brandItems.value,
        onComplete: searchBrand,
        placeholder: _ctx.$t("messages.sentence.product_brand")
      }, null, _parent));
      _push(`<span class="form-control-description lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.select_exist_brand_or_write_new_one"))}</span></div><div class="col-12 mb-4"><label for="eaWarnings" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.warning_and_description"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.warning_and_description_optional"))} class="form-control" id="eaWarnings">${ssrInterpolate(unref(editProductForm).warnings)}</textarea></div><div class="col-12 mb-4"><label class="form-label mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.review"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(editProductForm).content,
        "onUpdate:modelValue": ($event) => unref(editProductForm).content = $event
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="v-pills-seo" role="tabpanel" aria-labelledby="v-pills-seo-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(editProductForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editProductForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(editProductForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(editProductForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(editProductForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div></div><div class="tab-pane fade" id="v-pills-images" role="tabpanel" aria-labelledby="v-pills-images-tab" tabindex="0"><div class="row image-container"><div class="col-12"><div class="form-label fw-bold mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.product_image_gallery"))}</div></div><!--[-->`);
      ssrRenderList(imagesUrls.value, (imagesUrl, index) => {
        _push(`<div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 mb-4"><div class="image-grid"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + imagesUrl + ")")}"></div></div></div><i class="remove-image ri-close-line"></i></div></div>`);
      });
      _push(`<!--]--><div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 col-12 mb-4"><div data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="product" class="image-grid select-image"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="select-image-details"><i class="ri-image-add-line"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.add_image"))}</span></div></div></div></div></div></div></div><div class="tab-pane fade" id="v-pills-specification" role="tabpanel" aria-labelledby="v-pills-specification-tab" tabindex="0"><div x-data="property()" class="property mb-4"><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.outstanding_properties"))} <span class="mt-1">${ssrInterpolate(_ctx.$t("messages.sentence.enter_product_some_properties"))}</span></div><button type="button" class="btn btn-square btn-primary shadow-1"><i class="ri-add-line"></i></button></div><div id="propertyContainer" class="property-items"><!--[-->`);
      ssrRenderList(attrs, (attr, index) => {
        _push(`<div class="property-item mb-3"><div class="row"><div class="col-sm-6 col-12 mb-2"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))} <input${ssrRenderAttr("value", attr.key)} type="text" name="property[123456][key]" class="form-control"></label></div><div class="col-sm-6 col-12 mb-2"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.value"))} <input${ssrRenderAttr("value", attr.value)} type="text" name="property[123456][value]" class="form-control"></label></div></div><i class="remove-property-item ri-close-line"></i></div>`);
      });
      _push(`<!--]--></div></div><div class="border mb-4"></div><div class="tab-title lts-05 mb-4"><div>${ssrInterpolate(_ctx.$t("messages.sentence.specifications_table"))} <span class="input-desc">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_541112"))}</span></div></div><div class="row specification"><div id="specificationContainer" class="col-12 specification-items"><!--[-->`);
      ssrRenderList(unref(specificationsGroups), (group, group_index) => {
        _push(`<div class="specification-item mb-3"><div class="tab-title mb-3">${ssrInterpolate(group.title)}</div><div class="sub"><!--[-->`);
        ssrRenderList(group.keys, (key, key_index) => {
          _push(`<div class="row sub-item mb-1"><div class="col-sm-6 col-12 d-flex align-items-center p-2 ps-3 mb-1 mb-md-0">${ssrInterpolate(key.key)}</div><div class="col-sm-6 col-12 p-0 ps-md-2"><input${ssrRenderAttr("value", key.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.specification_value"))} class="form-control"></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      });
      _push(`<!--]--></div></div></div><div class="tab-pane fade" id="v-pills-price" role="tabpanel" aria-labelledby="v-pills-price-tab" tabindex="0"><div class="col-12 mb-4"><div class="product-price-model"><div class="title lts-05 mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.determine_sale_variables"))}</div><div class="text-warning lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_445872"))}</div>`);
      if (unref(priceModel).length == 0) {
        _push(`<div class="lts-05 shadow-1 d-inline-block simple-price">${ssrInterpolate(_ctx.$t("messages.sentence.simple_price_model"))}</div>`);
      } else {
        _push(`<ul><!--[-->`);
        ssrRenderList(unref(priceModel), (pm, index) => {
          _push(`<li class="shadow-1"><div class="form-control-container"><input${ssrRenderAttr("value", pm.name)} class="form-control" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.sale_variable_name"))} disabled></div></li>`);
        });
        _push(`<!--]--></ul>`);
      }
      _push(`</div></div><div class="price-list"><p class="description lts-05">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.inventories.index", _ctx.product.slug),
        as: "button",
        class: "btn btn-light lts-05"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.manage_product_inventory"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.manage_product_inventory")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</p></div></div></div></div><div class="action-container d-md-none d-block mt-4"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_questions"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editProductForm).question_status) ? ssrLooseContain(unref(editProductForm).question_status, null) : unref(editProductForm).question_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editProductForm).comment_status) ? ssrLooseContain(unref(editProductForm).comment_status, null) : unref(editProductForm).comment_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><button class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.submit_for_approval"))}</button></div></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Products/Products/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
