import { defineComponent, ref, inject, watch, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$3 } from "./Tagify-DYepU4nx.js";
import { _ as _sfc_main$4 } from "./Ckeditor-BEPE8WxA.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import axios from "axios";
import AutoComplete from "primevue/autocomplete/autocomplete.esm.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "@yaireo/tagify";
import "./useRandomStr-4MeWbtRd.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    article: {},
    categories: {},
    statusList: {},
    articleTypeList: {}
  },
  setup(__props) {
    const props = __props;
    const image = ref(props.article.get_image.url);
    const category = ref(
      props.categories.filter((cat) => {
        if (cat.id == props.article.category_id) {
          return true;
        } else {
          return false;
        }
      })[0]
    );
    const brandItems = ref([]);
    const searchBrand = (event) => {
      axios.get(route("admin.brands.search"), {
        params: {
          search: event.query
        }
      }).then(function(response) {
        let brands = response.data;
        brandItems.value = brands;
        if (brands.length > 0) {
          $(".p-autocomplete-panel").show();
        } else {
          $(".p-autocomplete-panel").hide();
        }
      }).catch(function(error) {
        console.log(error);
      });
    };
    const editArticleForm = useForm({
      title: props.article.title,
      slug: props.article.slug,
      category: category.value,
      tags: props.article.get_tags_string,
      content: props.article.content,
      source: props.article.source,
      read_time: props.article.read_time,
      type: props.article.type,
      brand: props.article.brand != null ? props.article.brand.title : props.article.brand,
      image: props.article.image,
      video: props.article.video,
      podcast: props.article.podcast,
      seo_title: props.article.seo_title,
      seo_description: props.article.seo_description,
      seo_keywords: props.article.seo_keywords,
      seo_canonical: props.article.seo_canonical,
      comment_status: props.article.comment_status ? true : false,
      editor_choice: props.article.editor_choice ? true : false,
      status: props.article.status == "awaiting" ? "publish" : props.article.status,
      action: ""
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "article" && media.file != null) {
        image.value = media.file.url;
        editArticleForm.image = media.file.id + "";
      }
    });
    const rejectArticleForm = useForm({
      action: "reject",
      reason: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_article")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_article")
      }, null, _parent));
      _push(`<div class="modal fade" id="reject-product" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_reject_article"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-2"><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548965"))}</p><p class="alert alert-light fs-9">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_987563"))}</p></div><div class="col-12"><div class="form-element-row"><label for="eaRejectMessage" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.reject_reason"))}</label><textarea id="eaRejectMessage" rows="5" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.reject_reason") + " ...")}>${ssrInterpolate(unref(rejectArticleForm).reason)}</textarea></div></div></div></div><div class="modal-footer"><button type="submit"${ssrIncludeBooleanAttr(unref(rejectArticleForm).processing) ? " disabled" : ""} class="btn btn-danger shadow-1 px-4 me-0" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.reject"))}</button></div></form></div></div></div><div class="add-product row mb-4"><div class="col-12"><form><div class="card mb-4"><div class="card-body"><div class="pills-tab-container d-flex align-items-start"><div class="action-sidebar"><div class="nav flex-column nav-pills mb-md-4 mb-5" id="v-pills-tab" role="tablist" aria-orientation="vertical"><button class="nav-link active" id="v-pills-main-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main" type="button" role="tab" aria-controls="v-pills-main" aria-selected="true"><i class="ri-keyboard-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.main_information"))}</button><button class="nav-link" id="v-pills-seo-tab" data-bs-toggle="pill" data-bs-target="#v-pills-seo" type="button" role="tab" aria-controls="v-pills-seo" aria-selected="false"><i class="ri-seo-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.seo_settings"))}</button><button class="nav-link" id="v-pills-images-tab" data-bs-toggle="pill" data-bs-target="#v-pills-images" type="button" role="tab" aria-controls="v-pills-images" aria-selected="false"><i class="ri-image-edit-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.media_and_images"))}</button></div><div class="action-container d-md-block d-none mb-4"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.editor_choice"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editArticleForm).editor_choice) ? ssrLooseContain(unref(editArticleForm).editor_choice, null) : unref(editArticleForm).editor_choice) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch"></label></div><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editArticleForm).comment_status) ? ssrLooseContain(unref(editArticleForm).comment_status, null) : unref(editArticleForm).comment_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><label for="eaArticleStatus" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.article_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(editArticleForm).status,
        "onUpdate:modelValue": ($event) => unref(editArticleForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      if (_ctx.article.status != "awaiting") {
        _push(`<button${ssrIncludeBooleanAttr(unref(editArticleForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.edit_article"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.status == "awaiting" && _ctx.article.reason == "update") {
        _push(`<span class="fs-9 lts-05 text-info d-flex mt-4">${ssrInterpolate(_ctx.$t("messages.sentence.attention_edited_article"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.status == "awaiting") {
        _push(`<button type="button" method="post" as="button" class="btn btn-success mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.accept_and_publish"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.status == "awaiting") {
        _push(`<button${ssrIncludeBooleanAttr(unref(editArticleForm).processing) ? " disabled" : ""} data-bs-toggle="modal" data-bs-target="#reject-product" type="button" class="btn btn-danger mt-1">${ssrInterpolate(_ctx.$t("messages.word.reject"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="tab-content" id="v-pills-tabContent"><div class="tab-pane fade show active" id="v-pills-main" role="tabpanel" aria-labelledby="v-pills-main-tab" tabindex="0"><div class="row"><div class="col-12 mb-4"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.article"))}</label><input${ssrRenderAttr("value", unref(editArticleForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.article"))} class="form-control" id="eaTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaEnSlug" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrRenderAttr("value", unref(editArticleForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaEnSlug"></div><div class="col-sm-6 col-12 mb-4"><label for="eaCategories" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.categories"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: category.value,
        "onUpdate:modelValue": ($event) => category.value = $event,
        options: props.categories,
        filter: "",
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionLabel: "title",
        placeholder: _ctx.$t("messages.sentence.select_category")
      }, null, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaSource" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.source"))}</label><input${ssrRenderAttr("value", unref(editArticleForm).source)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.source") + " " + _ctx.$t("messages.word.article"))} class="form-control" id="eaSource"></div><div class="col-sm-6 col-12 mb-4"><label for="eaReadTime" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.read_time"))}</label><input${ssrRenderAttr("value", unref(editArticleForm).read_time)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.example_six_min"))} class="form-control" id="eaReadTime"></div><div class="col-sm-6 col-12 mb-4"><label for="eaTags" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.tags"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editArticleForm).tags,
        "onUpdate:modelValue": ($event) => unref(editArticleForm).tags = $event
      }, null, _parent));
      _push(`</div><div class="col-sm-6 col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.brand"))} <span class="text-gray fs-9">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></label>`);
      _push(ssrRenderComponent(unref(AutoComplete), {
        onKeydown: () => {
        },
        modelValue: unref(editArticleForm).brand,
        "onUpdate:modelValue": ($event) => unref(editArticleForm).brand = $event,
        dropdown: "",
        suggestions: brandItems.value,
        onComplete: searchBrand,
        placeholder: _ctx.$t("messages.sentence.product_brand")
      }, null, _parent));
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.type_and_search_brand"))}</span></div><div class="col-12 mb-4"><label class="form-label mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.content"))}</label><span class="d-flex alert alert-dark text-dark lh-25 fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.example_inject_product_inside_article_content"))}</span>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(editArticleForm).content,
        "onUpdate:modelValue": ($event) => unref(editArticleForm).content = $event
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="v-pills-seo" role="tabpanel" aria-labelledby="v-pills-seo-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(editArticleForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editArticleForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(editArticleForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(editArticleForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(editArticleForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div></div><div class="tab-pane fade" id="v-pills-images" role="tabpanel" aria-labelledby="v-pills-images-tab" tabindex="0"><div class="row image-container"><div class="row image-container"><div class="col-12 mb-4"><label for="eaCategories" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.article_type"))}</label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-multiselect pvc-multiselect-filter",
        modelValue: unref(editArticleForm).type,
        "onUpdate:modelValue": ($event) => unref(editArticleForm).type = $event,
        options: _ctx.articleTypeList,
        emptyFilterMessage: _ctx.$t("messages.sentence.no_items_found"),
        display: "chip",
        optionValue: "id",
        optionLabel: "label",
        placeholder: _ctx.$t("messages.sentence.select_article_type")
      }, null, _parent));
      _push(`</div>`);
      if (unref(editArticleForm).type == "video") {
        _push(`<div class="col-12 mb-4"><label for="eaVideoLink" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.video_link"))}: </label><input${ssrRenderAttr("value", unref(editArticleForm).video)} type="text" name="video"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.allowed_format") + ": mp4")} class="form-control" id="eaVideoLink"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_125485"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(editArticleForm).type == "podcast") {
        _push(`<div class="col-12 mb-4"><label for="eaPodcastLink" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.podcast_link"))}</label><input${ssrRenderAttr("value", unref(editArticleForm).podcast)} type="text" name="podcast"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.allowed_format") + ": mp3")} class="form-control" id="eaPodcastLink"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_125485"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12 mb-4"><div class="image-grid percent-60 select-image"><div class="image-grid--level-one" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="article"><div class="image-grid--level-two">`);
      if (image.value != null) {
        _push(`<div class="image" style="${ssrRenderStyle(`background-image: url('${image.value}');`)}"></div>`);
      } else {
        _push(`<!---->`);
      }
      if (image.value == null) {
        _push(`<div class="select-image-details"><i class="ri-image-2-fill"></i><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.choose_article_image"))}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
      if (image.value != null) {
        _push(`<i class="remove-image ri-close-line"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div></div><div class="action-container d-md-none d-block mt-4"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.editor_choice"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editArticleForm).editor_choice) ? ssrLooseContain(unref(editArticleForm).editor_choice, null) : unref(editArticleForm).editor_choice) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch"></label></div><div class="form-check form-switch mb-4"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.show_comments"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editArticleForm).comment_status) ? ssrLooseContain(unref(editArticleForm).comment_status, null) : unref(editArticleForm).comment_status) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div><label for="eaArticleStatus" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.article_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(editArticleForm).status,
        "onUpdate:modelValue": ($event) => unref(editArticleForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      if (_ctx.article.status != "awaiting") {
        _push(`<button${ssrIncludeBooleanAttr(unref(editArticleForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.edit_article"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.status == "awaiting" && _ctx.article.reason == "update") {
        _push(`<span class="fs-9 lts-05 text-info d-flex mt-4">${ssrInterpolate(_ctx.$t("messages.sentence.attention_edited_article"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.status == "awaiting") {
        _push(`<button type="button" class="btn btn-success mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.accept_and_publish"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.article.status == "awaiting") {
        _push(`<button${ssrIncludeBooleanAttr(unref(editArticleForm).processing) ? " disabled" : ""} data-bs-toggle="modal" data-bs-target="#reject-product" type="button" class="btn btn-danger mt-1">${ssrInterpolate(_ctx.$t("messages.word.reject"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Blog/Articles/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
