import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$3 } from "./Ckeditor-BEPE8WxA.js";
import { _ as _sfc_main$4 } from "./Tagify-DYepU4nx.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "./useRandomStr-4MeWbtRd.js";
import "@yaireo/tagify";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Edit",
  __ssrInlineRender: true,
  props: {
    page: {},
    statusList: {}
  },
  setup(__props) {
    const props = __props;
    const editPageForm = useForm({
      title: props.page.title,
      slug: props.page.slug,
      content: props.page.content,
      seo_title: props.page.seo_title,
      seo_description: props.page.seo_description,
      seo_keywords: props.page.seo_keywords,
      seo_canonical: props.page.seo_canonical,
      status: props.page.status
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_page")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_page")
      }, null, _parent));
      _push(`<div class="add-product row mb-4"><div class="col-12"><form><div class="card mb-4"><div class="card-body"><div class="pills-tab-container d-flex align-items-start"><div class="action-sidebar"><div class="nav flex-column nav-pills mb-md-4 mb-5" id="v-pills-tab" role="tablist" aria-orientation="vertical"><button class="nav-link active" id="v-pills-main-tab" data-bs-toggle="pill" data-bs-target="#v-pills-main" type="button" role="tab" aria-controls="v-pills-main" aria-selected="true"><i class="ri-keyboard-box-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.main_information"))}</button><button class="nav-link" id="v-pills-seo-tab" data-bs-toggle="pill" data-bs-target="#v-pills-seo" type="button" role="tab" aria-controls="v-pills-seo" aria-selected="false"><i class="ri-seo-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.seo_settings"))}</button></div><div class="action-container d-md-block d-none mb-4"><label for="eaProductStatus" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.page_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(editPageForm).status,
        "onUpdate:modelValue": ($event) => unref(editPageForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`<button${ssrIncludeBooleanAttr(unref(editPageForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.edit_page"))}</button></div></div><div class="tab-content" id="v-pills-tabContent"><div class="tab-pane fade show active" id="v-pills-main" role="tabpanel" aria-labelledby="v-pills-main-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaTitle" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.page_title"))}</label><input${ssrRenderAttr("value", unref(editPageForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.page_title"))} class="form-control" id="eaTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaEnSlug" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.slug"))}</label><input${ssrIncludeBooleanAttr(_ctx.page.flag == "system") ? " disabled" : ""}${ssrRenderAttr("value", unref(editPageForm).slug)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.better_to_leave_it_blank_and_create_it_automatically"))} class="form-control" id="eaEnSlug"></div><div class="col-12 mb-4"><label class="form-label required mb-2 lts-05">${ssrInterpolate(_ctx.$t("messages.word.content"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editPageForm).content,
        "onUpdate:modelValue": ($event) => unref(editPageForm).content = $event
      }, null, _parent));
      _push(`</div></div></div><div class="tab-pane fade" id="v-pills-seo" role="tabpanel" aria-labelledby="v-pills-seo-tab" tabindex="0"><div class="row"><div class="col-sm-6 col-12 mb-4"><label for="eaSeoTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title") + " " + _ctx.$t("messages.word.seo"))}</label><input${ssrRenderAttr("value", unref(editPageForm).seo_title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.title_for_seo"))} class="form-control" id="eaSeoTitle"></div><div class="col-sm-6 col-12 mb-4"><label for="eaSeoKeywords" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.keywords"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        modelValue: unref(editPageForm).seo_keywords,
        "onUpdate:modelValue": ($event) => unref(editPageForm).seo_keywords = $event
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaDescription" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.word.description") + " " + _ctx.$t("messages.word.seo"))}</label><textarea${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.briefly_describe_the_content_in_two_lines"))} class="form-control" id="eaDescription">${ssrInterpolate(unref(editPageForm).seo_description)}</textarea></div><div class="col-12 mb-5"><label for="eaCanonical" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.canonical_tag"))}</label><input${ssrRenderAttr("value", unref(editPageForm).seo_canonical)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_link_optional"))} class="form-control" id="eaCanonical"></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_snippet_for_google"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_preview_for_socials"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.add_to_sitemap"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div><div class="col-sm-6 col-12 mb-4"><div class="checkbox-container"><i class="ri-check-line"></i><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.create_meta_tags"))}</span><span class="flag"> (${ssrInterpolate(_ctx.$t("messages.sentence.create_automatically"))}) </span></div></div></div></div></div></div><div class="action-container d-md-none d-block mt-4"><label for="eaProductStatus" class="form-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.page_status"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(editPageForm).status,
        "onUpdate:modelValue": ($event) => unref(editPageForm).status = $event,
        options: _ctx.statusList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`<button${ssrIncludeBooleanAttr(unref(editPageForm).processing) ? " disabled" : ""} class="btn btn-primary mt-3">${ssrInterpolate(_ctx.$t("messages.sentence.edit_page"))}</button></div></div></div></form></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Pages/Edit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
