import { defineComponent, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext, ref, reactive, resolveDirective, createVNode } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderStyle, ssrRenderComponent, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrRenderList, ssrRenderClass, ssrGetDirectiveProps } from "vue/server-renderer";
import { Link, useForm } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import ProgressBar from "primevue/progressbar/progressbar.esm.js";
import ConfirmDialog from "primevue/confirmdialog/confirmdialog.esm.js";
import { useConfirm } from "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./SearchList-BZnYMQPN.js";
import { u as useRandomNum } from "./useRandomNum-DNNSqR7b.js";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Breadcrumb",
  __ssrInlineRender: true,
  props: {
    title: {},
    item: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "row page-top mb-3" }, _attrs))}>`);
      if (_ctx.$page.props.currentRouteName != "admin.updater.index") {
        _push(`<!--[-->`);
        if (_ctx.$page.props.auth.can["owner"] && _ctx.$page.props.panelDetails.has_update) {
          _push(`<div class="col-12 update-alert"><div class="d-inline-flex align-items-center alert alert-info text-info white-space-nowrap fs-7 fw-normal lts-05 px-2 ps-3 py-2 br-15 mb-3"><span>${ssrInterpolate(_ctx.$t("messages.sentence.update_available"))}</span><span class="mx-2" style="${ssrRenderStyle({ "width": "4px", "height": "4px", "border-radius": "50px", "background-color": "#0dcaf0" })}"></span><span class="fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.version_number"))}: ${ssrInterpolate(_ctx.$page.props.panelDetails.latest_version)}</span>`);
          if (_ctx.$page.props.panelDetails.is_host) {
            _push(`<span class="mx-2 me-3" style="${ssrRenderStyle({ "width": "4px", "height": "4px", "border-radius": "50px", "background-color": "#0dcaf0" })}"></span>`);
          } else {
            _push(`<!---->`);
          }
          if (_ctx.$page.props.panelDetails.is_host) {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("admin.updater.index"),
              class: "btn btn-info text-white fs-8 py-1 br-10"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$t("messages.word.update"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("messages.word.update")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent));
          } else {
            _push(`<!---->`);
          }
          if (!_ctx.$page.props.panelDetails.is_host) {
            _push(`<span class="ms-2"></span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12 d-flex align-items-center justify-content-between"><div class="page-title">${ssrInterpolate(_ctx.title)}</div><nav aria-label="breadcrumb"><ol class="breadcrumb"><li class="breadcrumb-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.dashboard")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.admin_dashboard"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.admin_dashboard")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="breadcrumb-item active" aria-current="page">${ssrInterpolate(_ctx.item != null ? _ctx.item : _ctx.title)}</li></ol></nav></div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Admin/Breadcrumb.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Files",
  __ssrInlineRender: true,
  props: {
    mediaLibrary: {},
    keyword: {}
  },
  emits: ["mediaData"],
  setup(__props, { emit: __emit }) {
    ref();
    const fileType = ref();
    const imageUrl = ref();
    const sizeToMB = ref();
    const uploadFileForm = useForm({
      file: null,
      description: null,
      optimization: true,
      cropImage: false,
      addWatermark: false
    });
    useConfirm();
    const mediaReactive = reactive({
      id: useRandomNum(1e5, 999999),
      type: "",
      file: null
    });
    if (typeof window !== "undefined") {
      $(() => {
        const mediaLibraryModal = document.getElementById("mediaLibrary");
        mediaLibraryModal.addEventListener("shown.bs.modal", (event) => {
          const button = event.relatedTarget;
          mediaReactive.type = button.getAttribute("data-bs-input");
        });
      });
    }
    const editMediaForm = useForm({
      description: ""
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "modal fade",
        id: "mediaLibrary",
        tabindex: "-1",
        "aria-hidden": "true"
      }, _attrs))}><div class="modal-dialog modal-xl modal-dialog-centered"><div class="modal-content" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="row"><div class="col-12"><div class="card upload-file-container"><div class="card-body p-0"><div class="media-modal-header d-flex align-items-center justify-content-between mb-3"><span>${ssrInterpolate(_ctx.$t("messages.sentence.media_library"))}</span><i class="ri-close-line close-modal" data-bs-dismiss="modal"></i></div><form class="mb-3"><div class="form-element-row form-element-row-file">`);
      if (fileType.value == null) {
        _push(`<div class="text-center"><div class="fs-6 fw-bold text-dark mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.select_yout_image_for_upload"))}</div><div class="fs-7 text-muted mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.image_allowed_formats"))}</div><div class="fs-7 text-muted mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.image_allowed_size"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="custom-input-file">`);
      if (fileType.value == null) {
        _push(`<label for="uploadFile" class="custom-input-file-label"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></label>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input type="file" class="custom-input-file-input" id="uploadFile" accept=".png,.jpg,.jpeg,.webp,.gif,.svg"></div>`);
      if (fileType.value != null && !unref(uploadFileForm).processing) {
        _push(`<div class="row after-select-container"><div class="col-xl-2 col-lg-2 col-md-3 col-12 mb-4 mb-md-0">`);
        if (fileType.value == "image") {
          _push(`<div class="file-grid"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image" style="${ssrRenderStyle({ "background-image": "url(" + imageUrl.value + ")" })}"></div></div></div></div>`);
        } else if (fileType.value == "pdf" || fileType.value == "zip" || fileType.value == "mp3" || fileType.value == "mp4") {
          _push(`<div class="file-grid other-file"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image image-with-file">`);
          if (fileType.value == "pdf") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/pdf.png")}>`);
          } else if (fileType.value == "zip") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/zip.png")}>`);
          } else if (fileType.value == "mp3") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp3.png")}>`);
          } else if (fileType.value == "mp4") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp4.png")}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="file-size">${ssrInterpolate(sizeToMB.value + "MB")}</span></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="col-xl-10 col-lg-10 col-md-9 col-12 d-flex flex-column justify-content-center">`);
        if (fileType.value != null) {
          _push(`<div class="file-description mb-3"><input${ssrRenderAttr("value", unref(uploadFileForm).description)} type="text" class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.file_full_name_for_seo"))}></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="d-flex justify-content-between align-items-center upload-bottom-action-bar">`);
        if (fileType.value == "image") {
          _push(`<div class="image-crop"><label class="lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).optimization) ? ssrLooseContain(unref(uploadFileForm).optimization, null) : unref(uploadFileForm).optimization) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.image_optimization"))}</label><label class="ms-4 lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).cropImage) ? ssrLooseContain(unref(uploadFileForm).cropImage, null) : unref(uploadFileForm).cropImage) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.crop_image_square"))}</label><label class="ms-4 lts-05"><input${ssrIncludeBooleanAttr(Array.isArray(unref(uploadFileForm).addWatermark) ? ssrLooseContain(unref(uploadFileForm).addWatermark, null) : unref(uploadFileForm).addWatermark) ? " checked" : ""} class="form-check-input" type="checkbox"> ${ssrInterpolate(_ctx.$t("messages.sentence.add_watermark_to_image"))}</label></div>`);
        } else {
          _push(`<div></div>`);
        }
        _push(`<div class="custom-input-file">`);
        if (fileType.value != null) {
          _push(`<button${ssrIncludeBooleanAttr(unref(uploadFileForm).processing) ? " disabled" : ""} type="submit" class="btn btn-primary shadow-1"><i class="ri-upload-2-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.upload"))}</button>`);
        } else {
          _push(`<!---->`);
        }
        if (fileType.value != null) {
          _push(`<button type="button" class="btn btn-danger btn-square btn-sm ms-2 shadow-1"><i class="ri-delete-bin-line"></i></button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(uploadFileForm).processing) {
        _push(`<div class="row uploading-progress"><div class="col-12">`);
        if (unref(uploadFileForm).progress) {
          _push(ssrRenderComponent(unref(ProgressBar), {
            value: unref(uploadFileForm).progress.percentage
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></form>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.file_id") + " ..."
      }, null, _parent));
      _push(`<div class="row file-container mb-3"><!--[-->`);
      ssrRenderList(_ctx.mediaLibrary.files.data, (file) => {
        _push(`<div class="col-xl-2 col-md-4 col-sm-4 col-6 mb-2"><div class="${ssrRenderClass({ file: true, "shadow-1": true, dropdown: true, "other-file": file.type != "image" })}">`);
        if (file.type == "image") {
          _push(`<div${ssrRenderAttrs(mergeProps({ class: "file-grid" }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.choose_image"), void 0, { top: true })))}><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image" style="${ssrRenderStyle({ "background-image": "url(" + _ctx.$page.props.appUrl + file.url + ")" })}"></div></div></div><div class="black-mask"></div><div class="add-image"><button class="btn btn-square btn-xs btn-white shadow-2"><i class="ri-add-line"></i></button></div></div>`);
        } else {
          _push(`<div class="file-grid"><div class="file-grid--level-one"><div class="file-grid--level-two"><div class="image image-with-file">`);
          if (file.type == "pdf") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/pdf.png")} alt="pdf">`);
          } else if (file.type == "zip") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/zip.png")} alt="zip">`);
          } else if (file.type == "audio") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp3.png")} alt="mp3">`);
          } else if (file.type == "video") {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/icon/file/mp4.png")} alt="mp4">`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="file-size">${ssrInterpolate(file.name)}</span></div></div></div></div>`);
        }
        _push(`<i class="ri-more-2-fill image-details" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-1"><ul><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.file_id"))}: </span><span class="value">${ssrInterpolate(file.id)}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.title"))}: </span><span class="value">${ssrInterpolate(file.description != null ? file.description : _ctx.$t("messages.word.empty"))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.file_format"))}: </span><span class="value">${ssrInterpolate(file.extension)}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.word.volume"))}: </span><span class="value">${ssrInterpolate(Math.round(file.size / 1e3 * 100) / 100)} ${ssrInterpolate(_ctx.$t("messages.word.megabyte"))}</span></li><li class="copy-file-url"><form action="#"><button class="no-btn" type="button">${ssrInterpolate(_ctx.$t("messages.sentence.copy_link"))}</button></form></li><li class="remove-image"><button class="no-btn" type="submit">${ssrInterpolate(_ctx.$t("messages.sentence.delete_file"))}</button></li></ul></div></div><div class="modal fade"${ssrRenderAttr("id", "edit-media-" + file.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><label class="form-label" for="eaEditFileAlt">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label><input${ssrRenderAttr("value", unref(editMediaForm).description)} type="text" class="form-control"></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-light px-3" type="button" data-bs-dismiss="modal">${ssrInterpolate(_ctx.$t("messages.word.cancel"))}</button><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.update"))}</button></div></form></div></div></div></div>`);
      });
      _push(`<!--]--></div>`);
      _push(ssrRenderComponent(unref(ConfirmDialog), null, {
        message: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span class="lts-05"${_scopeId}><strong class="text-danger"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.warning"))}:</strong> ${ssrInterpolate(_ctx.$t("messages.sentence.file_deleted_from_wherever_used"))}</span>`);
          } else {
            return [
              createVNode("span", { class: "lts-05" }, [
                createVNode("strong", { class: "text-danger" }, toDisplayString(_ctx.$t("messages.word.warning")) + ":", 1),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.file_deleted_from_wherever_used")), 1)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (_ctx.mediaLibrary.files.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        key: unref(useRandomNum)(1e3, 9999),
        links: _ctx.mediaLibrary.files.links,
        "preserve-state": true,
        preserveScroll: true,
        only: "mediaLibrary"
      }, null, _parent));
      _push(`</div></div></div></div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Admin/Files.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main$1 as _,
  _sfc_main as a
};
