import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { u as useNumberFormat } from "../ssr.js";
import { _ as _sfc_main$3 } from "./SingleTopChart-DsD8dN-3.js";
import { _ as _sfc_main$4 } from "./BarAndLineChart-BNn4O1Ev.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
import "apexcharts";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Financial",
  __ssrInlineRender: true,
  props: {
    mainStatistics: {},
    totalSales: {},
    mainStoreSales: {},
    sellersSales: {},
    affiliatesSales: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.financial_statistics")
      }, null, _parent));
      _push(`<div class="container-fluid financial-statistics">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.financial_statistics"),
        item: _ctx.$t("messages.word.statistics")
      }, null, _parent));
      _push(`<div class="row top-simple-chart"><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold" style="${ssrRenderStyle({ "color": "#0060ff" })}">${ssrInterpolate(_ctx.$t("messages.sentence.total_sales"))}</span><span class="value white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStatistics.all))} <span class="unit"></span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart"><a href="javascript:void(0)">${ssrInterpolate(_ctx.$t("messages.word.totality"))}</a>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 1,
        size: { width: 60, height: 40 },
        color: ["#0060ff"],
        type: "bar"
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold lts-05" style="${ssrRenderStyle({ "color": "#f8a203" })}">${ssrInterpolate(_ctx.$t("messages.sentence.main_store_sales"))}</span><span class="value white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStatistics.main))} <span class="unit"></span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart"><a href="javascript:void(0)">${ssrInterpolate(_ctx.$t("messages.word.totality"))}</a>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 2,
        size: { width: 60, height: 40 },
        color: ["#f8a203"],
        type: "line"
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold lts-05" style="${ssrRenderStyle({ "color": "#0060ff" })}">${ssrInterpolate(_ctx.$t("messages.word.sellers"))}</span><span class="value white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStatistics.sellers))} <span class="unit"></span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart"><a href="javascript:void(0)">${ssrInterpolate(_ctx.$t("messages.word.totality"))}</a><div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 3,
        size: { width: 60, height: 40 },
        color: ["#0060ff"],
        type: "bar"
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold" style="${ssrRenderStyle({ "color": "#f8a203" })}">${ssrInterpolate(_ctx.$t("messages.word.affiliates"))}</span><span class="value white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStatistics.affiliates))} <span class="unit"></span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart"><a href="javascript:void(0)">${ssrInterpolate(_ctx.$t("messages.word.totality"))}</a>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 4,
        size: { width: 60, height: 40 },
        color: ["#f8a203"],
        type: "line"
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-xl-3 col-sm-6 col-12 mb-4"><div class="card shadow-1"><div class="card-body"><div class="details"><span class="title fw-bold" style="${ssrRenderStyle({ "color": "#ee1844" })}">${ssrInterpolate(_ctx.$t("messages.sentence.discounts_code"))}</span><span class="value white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStatistics.discounts))} <span class="unit"></span></span><span class="flag">${ssrInterpolate(_ctx.$t("messages.sentence.from_the_beginning_to_now"))}</span></div><div class="chart"><a href="javascript:void(0)">${ssrInterpolate(_ctx.$t("messages.word.totality"))}</a>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        id: 5,
        size: { width: 60, height: 40 },
        color: ["#ee1844"],
        type: "line"
      }, null, _parent));
      _push(`</div></div></div></div></div><div class="row income-payments"><div class="col-12 mb-3"><span class="fs-7 fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.monthly_total_sales"))}</span></div><div class="col-12 mb-4"><div class="card income shadow-1"><div class="card-body" style="${ssrRenderStyle({ "padding-bottom": "10px" })}"><ul class="mb-4 mt-3"><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.today_sale"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalSales.counts.today))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.month_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalSales.counts.month))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.total_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.totalSales.counts.total))}</span></li></ul><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "height": "100%" })}">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        id: 1,
        color: ["#34495E", "#1abc9c"],
        labels: _ctx.totalSales.dates,
        datasets: {
          bar: { data: _ctx.totalSales.chart.sales, label: "مبلغ فروش" },
          line: { data: _ctx.totalSales.chart.count, label: "تعداد فروش" }
        }
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-12 mb-3"><span class="fs-7 fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.monthly_main_store_sales"))}</span></div><div class="col-12 mb-4"><div class="card income shadow-1"><div class="card-body" style="${ssrRenderStyle({ "padding-bottom": "10px" })}"><ul class="mb-4 mt-3"><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.today_sale"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStoreSales.counts.today))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.month_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStoreSales.counts.month))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.total_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.mainStoreSales.counts.total))}</span></li></ul><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "height": "100%" })}">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        id: 2,
        color: ["#34495E", "#fa4248"],
        labels: _ctx.mainStoreSales.dates,
        datasets: {
          bar: { data: _ctx.mainStoreSales.chart.sales, label: "مبلغ فروش" },
          line: { data: _ctx.mainStoreSales.chart.count, label: "تعداد فروش" }
        }
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-12 mb-3"><span class="fs-7 fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.monthly_sellers_sales"))}</span></div><div class="col-12 mb-4"><div class="card income shadow-1"><div class="card-body" style="${ssrRenderStyle({ "padding-bottom": "10px" })}"><ul class="mb-4 mt-3"><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.today_sale"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.sellersSales.counts.today))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.month_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.sellersSales.counts.month))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.total_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.sellersSales.counts.total))}</span></li></ul><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "height": "100%" })}">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        id: 3,
        color: ["#34495E", "#f8a203"],
        labels: _ctx.sellersSales.dates,
        datasets: {
          bar: { data: _ctx.sellersSales.chart.sales, label: "مبلغ فروش" },
          line: { data: _ctx.sellersSales.chart.count, label: "تعداد فروش" }
        }
      }, null, _parent));
      _push(`</div></div></div></div><div class="col-12 mb-3"><span class="fs-7 fw-bold lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.monthly_affiliates_sales"))}</span></div><div class="col-12 mb-4"><div class="card income shadow-1"><div class="card-body" style="${ssrRenderStyle({ "padding-bottom": "10px" })}"><ul class="mb-4 mt-3"><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.today_sale"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.affiliatesSales.counts.today))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.month_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.affiliatesSales.counts.month))}</span></li><li><span class="title">${ssrInterpolate(_ctx.$t("messages.sentence.total_sales"))}</span><span class="value">${ssrInterpolate(unref(useNumberFormat)(_ctx.affiliatesSales.counts.total))}</span></li></ul><div class="el-chart" style="${ssrRenderStyle({ "direction": "ltr", "height": "100%" })}">`);
      _push(ssrRenderComponent(_sfc_main$4, {
        id: 4,
        color: ["#34495E", "#5d87ff"],
        labels: _ctx.affiliatesSales.dates,
        datasets: {
          bar: { data: _ctx.affiliatesSales.chart.sales, label: "مبلغ فروش" },
          line: { data: _ctx.affiliatesSales.chart.count, label: "تعداد فروش" }
        }
      }, null, _parent));
      _push(`</div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Statistics/Financial.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
