import { defineComponent, ref, inject, watch, onMounted, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrInterpolate, ssrRenderStyle, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$3 } from "./NumInput-Bt6uFGO4.js";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { useForm, Head } from "@inertiajs/vue3";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import NeshanMap from "@neshan-maps-platform/vue3-openlayers";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
import "./useRandomStr-4MeWbtRd.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Information",
  __ssrInlineRender: true,
  props: {
    store: {},
    companyType: {}
  },
  setup(__props) {
    const props = __props;
    const Map = ref();
    const editInformationForm = useForm({
      name: props.store.name,
      bio: props.store.bio,
      logo: props.store.logo,
      // genuine
      national_number: props.store.get_information.national_number,
      national_card_image: null,
      // legal
      company_name: props.store.get_information.company_name,
      company_type: props.store.get_information.company_type_id,
      company_national_number: props.store.get_information.company_national_number,
      company_economic_number: props.store.get_information.company_economic_number,
      company_signatory: props.store.get_information.company_signatory,
      legal_identity_image: null,
      // both
      map: props.store.get_information.map,
      state: props.store.get_information.address != void 0 ? props.store.get_information.address.state : null,
      city: props.store.get_information.address != void 0 ? props.store.get_information.address.city : null,
      full_address: props.store.get_information.address != void 0 ? props.store.get_information.address.full_address : null,
      postal_code: props.store.get_information.address != void 0 ? props.store.get_information.address.postal_code : null
    });
    const mapResult = (event) => {
      var _a;
      if (event.apiData !== void 0) {
        editInformationForm.map.longitude = event.coords[0];
        editInformationForm.map.latitude = event.coords[1];
        editInformationForm.map.zoom = (_a = Map.value) == null ? void 0 : _a.state.zoom;
        editInformationForm.map.selected = true;
      }
    };
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "logo" && media.file != null) {
        props.store.get_logo = media.file.url;
        editInformationForm.logo = media.file.id + "";
      }
    });
    onMounted(() => {
      setTimeout(() => {
        var _a;
        (_a = Map.value) == null ? void 0 : _a.reverse([props.store.get_information.map.longitude, props.store.get_information.map.latitude], {
          useMarker: true
        });
      }, 1500);
    });
    ref();
    const nationalCardImageUrl = ref(props.store != null && props.store.get_information.national_card_image_url !== void 0 ? props.store.get_information.national_card_image_url : null);
    ref();
    const legalIdentityImageUrl = ref(props.store != null && props.store.get_information.legal_identity_image_url !== void 0 ? props.store.get_information.legal_identity_image_url : null);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.edit_store_information")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.edit_store_information"),
        item: _ctx.$t("messages.word.store")
      }, null, _parent));
      _push(`<div class="edit-profile mb-4"><div class="card"><div class="card-body"><form class="row edit-account-form"><div class="col-12 avatar-container d-flex align-items-center mb-5"><img width="100" height="100"${ssrRenderAttr("src", _ctx.store.get_logo)} class="shadow-1"${ssrRenderAttr("alt", _ctx.store.name)}><div class="edit-link"><button type="button" class="btn btn-light shadow-1 lts-05" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="logo"><i class="ri-pencil-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.change_logo"))}</button><div class="image-information">(${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_745221"))})</div></div></div><div class="col-sm-6 col-12 mb-4"><label for="eaStoreName" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.store_title"))}</label><input${ssrRenderAttr("value", unref(editInformationForm).name)}${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.msg_id_985532") + " ...")} required class="form-control" id="eaStoreName"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478552"))}</span></div><div class="col-12 mb-4"><label for="eaStoreBiography" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.biography"))}</label><textarea class="form-control lh-30" name="biography" rows="3"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.brief_biography_of_store") + " ...")} id="eaStoreBiography" style="${ssrRenderStyle({ "min-height": "100px" })}">${ssrInterpolate(unref(editInformationForm).bio)}</textarea></div><div class="col-12 mb-4 mt-4"><div class="border"></div></div><div class="col-12 mb-4">`);
      if (_ctx.store.type == "legal") {
        _push(`<span class="fw-bold d-flex fs-6 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.legal_seller_Information"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.store.type == "genuine") {
        _push(`<span class="fw-bold d-flex fs-6 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.genuine_seller_information"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (_ctx.store.type == "legal") {
        _push(`<!--[--><div class="col-sm-6 col-12 mb-4"><label for="eaCompanyName" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.company_name"))}</label><input${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""}${ssrRenderAttr("value", unref(editInformationForm).company_name)} type="text" required class="form-control" id="eaCompanyName"></div><div class="col-sm-6 col-12 mb-4"><label class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.company_type"))}</label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          disabled: _ctx.store.status == "active" || _ctx.store.status == "banned",
          modelValue: unref(editInformationForm).company_type,
          "onUpdate:modelValue": ($event) => unref(editInformationForm).company_type = $event,
          options: _ctx.companyType,
          optionLabel: "label",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_company_type"),
          type: "text",
          readonly: "",
          class: "pvc-dropdown"
        }, null, _parent));
        _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaCompanyNationalNumber" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.company_national_number"))}</label>`);
        _push(ssrRenderComponent(_sfc_main$3, {
          disabled: _ctx.store.status == "active" || _ctx.store.status == "banned",
          modelValue: unref(editInformationForm).company_national_number,
          "onUpdate:modelValue": ($event) => unref(editInformationForm).company_national_number = $event,
          type: "text",
          required: "",
          class: "form-control",
          id: "eaCompanyNationalNumber"
        }, null, _parent));
        _push(`</div><div class="col-sm-6 col-12 mb-4"><label for="eaCompanyEconomicNumber" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.economic_code"))}</label><input${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""}${ssrRenderAttr("value", unref(editInformationForm).company_economic_number)} type="text" required class="form-control" id="eaCompanyEconomicNumber"></div><div class="col-sm-6 col-12 mb-4"><label for="eaCompanySignatory" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.signature_owners"))}</label><input${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""}${ssrRenderAttr("value", unref(editInformationForm).company_signatory)} type="text" class="form-control" id="eaCompanySignatory" required><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.seprate_person_name_with_commas"))}</span></div><div class="col-sm-6 col-12 mb-4"><span class="form-label mb-1 d-flex lts-05 text-dark required">${ssrInterpolate(_ctx.$t("messages.sentence.company_signatory_national_cards_image"))}</span><span class="text-gray fs-9 mb-2 d-flex lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548852"))}</span><label class="identity-documents clickable" for="legalIdentityInput">`);
        if (legalIdentityImageUrl.value != null) {
          _push(`<img${ssrRenderAttr("src", legalIdentityImageUrl.value)}>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<input${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""} type="file" class="custom-input-file-input" id="legalIdentityInput" accept=".png,.jpg,.jpeg">`);
        if (legalIdentityImageUrl.value == null) {
          _push(`<div class="d-flex flex-column align-items-center justify-content-center"><span class="fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_hint"))}</span><span class="lts-05 fs-8 text-gray mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_upload_hint"))}</span><div class="select-image"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</label></div><!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.store.type == "genuine") {
        _push(`<!--[--><div class="col-sm-6 col-12 mb-4"><label for="eaNationalNumber" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.national_number"))}</label>`);
        _push(ssrRenderComponent(_sfc_main$3, {
          disabled: _ctx.store.status == "active" || _ctx.store.status == "banned",
          modelValue: unref(editInformationForm).national_number,
          "onUpdate:modelValue": ($event) => unref(editInformationForm).national_number = $event,
          type: "text",
          minlength: "10",
          maxlength: "10",
          class: "form-control",
          id: "eaNationalNumber",
          required: ""
        }, null, _parent));
        _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_549963"))}</span></div><div class="col-sm-6 col-12 mb-4"><span class="form-label mb-2 d-flex lts-05 text-dark required">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image"))}</span><label class="identity-documents clickable" for="nationalCardInput">`);
        if (nationalCardImageUrl.value != null) {
          _push(`<img${ssrRenderAttr("src", nationalCardImageUrl.value)}>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<input${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""} type="file" class="custom-input-file-input" id="nationalCardInput" accept=".png,.jpg,.jpeg">`);
        if (nationalCardImageUrl.value == null) {
          _push(`<div class="d-flex flex-column align-items-center justify-content-center"><span class="fw-bold lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_hint"))}</span><span class="lts-05 fs-8 text-gray mb-4">${ssrInterpolate(_ctx.$t("messages.sentence.national_card_image_upload_hint"))}</span><div class="select-image"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</label></div><!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12 mb-4 mt-4"><div class="border"></div></div><div class="col-12 mb-4"><div class="fw-bold fs-6">${ssrInterpolate(_ctx.$t("messages.sentence.shop_address"))}</div></div><div class="col-md-4 col-12 mb-4"><label for="eaState" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.town"))}</label><input${ssrRenderAttr("value", unref(editInformationForm).state)}${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""} id="eaState" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.town"))} required class="form-control"></div><div class="col-md-4 col-12 mb-4"><label for="eaCity" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.city"))}</label><input${ssrRenderAttr("value", unref(editInformationForm).city)}${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""} id="eaCity" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.city"))} required class="form-control"></div><div class="col-md-4 col-12 mb-4"><label for="eaPostalCode" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(editInformationForm).postal_code,
        "onUpdate:modelValue": ($event) => unref(editInformationForm).postal_code = $event,
        disabled: _ctx.store.status == "active" || _ctx.store.status == "banned",
        id: "eaPostalCode",
        minlength: "10",
        maxlength: "10",
        type: "text",
        placeholder: _ctx.$t("messages.word.postal_code"),
        required: "",
        class: "form-control"
      }, null, _parent));
      _push(`</div><div class="col-12 mb-4"><label for="eaFullAddress" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.full_address"))}</label><textarea${ssrIncludeBooleanAttr(_ctx.store.status == "active" || _ctx.store.status == "banned") ? " disabled" : ""} id="eaFullAddress" type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_full_address"))} required class="form-control">${ssrInterpolate(unref(editInformationForm).full_address)}</textarea></div>`);
      if (unref(editInformationForm).map != null) {
        _push(`<div class="col-12 mb-4"><label class="form-label lts-05 text-dark required">${ssrInterpolate(_ctx.$t("messages.sentence.select_full_address_from_map"))}:</label><div class="map-container">`);
        _push(ssrRenderComponent(unref(NeshanMap), {
          ref_key: "Map",
          ref: Map,
          mapKey: _ctx.$page.props.neshan.map_key,
          serviceKey: _ctx.$page.props.neshan.service_key,
          center: unref(editInformationForm).map,
          zoom: unref(editInformationForm).map.zoom,
          defaultType: "neshan",
          hideLayers: true,
          traffic: false,
          cluster: false,
          hideSearchContainer: true,
          onOnClick: mapResult,
          class: "map"
        }, null, _parent));
        if (_ctx.store.status == "active" || _ctx.store.status == "banned") {
          _push(`<div class="disable-map"></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12 d-flex align-items-center justify-content-end mt-4"><button type="submit" class="btn btn-primary lts-05 shadow-1"${ssrIncludeBooleanAttr(unref(editInformationForm).processing) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("messages.sentence.save_changes"))} `);
      if (unref(editInformationForm).processing) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</button></div></form></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Account/Information.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
