import { defineComponent, resolveDirective, unref, mergeProps, withCtx, createBlock, createCommentVNode, openBlock, Fragment, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrGetDirectiveProps, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    status: { type: Boolean },
    stories: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.stories")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.stories")
      }, null, _parent));
      _push(`<div class="story-list list mb-4"><div class="card"><div class="card-body"><div class="action-container d-flex flex-sm-row flex-column-reverse align-items-center justify-content-between"><div class="mb-3"><span class="text-dark lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_448511"))}</span>`);
      _push(ssrRenderComponent(unref(Link), mergeProps({
        href: _ctx.route("admin.stories.status"),
        as: "button",
        method: "post",
        "preserve-scroll": "",
        class: { "btn btn-switch fs-9 shadow-1  ms-2": true, "btn-on": _ctx.status, "btn-off": !_ctx.status },
        style: { "background-color": "#ecf0f7" }
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.status ? _ctx.$t("messages.word.deactivate") : _ctx.$t("messages.word.activate"), void 0, { top: true })), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (_ctx.status) {
              _push2(`<!--[-->${ssrInterpolate(_ctx.$t("messages.word.active"))}<!--]-->`);
            } else if (!_ctx.status) {
              _push2(`<!--[-->${ssrInterpolate(_ctx.$t("messages.word.deactive"))}<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              _ctx.status ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.active")), 1)
              ], 64)) : !_ctx.status ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.deactive")), 1)
              ], 64)) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.stories.create"),
        type: "button",
        class: "btn btn-primary mb-4"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_story"))} <i class="ri-add-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_story")) + " ", 1),
              createVNode("i", { class: "ri-add-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="border mb-3"></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: {
          publish: _ctx.$t("messages.word.published"),
          expired: _ctx.$t("messages.word.expired")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.expire_date"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.stories, (story) => {
        _push(`<tr><td><div class="d-flex align-items-center"><div class="image-cover story-ring me-2"><div><img${ssrRenderAttr("src", story.cover)}></div></div>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item text-ellipsis lts-05",
          style: { "max-width": "270px" },
          href: _ctx.route("admin.stories.edit", story.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(story.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(story.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.users.show", story.user.id),
          class: "link fw-normal"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(story.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(story.user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>`);
        if (story.is_expired) {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.expired"))}</span>`);
        } else if (story.status == "publish") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(story.jalali_expired_at[0])}</td><td class="lts-05 fs-8">${ssrInterpolate(story.jalali_created_at[0])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item lts-05",
          href: _ctx.route("admin.stories.edit", story.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-pencil-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.edit")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li><li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-story-" + story.id)}><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-story-" + story.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_story"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.stories.destroy", story.id),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.stories.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Stories/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
