import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseEqual, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    newsletters: {},
    keyword: {}
  },
  setup(__props) {
    const exportType = ref("email");
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.newsletters")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.newsletters")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex w-100 align-items-center justify-content-start mb-4"><button data-bs-toggle="modal" data-bs-target="#exportStorage" type="button" class="btn btn-light fs-8 fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.export_excel"))} <i class="ri-file-excel-2-line ms-2 fw-light fs-6"></i></button><div class="modal fade" id="exportStorage" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.newsletters_csv_export"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-lg-4 col-12 mb-4"><label for="eaEmail" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "email")) ? " checked" : ""} type="radio" value="email" class="form-check-box clickable me-1" id="eaEmail"> ${ssrInterpolate(_ctx.$t("messages.word.email"))}</label></div><div class="col-lg-4 col-12 mb-4"><label for="eaPhone" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "phone")) ? " checked" : ""} type="radio" value="phone" class="form-check-box clickable me-1" id="eaPhone"> ${ssrInterpolate(_ctx.$t("messages.word.phone"))}</label></div></div></div><div class="modal-footer"><a${ssrRenderAttr("href", _ctx.route("admin.newsletters.export", { type: exportType.value }))} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.download"))}</a></div></div></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: { email: _ctx.$t("messages.word.email"), phone: _ctx.$t("messages.word.phone") }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.newsletters.data, (newsletter) => {
        _push(`<tr><td>${ssrInterpolate(newsletter.value)}</td><td>${ssrInterpolate(newsletter.jalali_updated_at[2])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-newsletter-" + newsletter.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-newsletter-" + newsletter.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_newsletter"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.newsletters.destroy", newsletter.id),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.newsletters.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.newsletters.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Newsletters/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
