import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "laravel-vue-i18n";
import "lodash/debounce.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    prefactors: {},
    keyword: {}
  },
  setup(__props) {
    const userPhone = ref(null);
    const selectedUser = ref(null);
    const searchUserStatus = ref(false);
    const addPrefactorForm = useForm({
      user_id: null,
      title: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.prefactors")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.prefactors")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="action-container mb-4 d-flex align-items-center justify-content-end"><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#addPrefactor" class="btn btn-primary lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.create_prefactor"))} <i class="ri-add-line"></i></a><div class="modal fade edit-role-modal" id="addPrefactor" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_prefactor"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaPrefactorTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(addPrefactorForm).title)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.prefactor_title"))} class="form-control" id="eaPrefactorTitle"></div><div class="col-12 mb-2"><label for="eaPhone" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.select_user"))} <span class="fs-9 text-gray fw-light">(${ssrInterpolate(_ctx.$t("messages.sentence.user_phone"))})</span></label><div class="search-user-input d-flex align-items-center mb-2">`);
      if (selectedUser.value != null) {
        _push(`<button class="btn btn-danger btn-square btn-xs btn-delete"><i class="ri-close-line"></i></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input${ssrRenderAttr("value", userPhone.value)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.example") + ": 09123456789")} class="form-control" id="eaPhone" style="${ssrRenderStyle({ "direction": "ltr" })}"><button class="btn btn-dark ms-1 btn-square" type="button"${ssrIncludeBooleanAttr(searchUserStatus.value) ? " disabled" : ""}>`);
      if (searchUserStatus.value) {
        _push(`<i class="ri-refresh-line i-spin"></i>`);
      } else {
        _push(`<i class="ri-search-2-line"></i>`);
      }
      _push(`</button></div></div>`);
      if (selectedUser.value != null) {
        _push(`<div class="col-12 mb-4"><div class="user-simple-card d-inline-flex align-items-center"><img class="avatar"${ssrRenderAttr("src", selectedUser.value.get_avatar)}${ssrRenderAttr("alt", selectedUser.value.get_name)}><div class="d-flex flex-column justify-content-center ps-2"><div class="fw-bold lts-05 fs-7 mb-2">${ssrInterpolate(selectedUser.value.get_name)}</div><div class="fw-light text-gray lh-15">${ssrInterpolate(selectedUser.value.username)}</div></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.create"))}</button></div></form></div></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.factor_id") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          paid: _ctx.$t("messages.word.paid"),
          waiting_payment: _ctx.$t("messages.word.unpaid")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "1100px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.factor_id"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.creation_date"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.expire_date"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.prefactors.data, (prefactor) => {
        _push(`<tr><td class="white-space-nowrap">`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.users.show", prefactor.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(prefactor.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(prefactor.user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="lts-05">${ssrInterpolate(prefactor.title)}</td><td>${ssrInterpolate(prefactor.uuid)}</td><td class="lts-05 fs-9 white-space-nowrap">${ssrInterpolate(prefactor.jalali_created_at[2])}</td><td class="lts-05 fs-9 white-space-nowrap">`);
        if (prefactor.status == "awaiting_issuance") {
          _push(`<!--[--> - <!--]-->`);
        } else if (prefactor.status == "paid") {
          _push(`<!--[--> - <!--]-->`);
        } else {
          _push(`<!--[-->${ssrInterpolate(prefactor.jalali_expired_at[2])}<!--]-->`);
        }
        _push(`</td><td>`);
        if (prefactor.status == "awaiting_issuance") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_issuance"))}</span>`);
        } else if (prefactor.status == "paid") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.paid"))}</span>`);
        } else if (prefactor.is_expired) {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.expired"))}</span>`);
        } else if (prefactor.status == "waiting_payment") {
          _push(`<span class="badge bg-warning rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_pay"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (prefactor.status == "awaiting_issuance") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.prefactors.edit", prefactor.id),
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-file-edit-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.setting_up_pre_factor"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-file-edit-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.setting_up_pre_factor")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else if (prefactor.status == "paid") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.prefactors.show", prefactor.id),
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-eye-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.show"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-eye-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.show")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.prefactors.edit", prefactor.id),
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-file-edit-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.show"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-file-edit-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.show")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        }
        if (prefactor.status != "paid") {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-prefactor-" + prefactor.id)}><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-prefactor-" + prefactor.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_prefactor"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.prefactors.destroy", prefactor.id),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.prefactors.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.prefactors.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Financial/Prefactors/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
