import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    storages: {},
    keyword: {}
  },
  setup(__props) {
    const createStorageForm = useForm({
      name: null,
      address: null
    });
    const editStorageForm = useForm({
      name: "",
      address: ""
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.storage_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.storage_list"),
        item: _ctx.$t("messages.word.storages")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="action-container mb-4 d-flex align-items-center justify-content-end"><button data-bs-toggle="modal" data-bs-target="#createStorage" type="button" class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_storage"))} <i class="ri-add-line"></i></button></div><div class="modal fade" id="createStorage" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_storage"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaStorageName" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.storage_name"))}</label><input${ssrRenderAttr("value", unref(createStorageForm).name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.example_central_storage"))} class="form-control" id="eaStorageName"></div><div class="col-12 mb-4"><label for="eaStorageAddress" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.address"))}</label><textarea class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_storage_address"))} id="eaStorageAddress">${ssrInterpolate(unref(createStorageForm).address)}</textarea></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.create"))}</button></div></form></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.storage_name") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.storage_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.storage_name"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.product_count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.address"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.storages, (storage) => {
        _push(`<tr><td class="first-small white-space-nowrap clickable">${ssrInterpolate(storage.uuid)}</td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.storages.show", storage.uuid),
          class: "link active-link lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(storage.name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(storage.name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>${ssrInterpolate(storage.product_count)}</td><td>${ssrInterpolate(storage.address)}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item lts-05",
          href: _ctx.route("seller.storages.show", storage.uuid)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-eye-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.show"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-eye-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.show")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li><li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#edit-storage-" + storage.id)} class="dropdown-item lts-05"><i class="ri-pencil-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}</a></li>`);
        if (storage.product_count == 0) {
          _push(`<li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-storage-" + storage.id)} class="dropdown-item lts-05"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "edit-storage-" + storage.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5"><span>${ssrInterpolate(_ctx.$t("messages.sentence.edit_storage"))}:</span> ${ssrInterpolate(storage.name)}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaStorageName" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.storage_name"))}</label><input${ssrRenderAttr("value", unref(editStorageForm).name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.example_central_storage"))} class="form-control" id="eaStorageName"></div><div class="col-12 mb-4"><label for="eaStorageAddress" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.address"))}</label><textarea class="form-control"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.enter_storage_address"))} id="eaStorageAddress">${ssrInterpolate(unref(editStorageForm).address)}</textarea></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-storage-" + storage.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_storage"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("seller.storages.destroy", storage.uuid),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.storages.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Storage/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
