import { defineComponent, ref, unref, withCtx, createTextVNode, toDisplayString, createVNode, createBlock, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseEqual, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    users: {},
    roles: {},
    keyword: {}
  },
  setup(__props) {
    const props = __props;
    const rolesList = ref([]);
    for (let role in props.roles) {
      rolesList.value.push(props.roles[role]);
    }
    const promoteForm = useForm({
      role: null
    });
    const exportType = ref("all");
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.user_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.users")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex w-100 align-items-center justify-content-end mb-4"><button data-bs-toggle="modal" data-bs-target="#exportStorage" type="button" class="btn btn-light fs-8 fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.export_excel"))} <i class="ri-file-excel-2-line ms-2 fw-light fs-6"></i></button><div class="modal fade" id="exportStorage" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.users_excel_export"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-lg-4 col-12 mb-4"><label for="eaAll" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "all")) ? " checked" : ""} type="radio" value="all" class="form-check-box clickable me-1" id="eaAll"> ${ssrInterpolate(_ctx.$t("messages.sentence.all_users"))}</label></div><div class="col-lg-4 col-12 mb-4"><label for="eaInstock" class="form-label d-flex align-items-center white-space-nowrap clickable"><input${ssrIncludeBooleanAttr(ssrLooseEqual(exportType.value, "with_order")) ? " checked" : ""} type="radio" value="with_order" class="form-check-box clickable me-1" id="eaInstock"> ${ssrInterpolate(_ctx.$t("messages.sentence.users_with_orders"))}</label></div></div></div><div class="modal-footer"><a${ssrRenderAttr("href", _ctx.route("admin.users.export", { type: exportType.value }))} class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.download"))}</a></div></div></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.username_or_phone") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: {
          active: _ctx.$t("messages.word.active"),
          banned: _ctx.$t("messages.word.banned"),
          admin: _ctx.$t("messages.word.admin"),
          seller: _ctx.$t("messages.word.seller"),
          user: _ctx.$t("messages.word.user")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.avatar"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.name"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.phone"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.username"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.wallet"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.level"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.register_date"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.users.data, (user) => {
        _push(`<tr><td><img width="35" height="35" class="br-15 shadow-1"${ssrRenderAttr("src", user.get_avatar)}${ssrRenderAttr("alt", user.get_name)}></td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.users.show", user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>${ssrInterpolate(user.phone)}</td><td>${ssrInterpolate(user.username)}</td><td>${ssrInterpolate(user.wallet.get_formatted_amount)} <span class="text-badge">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td>`);
        if (user.type == "owner") {
          _push(`<td>${ssrInterpolate(_ctx.$t("messages.word.owner"))}</td>`);
        } else if (user.type == "admin") {
          _push(`<td>${ssrInterpolate(user.role.label)}</td>`);
        } else if (user.seller) {
          _push(`<td>${ssrInterpolate(_ctx.$t("messages.word.seller"))}</td>`);
        } else {
          _push(`<td>${ssrInterpolate(_ctx.$t("messages.word.user"))}</td>`);
        }
        _push(`<td>`);
        if (user.status == "active") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.active"))}</span>`);
        } else {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.banned"))}</span>`);
        }
        _push(`</td><td>${ssrInterpolate(user.jalali_created_at[0])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (user.type != "owner" && user.type != "admin") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "dropdown-item lts-05",
            href: _ctx.route("admin.users.show", user.id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-eye-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.show_and_edit"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-eye-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.show_and_edit")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else if (user.type == "owner" && _ctx.$page.props.auth.can["owner"] || user.type == "admin" && _ctx.$page.props.auth.can["owner"]) {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "dropdown-item lts-05",
            href: _ctx.route("admin.users.show", user.id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-eye-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.show_and_edit"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-eye-line" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.show_and_edit")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)"><i class="ri-spam-3-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.invisible"))}</a></li>`);
        }
        if (_ctx.$page.props.auth.can["owner"] && user.status != "banned") {
          _push(`<li>`);
          if (user.type != "admin" && user.type != "owner") {
            _push(`<a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#promote-user-" + user.id)}><i class="ri-user-star-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.promote_admin"))}</a>`);
          } else {
            _push(`<!---->`);
          }
          if (user.type == "admin") {
            _push(`<a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#demote-user-" + user.id)}><i class="ri-user-unfollow-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.demote_admin"))}</a>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (user.type != "admin" && user.type != "owner") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            class: "dropdown-item lts-05",
            method: "delete",
            as: "button",
            "preserve-scroll": "",
            href: _ctx.route("admin.users.destroy", user.id)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-spam-2-line"${_scopeId}></i>`);
                if (user.status == "active") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.ban"))}</span>`);
                } else {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.unban"))}</span>`);
                }
              } else {
                return [
                  createVNode("i", { class: "ri-spam-2-line" }),
                  user.status == "active" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("messages.word.ban")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("messages.word.unban")), 1))
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade promote-user-modal"${ssrRenderAttr("id", "promote-user-" + user.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.promote_admin"))}: <span class="ms-1">${ssrInterpolate(user.get_name)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.select_role"))}: </label>`);
        _push(ssrRenderComponent(unref(Dropdown), {
          class: "pvc-dropdown",
          modelValue: unref(promoteForm).role,
          "onUpdate:modelValue": ($event) => unref(promoteForm).role = $event,
          options: rolesList.value,
          display: "chip",
          optionLabel: "label",
          optionValue: "id",
          placeholder: _ctx.$t("messages.sentence.select_role")
        }, null, _parent));
        _push(`</div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.promote"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "demote-user-" + user.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_demote_user"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.admin.demote", user.id),
          method: "post",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.demote"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.demote")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.users.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.users.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Users/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
