import { defineComponent, unref, withCtx, createVNode, resolveDynamicComponent, createTextVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderVNode, ssrInterpolate, ssrRenderList, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./BlogLayout-BCPNogI1.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./ArticleAuthor-DNW4KDqb.js";
/* empty css                       */
/* empty css                           */
/* empty css             */
/* empty css              */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useRandomStr-4MeWbtRd.js";
import "./useHexToRgb-G7J9N7Ap.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    seo: {},
    articles: {},
    keywords: {},
    page: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="canonical"${ssrRenderAttr("href", _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.description != null) {
              _push2(`<meta name="description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.keywords != null) {
              _push2(`<meta name="keywords"${ssrRenderAttr("content", _ctx.seo.keywords)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.author != null) {
              _push2(`<meta name="author"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta property="og:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta property="og:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:url"${ssrRenderAttr("content", _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.image != null) {
              _push2(`<meta property="og:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.type != null) {
              _push2(`<meta property="og:type"${ssrRenderAttr("content", _ctx.seo.type)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:site_name"${ssrRenderAttr("content", _ctx.seo.site_name)}${_scopeId}><meta property="og:locale" content="fa_IR"${_scopeId}><meta name="twitter:card" content="summary_large_image"${_scopeId}><meta name="twitter:site"${ssrRenderAttr("content", _ctx.$page.props.appUrl)}${_scopeId}>`);
            if (_ctx.seo.author != null) {
              _push2(`<meta name="twitter:creator"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta name="twitter:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta name="twitter:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.image != null) {
              _push2(`<meta name="twitter:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.articles.data.length > 0) {
              _push2(`<meta name="robots" content="index, follow"${_scopeId}>`);
            } else {
              _push2(`<meta name="robots" content="noindex, follow"${_scopeId}>`);
            }
            if (_ctx.seo.schema != null) {
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.seo.schema)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                    ];
                  }
                }),
                _: 1
              }), _parent2, _scopeId);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("link", {
                rel: "canonical",
                href: _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl
              }, null, 8, ["href"]),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 0,
                name: "description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.keywords != null ? (openBlock(), createBlock("meta", {
                key: 1,
                name: "keywords",
                content: _ctx.seo.keywords
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 2,
                name: "author",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 3,
                property: "og:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 4,
                property: "og:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:url",
                content: _ctx.$page.props.currentUrl
              }, null, 8, ["content"]),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 5,
                property: "og:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.type != null ? (openBlock(), createBlock("meta", {
                key: 6,
                property: "og:type",
                content: _ctx.seo.type
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:site_name",
                content: _ctx.seo.site_name
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:locale",
                content: "fa_IR"
              }),
              createVNode("meta", {
                name: "twitter:card",
                content: "summary_large_image"
              }),
              createVNode("meta", {
                name: "twitter:site",
                content: _ctx.$page.props.appUrl
              }, null, 8, ["content"]),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 7,
                name: "twitter:creator",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 8,
                name: "twitter:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 9,
                name: "twitter:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 10,
                name: "twitter:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.articles.data.length > 0 ? (openBlock(), createBlock("meta", {
                key: 11,
                name: "robots",
                content: "index, follow"
              })) : (openBlock(), createBlock("meta", {
                key: 12,
                name: "robots",
                content: "noindex, follow"
              })),
              _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                key: 13,
                type: "application/ld+json"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                ]),
                _: 1
              })) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="container"><div class="archive-container mb-4"><div class="row">`);
      if (_ctx.keywords.cat.query != null) {
        _push(`<div class="col-12 mb-4"><div class="blog-archive-details"><span>${ssrInterpolate(_ctx.$t("messages.word.category"))}:</span> ${ssrInterpolate(_ctx.keywords.cat.title)}</div></div>`);
      } else if (_ctx.keywords.tag.query != null) {
        _push(`<div class="col-12 mb-4"><div class="blog-archive-details"><span>${ssrInterpolate(_ctx.$t("messages.word.hashtag"))}:</span> ${ssrInterpolate(_ctx.keywords.tag.title)}</div></div>`);
      } else if (_ctx.keywords.profile.query != null && _ctx.keywords.profile.user != null) {
        _push(`<div class="col-12 mb-4">`);
        _push(ssrRenderComponent(_sfc_main$2, {
          user: _ctx.keywords.profile.user
        }, null, _parent));
        _push(`<div class="blog-archive-details w-100 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.published_by_author"))}:</div></div>`);
      } else if (_ctx.keywords.brand.query != null) {
        _push(`<div class="col-12 mb-4"><div class="blog-archive-details"><span>${ssrInterpolate(_ctx.$t("messages.word.brand"))}:</span> ${ssrInterpolate(_ctx.keywords.brand.title)}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-12">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: {
          latest: _ctx.$t("messages.word.latest"),
          most_viewed: _ctx.$t("messages.word.most_viewed"),
          popular: _ctx.$t("messages.word.popular"),
          most_comment: _ctx.$t("messages.word.controversial"),
          editor_choice: _ctx.$t("messages.sentence.editor_choice")
        }
      }, null, _parent));
      _push(`</div><!--[-->`);
      ssrRenderList(_ctx.articles.data, (article) => {
        _push(`<div class="blog-article-image-box-container col-xl-3 col-lg-4 col-md-6 col-12"><div class="card article-image shadow-1"><div class="article-image--center-crop" style="${ssrRenderStyle(`background-image: url('${article.get_image.url}')`)}"></div><div class="black-gradient"></div>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "article-link",
          href: _ctx.route("blog.articles.show", article.slug)
        }, null, _parent));
        _push(`<div class="article--footer"><h3 class="article-title">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.show", article.slug),
          class: "link lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(article.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(article.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</h3><ul class="article-meta">`);
        if (article.user.seller) {
          _push(`<li><img${ssrRenderAttr("src", article.user.store.get_logo)}${ssrRenderAttr("alt", article.user.store.name)} class="article--meta-avatar shadow-1 me-2" height="32" width="32" loading="lazy">`);
          _push(ssrRenderComponent(unref(Link), {
            class: "article--meta-username",
            href: _ctx.route("blog.articles.index", { profile: article.user.store.uuid })
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(article.user.store.name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(article.user.store.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<li><img${ssrRenderAttr("src", article.user.get_avatar)}${ssrRenderAttr("alt", article.user.get_name)} class="article--meta-avatar shadow-1 me-2" height="32" width="32" loading="lazy">`);
          _push(ssrRenderComponent(unref(Link), {
            class: "article--meta-username",
            href: _ctx.route("blog.articles.index", { profile: article.user.username })
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(article.user.get_name)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(article.user.get_name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        }
        _push(`<li class="divider"></li><li><span class="date">${ssrInterpolate(article.jalali_created_at[0])}</span></li><li class="divider"></li><li><span class="date">${ssrInterpolate(article.get_formatted_view_count)} <i class="ri-eye-line"></i></span></li></ul></div><span class="category-badge">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.index", { cat: article.category.slug }),
          class: "link text-white"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(article.category.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(article.category.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</span>`);
        if (article.editor_choice) {
          _push(`<span class="editor-choice-badge badge bg-secondary shadow-secondary" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", _ctx.$t("messages.sentence.editor_choice"))}><i class="ri-vip-crown-2-fill"></i></span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--><div class="col-12">`);
      if (_ctx.articles.data.length == 0) {
        _push(`<div class="list-empty-box w-100 d-flex align-item-center justify-content-center p-5 bg-light text-light-gray br-15"><div class="d-flex flex-column align-item-center justify-content-center"><p class="lts-05 fs-6 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_article"))}</p>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("blog.articles.index"),
          class: "link d-inline-block lts-05 fs-7 text-center"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.articles_archive"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.articles_archive")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (_ctx.page != null || _ctx.articles.data.length >= 20) {
        _push(`<div class="col-12 d-flex align-items-center justify-content-center mt-4">`);
        _push(ssrRenderComponent(_sfc_main$4, {
          links: _ctx.articles.links,
          "preserve-scroll": true
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Blog/Articles/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
