import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderClass, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    transactions: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.transactions")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.word.transactions"))}</div>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.transaction_uuid") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: {
          accepted: _ctx.$t("messages.word.successful"),
          rejected: _ctx.$t("messages.word.unsuccessful"),
          deposit: _ctx.$t("messages.word.deposit"),
          withdrawal: _ctx.$t("messages.word.withdrawal")
        }
      }, null, _parent));
      _push(`<div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.type"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.price"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.description"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.transaction_uuid"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.transactions.data, (transaction) => {
        _push(`<tr><td>`);
        if (transaction.amount > 0) {
          _push(`<span class="text-success fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.deposit"))}</span>`);
        } else if (transaction.amount < 0 && transaction.type == "bank_withdrawal") {
          _push(`<span class="text-info fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.bank_withdrawal"))}</span>`);
        } else if (transaction.amount < 0) {
          _push(`<span class="text-danger fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.word.withdrawal"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (transaction.type == "seller_withdrawal" || transaction.type == "affiliate_withdrawal") {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-info": true })}">${ssrInterpolate(transaction.get_formatted_amount.replace("-", ""))}</span>`);
        } else {
          _push(`<span class="${ssrRenderClass({ "negative-number fw-bold": true, "text-danger": transaction.amount < 0, "text-success": transaction.amount > 0 })}">${ssrInterpolate(transaction.get_formatted_amount)}</span>`);
        }
        _push(`<span class="unit unit-sm"></span></td><td class="fs-8">${transaction.description ?? ""}</td><td>${ssrInterpolate(transaction.transaction_id)}</td><td>`);
        if (transaction.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_admin"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (transaction.status == "waiting_payment") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_pay"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (transaction.status == "accepted") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.successful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type != "seller_withdrawal" && transaction.type != "affiliate_withdrawal") {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.unsuccessful"))}</span>`);
        } else if (transaction.status == "rejected" && transaction.type == "bank_withdrawal") {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(transaction.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.transactions.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.transactions.links
      }, null, _parent));
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Financial/Transactions/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
