import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    orderGroups: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.order_list")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title panel-content--title-with-button mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.word.orders"))}</div><div class="orders-list list"><div class="order-groups-list">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.order_uuid") + " ..."
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "750px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.consignments"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.main_status"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.registered_date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.orderGroups.data, (og) => {
        _push(`<tr><td class="orders-badge"><ul><!--[-->`);
        ssrRenderList(og.orders, (order) => {
          _push(`<li class="d-inline-flex align-items-center justify-content-between"><div class="d-flex flex-column justify-content-center"><div class="lts-05 mb-1"><span class="fs-9 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.consignment_uuid"))}: </span><span class="fw-bold text-dark fs-8">${ssrInterpolate(order.uuid)}</span></div><div class="lts-05"><span class="fs-9 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.send_by"))}: </span>`);
          if (order.get_send_by == null) {
            _push(`<span class="text-dark fw-bold fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span>`);
          } else {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("main.stores.show", order.get_send_by.uuid),
              class: "link fw-bold lts-05 fs-8"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(order.get_send_by.name)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(order.get_send_by.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          }
          _push(`</div></div><div class="d-flex flex-column justify-content-center ms-4"><div class="status lts-05 mb-1">`);
          if (order.status == "registered") {
            _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.word.processing"))}</span>`);
          } else if (order.status == "sent") {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.sent"))}</span>`);
          } else if (order.status == "delivered") {
            _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.delivered"))}</span>`);
          } else if (order.status == "cancelled") {
            _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.cancelled"))}</span>`);
          } else if (order.status == "returned") {
            _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.returned"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("user.orders.show", order.id),
            as: "button",
            class: "btn btn-outline-light pt-1 pb-1 lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.check"))}</span><i class="ri-arrow-left-s-fill"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("span", null, toDisplayString(_ctx.$t("messages.word.check")), 1),
                  createVNode("i", { class: "ri-arrow-left-s-fill" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></li>`);
        });
        _push(`<!--]--></ul></td><td class="first-small white-space-nowrap">${ssrInterpolate(og.uuid)}</td><td class="first-small white-space-nowrap">`);
        if (og.status == "processing") {
          _push(`<span class="badge bg-purple">${ssrInterpolate(_ctx.$t("messages.word.processing"))}</span>`);
        } else if (og.status == "completed") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.completed"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="first-small white-space-nowrap lts-05 fs-8">${ssrInterpolate(og.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.orderGroups.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p>${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$3, {
        links: _ctx.orderGroups.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Orders/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
