import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle } from "vue/server-renderer";
import { u as useNumberFormat } from "../ssr.js";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "jquery";
import "swiper";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    product_hitsory: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.last_seens")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="row"><div class="col-lg-12 full-product-horizontal-container mb-3"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.last_seens"))}</div><div class="product-list"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.product_hitsory, (product) => {
        _push(`<!--[-->`);
        if (product.status == "publish") {
          _push(`<div class="col-lg-6 col-12 mb-3"><div class="card product-horizontal"><div class="card-body"><div class="product-horizontal--content d-flex flex-row align-items-center"><img${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.title)}><h3>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</h3></div><div class="product-horizontal--footer d-flex flex-row align-items-center justify-content-between"><div><ul class="product-colors el-center"><!--[-->`);
          ssrRenderList(product.unique_color, (color, index) => {
            _push(`<li style="${ssrRenderStyle({ "background-color": color.value.color })}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)}></li>`);
          });
          _push(`<!--]--></ul></div><div><span class="product-rating-average">${ssrInterpolate(product.comments_info.rating == "0" ? "-" : product.comments_info.rating)} <i class="ri-star-fill"></i></span><span class="divider">|</span>`);
          if (!product.in_stock_status) {
            _push(`<span class="product-price-now fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span>`);
          } else if (product.inventory) {
            _push(`<span class="product-price-now lts-05">${ssrInterpolate(unref(useNumberFormat)(product.best_price))} <span class="unit unit-sm"></span></span>`);
          } else {
            _push(`<span class="product-price-now fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span>`);
          }
          _push(`</div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></div></div>`);
      if (_ctx.product_hitsory.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/History/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
