import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$4 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$2 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "lodash/debounce.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    prefactors: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.prefactors")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content"><div class="card-body"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.word.prefactors"))}</div>`);
      _push(ssrRenderComponent(_sfc_main$2, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.transaction_uuid") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: {
          paid: _ctx.$t("messages.word.paid"),
          waiting_payment: _ctx.$t("messages.word.unpaid")
        }
      }, null, _parent));
      _push(`<div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.factor_id"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.creation_date"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.expire_date"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.prefactors.data, (prefactor) => {
        _push(`<tr><td class="lts-05">${ssrInterpolate(prefactor.title)}</td><td>${ssrInterpolate(prefactor.uuid)}</td><td class="lts-05 fs-9 white-space-nowrap">${ssrInterpolate(prefactor.jalali_created_at[2])}</td><td class="lts-05 fs-9 white-space-nowrap">`);
        if (prefactor.status == "awaiting_issuance") {
          _push(`<!--[--> - <!--]-->`);
        } else if (prefactor.status == "paid") {
          _push(`<!--[--> - <!--]-->`);
        } else {
          _push(`<!--[-->${ssrInterpolate(prefactor.jalali_expired_at[2])}<!--]-->`);
        }
        _push(`</td><td>`);
        if (prefactor.status == "paid") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.paid"))}</span>`);
        } else if (prefactor.is_expired) {
          _push(`<span class="badge bg-danger rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.expired"))}</span>`);
        } else if (prefactor.status == "waiting_payment") {
          _push(`<span class="badge bg-warning rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_pay"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (prefactor.status == "waiting_payment") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("prefactor.shiping", prefactor.uuid),
            class: "btn btn-success fs-8 fw-bold"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.payment"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.payment")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<span>-</span>`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.prefactors.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$4, {
        links: _ctx.prefactors.links
      }, null, _parent));
      _push(`</div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Financial/Prefactors/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
