import { defineComponent, ref, watch, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle, ssrIncludeBooleanAttr, ssrLooseContain } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$4 } from "./NumInput-Bt6uFGO4.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "./useRandomStr-4MeWbtRd.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    comments: {},
    keyword: {}
  },
  setup(__props) {
    const sendAnswerForm = useForm({
      content: null
    });
    const rating = ref();
    watch(rating, (value) => {
      if (value > 5) {
        rating.value = 5;
      } else if (value < 1) {
        rating.value = 1;
      }
    });
    const editCommentForm = useForm({
      content: "",
      rating: "",
      vote_up: "",
      vote_down: "",
      buy_suggest: false
    });
    const imagePreview = ref();
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.product_comments")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.product_comments")
      }, null, _parent));
      _push(`<div class="comment-list orders-list list"><div class="card"><div class="card-body"><div class="d-block mb-3"><span class="d-inline-block fs-8 lts-05 text-gray">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548001"))}</span></div><div class="comments orders">`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: { publish: _ctx.$t("messages.word.published"), awaiting: _ctx.$t("messages.sentence.awaiting_verify"), reported: _ctx.$t("messages.word.reported") }
      }, null, _parent));
      _push(`<div class="comment-items user-order-items"><!--[-->`);
      ssrRenderList(_ctx.comments.data, (comment) => {
        _push(`<div class="comment-item user-order-item"><div class="user-order-item-header"><div class="mb-3"><div class="row">`);
        if (comment.status == "awaiting") {
          _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta has-circle-animation yellow"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span></span></div>`);
        } else if (comment.reported) {
          _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta has-circle-animation red"><span class="text-muted lts-05 me-1">${ssrInterpolate(_ctx.$t("messages.word.reported"))}</span></span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.user"))}: </span>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link link-icon",
          href: _ctx.route("admin.users.show", comment.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(comment.user.get_name)} <i class="ri-external-link-line"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(comment.user.get_name) + " ", 1),
                createVNode("i", { class: "ri-external-link-line" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.like"))}: </span> ${ssrInterpolate(comment.vote_up)}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.unlike"))}: </span> ${ssrInterpolate(comment.vote_down)}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.rating"))}: </span> ${ssrInterpolate(comment.rating)} ${ssrInterpolate(_ctx.$t("messages.sentence.from_5_rating"))}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.date"))}: </span> ${ssrInterpolate(comment.jalali_created_at[0])}</span></div><div class="col-sm-auto mb-2"><span class="user-order-meta"><span class="text-muted me-1">${ssrInterpolate(_ctx.$t("messages.word.product"))}: </span><a class="link link-icon"${ssrRenderAttr("href", _ctx.route("main.products.show", comment.product.slug))} target="_blank">${ssrInterpolate(comment.product.title)} <i class="ri-external-link-line"></i></a></span></div></div></div><div class="row send-details mb-4"><div class="col-12 mb-2">`);
        if (comment.is_buyer) {
          _push(`<span class="badge bg-white" style="${ssrRenderStyle({ "color": "#000" })}">${ssrInterpolate(_ctx.$t("messages.word.buyer"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="col-sm-auto mb-2">`);
        if (comment.buy_suggest == "1") {
          _push(`<span class="user-order-meta text-success">${ssrInterpolate(_ctx.$t("messages.sentence.suggest_product"))}</span>`);
        } else if (comment.buy_suggest == "0") {
          _push(`<span class="user-order-meta text-danger">${ssrInterpolate(_ctx.$t("messages.sentence.not_suggest_product"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="col-12 user-order-item-header--meta mb-3"><span class="user-order-meta mb-0"><span class="text-muted">${ssrInterpolate(_ctx.$t("messages.sentence.comment_content"))}: </span><span class="fw-bold ms-1">${ssrInterpolate(comment.content)}</span></span></div>`);
        if (comment.get_strengths.length > 0) {
          _push(`<!--[--><div class="col-sm-auto mb-2"><div class="title text-success">${ssrInterpolate(_ctx.$t("messages.sentence.strengths"))}:</div></div><!--[-->`);
          ssrRenderList(comment.get_strengths, (strength, index) => {
            _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta positive"><span class="text-muted me-1">${ssrInterpolate(strength)}</span></span></div>`);
          });
          _push(`<!--]--><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (comment.get_weakness.length > 0) {
          _push(`<!--[--><div class="col-sm-auto mb-2"><div class="title text-danger">${ssrInterpolate(_ctx.$t("messages.sentence.weakness"))}:</div></div><!--[-->`);
          ssrRenderList(comment.get_weakness, (weakness, index) => {
            _push(`<div class="col-sm-auto mb-2"><span class="user-order-meta negative"><span class="text-muted me-1">${ssrInterpolate(weakness)}</span></span></div>`);
          });
          _push(`<!--]--><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (comment.get_images.length > 0) {
          _push(`<ul class="comment-images mt-3 mb-3"><!--[-->`);
          ssrRenderList(comment.get_images, (image, index) => {
            _push(`<li class="image-grid clickable"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + image.url + ")")}"></div></div></div></li>`);
          });
          _push(`<!--]--></ul>`);
        } else {
          _push(`<!---->`);
        }
        if (comment.get_answer != null) {
          _push(`<div class="col-12"><div class="row send-details admin-answer"><div class="col-sm-auto mb-1"><span class="user-order-meta">${ssrInterpolate(comment.get_answer.user.name)} <span class="text-muted ms-1">${ssrInterpolate(comment.get_answer.user.role.label)}</span></span></div><div class="col-sm-auto p-0 mb-2">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.product.comments.delete_answer", comment.id),
            method: "delete",
            as: "button",
            class: "btn remove-answer"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-close-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-close-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div><div class="col-12 user-order-item-header--meta"><p class="fw-bold mb-0">${ssrInterpolate(comment.get_answer.content)}</p></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="row"><div class="col-12 d-flex align-items-center justify-content-end dropup"><a href="javascript:void(0)" data-bs-toggle="dropdown" class="btn btn-link fw-bold user-order-detail-link">${ssrInterpolate(_ctx.$t("messages.sentence.action_menu"))} <i class="ri-arrow-left-s-fill"></i></a><div class="dropdown-menu shadow-smooth-2 mb-1 mt-1"><ul>`);
        if (comment.status == "awaiting") {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.product.comments.accept", comment.id),
            method: "post",
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-chat-check-line me-1"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.accept"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-chat-check-line me-1" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.accept")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else if (comment.reported) {
          _push(`<li>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.product.comments.remove_report", comment.id),
            method: "post",
            as: "button",
            class: "dropdown-item lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-chat-check-line me-1"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.ignore_the_report"))}`);
              } else {
                return [
                  createVNode("i", { class: "ri-chat-check-line me-1" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.ignore_the_report")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#comment-answer-" + comment.id)}><i class="ri-send-plane-2-line me-1"></i> ${ssrInterpolate(comment.get_answer == null ? _ctx.$t("messages.sentence.send_answer") : _ctx.$t("messages.sentence.edit_answer"))}</a></li><li><a class="dropdown-item lts-05" href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#comment-edit-" + comment.id)}><i class="ri-pencil-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.edit"))}</a></li><li><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#comment-delete-" + comment.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line me-1"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button></li></ul></div><div class="modal fade"${ssrRenderAttr("id", "comment-answer-" + comment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.send_answer"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.answer"))}: <textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.write_your_answer") + " ...")} required class="form-control">${ssrInterpolate(unref(sendAnswerForm).content)}</textarea></label></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.send"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "comment-edit-" + comment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.edit_comment"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-3"><label class="form-label">${ssrInterpolate(_ctx.$t("messages.word.content"))}: <textarea type="text" placeholder="متن دیدگاه ..." required class="form-control">${ssrInterpolate(unref(editCommentForm).content)}</textarea></label></div><div class="col-12 mb-3"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.sentence.from_5_rating"))} `);
        _push(ssrRenderComponent(_sfc_main$4, {
          modelValue: rating.value,
          "onUpdate:modelValue": ($event) => rating.value = $event,
          type: "text",
          required: "",
          class: "form-control"
        }, null, _parent));
        _push(`</label></div><div class="col-sm-6 col-12 mb-3"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.like"))} `);
        _push(ssrRenderComponent(_sfc_main$4, {
          modelValue: unref(editCommentForm).vote_up,
          "onUpdate:modelValue": ($event) => unref(editCommentForm).vote_up = $event,
          type: "text",
          required: "",
          class: "form-control"
        }, null, _parent));
        _push(`</label></div><div class="col-sm-6 col-12 mb-3"><label for="eaFirstName" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.unlike"))} `);
        _push(ssrRenderComponent(_sfc_main$4, {
          modelValue: unref(editCommentForm).vote_down,
          "onUpdate:modelValue": ($event) => unref(editCommentForm).vote_down = $event,
          type: "text",
          required: "",
          class: "form-control"
        }, null, _parent));
        _push(`</label></div>`);
        if (comment.buy_suggest != null) {
          _push(`<div class="col-12 mb-3"><div class="form-check form-switch mb-3"><label class="form-check-label lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.is_suggest_product"))} <input${ssrIncludeBooleanAttr(Array.isArray(unref(editCommentForm).buy_suggest) ? ssrLooseContain(unref(editCommentForm).buy_suggest, null) : unref(editCommentForm).buy_suggest) ? " checked" : ""} class="form-check-input" type="checkbox" role="switch" checked></label></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div><div class="modal-footer"><button data-bs-dismiss="modal" aria-label="Close" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "comment-delete-" + comment.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_yo_sure_delete_comment"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.product.comments.delete", comment.id),
          method: "delete",
          as: "button",
          "data-bs-dismiss": "modal",
          "aria-label": "Close",
          class: "btn btn-sm btn-danger px-3"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div></div></div></div></div></div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.comments.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")} alt=""></div><div class="empty-content-message text-center"><p class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.comments.data.length > 0) {
        _push(ssrRenderComponent(_sfc_main$5, {
          links: _ctx.comments.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div>`);
      if (imagePreview.value != null) {
        _push(`<div class="show-ticket-image"><div class="overlay"><div><img class="shadow-1"${ssrRenderAttr("src", imagePreview.value["link"])}${ssrRenderAttr("alt", imagePreview.value["alt"])}><span class="shadow-1">${ssrInterpolate(imagePreview.value["alt"])}</span></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Comments/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
