import { defineComponent, inject, watch, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    templates: {}
  },
  setup(__props) {
    const createTemplateForm = useForm({
      title: null,
      description: null,
      image: ""
    });
    const mediaReactive = inject("mediaData");
    watch(mediaReactive, (media) => {
      if (media.type == "demo" && media.file != null) {
        createTemplateForm.image = media.file.url;
        $("#openAddTemplateModal").trigger("click");
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.manage_template")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.manage_template")
      }, null, _parent));
      _push(`<div class="row"><div class="col-12 mb-4"><div class="card"><div class="card-body d-flex align-items-center justify-content-between"><div class="template-count-text">${ssrInterpolate(_ctx.$t("messages.word.count"))}: ${ssrInterpolate(_ctx.templates.length)} ${ssrInterpolate(_ctx.$t("messages.word.template"))}</div><button class="create-menu btn btn-primary shadow-1 lts-05" id="openAddTemplateModal" data-bs-toggle="modal" data-bs-target="#addTemplate">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_template"))} <i class="ri-add-line"></i></button><div class="modal fade" id="addTemplate" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.create_new_template"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12 mb-4"><label for="eaTemplateTitle" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.title"))}</label><input${ssrRenderAttr("value", unref(createTemplateForm).title)} type="text" placeholder="عنوان قالب" class="form-control" id="eaTemplateTitle"></div><div class="col-12 mb-4"><label for="eaTemplateDescription" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.description"))}</label><textarea type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.template_description_summary"))} class="form-control" id="eaTemplateDescription">${ssrInterpolate(unref(createTemplateForm).description)}</textarea></div><div class="col-12 upload-file-container mb-0"><div class="form-element-row form-element-row-file"><div class="text-center"><div class="fs-7 text-muted mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.template_demo_image"))}</div></div>`);
      if (unref(createTemplateForm).image != "") {
        _push(`<div class="selected-image"><img class="shadow-1"${ssrRenderAttr("src", unref(createTemplateForm).image)}><i class="ri-close-line shadow-1 remove-image"></i></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(createTemplateForm).image == "") {
        _push(`<div class="custom-input-file"><label class="custom-input-file-label" data-bs-toggle="modal" data-bs-target="#mediaLibrary" data-bs-input="demo"><span class="label"><i class="ri-arrow-up-fill me-1"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.select_image"))}</span></label></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><div class="modal-footer"><button data-bs-dismiss="modal" class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.sentence.create_template"))}</button></div></form></div></div></div></div></div></div><!--[-->`);
      ssrRenderList(_ctx.templates, (template) => {
        _push(`<div class="col-xl-4 col-lg-4 col-md-6 col-12 mb-4"><div class="template-section shadow-1"><div class="image-grid pt-70 mb-3"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle({ "background-image": "url(" + _ctx.$page.props.appUrl + template.image + ")" })}"></div></div></div></div><div class="template-name d-flex align-items-center justify-content-between mb-2"><span>${ssrInterpolate(template.title)}</span>`);
        if (template.type == "system") {
          _push(`<div class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.by_system"))}</div>`);
        } else {
          _push(`<div class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.by_user"))}</div>`);
        }
        _push(`</div><div class="template-description mb-3"><p class="lts-05 mb-0">${ssrInterpolate(template.description != null ? template.description : _ctx.$t("messages.sentence.no_description"))}</p></div><div class="button-area d-flex align-items-center justify-content-center">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.templates.switch", template.id),
          as: "button",
          method: "post",
          class: { "btn fs-8 me-1": true, "btn-light": template.status != "active", "btn-success": template.status == "active" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(template.status == "active" ? _ctx.$t("messages.word.active") : _ctx.$t("messages.word.select"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(template.status == "active" ? _ctx.$t("messages.word.active") : _ctx.$t("messages.word.select")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`<a${ssrRenderAttr("href", _ctx.route("admin.templates.edit", template.id))} class="btn btn-light fs-8 ms-1">${ssrInterpolate(_ctx.$t("messages.word.edit"))}</a>`);
        if (template.type == "system") {
          _push(`<button class="btn btn-light fs-8 ms-1" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#removeTemplate-" + template.id)}>${ssrInterpolate(_ctx.$t("messages.word.reset"))}</button>`);
        } else {
          _push(`<button class="btn btn-light fs-8 ms-1" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#removeTemplate-" + template.id)}>${ssrInterpolate(_ctx.$t("messages.word.delete"))}</button>`);
        }
        _push(`</div><div class="modal fade"${ssrRenderAttr("id", "removeTemplate-" + template.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><div class="modal-header">`);
        if (template.type == "system") {
          _push(`<div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.word.reset"))} ${ssrInterpolate(_ctx.$t("messages.word.template"))}</div>`);
        } else {
          _push(`<div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.delete_template"))}</div>`);
        }
        _push(`<button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body">`);
        if (template.type == "system") {
          _push(`<p class="text-dark lts-05"><b class="text-danger">${ssrInterpolate(_ctx.$t("messages.word.warning"))}:</b> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_321558"))}</p>`);
        } else {
          _push(`<p class="text-dark lts-05"><b class="text-danger">${ssrInterpolate(_ctx.$t("messages.word.warning"))}:</b> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_986652"))}</p>`);
        }
        _push(`</div><div class="modal-footer">`);
        if (template.type == "system") {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.templates.destroy", template.id),
            as: "button",
            method: "delete",
            "data-bs-dismiss": "modal",
            class: "btn btn-sm btn-danger px-3"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.reset"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.reset")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("admin.templates.destroy", template.id),
            as: "button",
            method: "delete",
            "data-bs-dismiss": "modal",
            class: "btn btn-sm btn-danger px-3"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        }
        _push(`</div></div></div></div></div></div>`);
      });
      _push(`<!--]--></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Templates/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
