import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, createVNode, toDisplayString, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { Head, Link } from "@inertiajs/vue3";
import "lodash/debounce.js";
import "simplebar";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "./useNl2br-BIw8h5gy.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    tickets: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.ticket_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.tickets")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex align-items-center justify-content-end mb-4">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.tickets.create"),
        class: "btn btn-primary shadow-1 lts-05 px-4"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_new_ticket"))} <i class="ri-send-plane-2-line ms-2"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_new_ticket")) + " ", 1),
              createVNode("i", { class: "ri-send-plane-2-line ms-2" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.ticket_title") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: { waiting_admin: _ctx.$t("messages.sentence.awaiting_answer"), waiting_user: _ctx.$t("messages.word.answered"), closed: _ctx.$t("messages.word.closed") }
      }, null, _parent));
      _push(`<div class="table-responsive simplebar-container mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.priority"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.tickets.data, (ticket) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("seller.tickets.show", ticket.id),
          class: { link: true, "fw-normal": ticket.status == "waiting_admin" || ticket.status == "closed" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(ticket.title)}`);
            } else {
              return [
                createTextVNode(toDisplayString(ticket.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td class="lts-05 fs-8">`);
        if (ticket.priority == "high") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.high"))}</span>`);
        } else if (ticket.priority == "normal") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.average"))}</span>`);
        } else if (ticket.priority == "low") {
          _push(`<span>${ssrInterpolate(_ctx.$t("messages.word.low"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>`);
        if (ticket.status == "waiting_admin") {
          _push(`<span class="badge bg-info rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_answer"))}</span>`);
        } else if (ticket.status == "waiting_user") {
          _push(`<span class="badge bg-success rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.answered"))}</span>`);
        } else if (ticket.status == "closed") {
          _push(`<span class="badge bg-dark rounded-pill fs-7">${ssrInterpolate(_ctx.$t("messages.word.closed"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="lts-05 fs-8">${ssrInterpolate(ticket.jalali_updated_at[3])}</td><td>`);
        if (ticket.status != "closed") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("seller.tickets.destroy", ticket.id),
            as: "button",
            method: "delete",
            class: "btn btn-dark btn-square btn-xs"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.close"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-lock-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-lock-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.tickets.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.tickets.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Tickets/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
