import { defineComponent, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    categories: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.article_category_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.article_categories")
      }, null, _parent));
      _push(`<div class="category-container row mb-4 mt-4"><div class="col-12 mb-4">`);
      if (_ctx.categories.length != 0) {
        _push(`<div class="mb-4"><div class="card-body"><div class="d-flex align-items-center justify-content-end">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.article.categories.create"),
          class: "btn btn-primary shadow-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_new_category"))} <i class="ri-add-line"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_new_category")) + " ", 1),
                createVNode("i", { class: "ri-add-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="row"><div class="col-12 mb-4"><div class="accordion" id="accordionMenu"><!--[-->`);
      ssrRenderList(_ctx.categories, (category, index) => {
        _push(`<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-menu-" + category.id)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-menu-" + category.id)}><i class="ri-arrow-drop-left-line me-1"></i> ${ssrInterpolate(category.title)}</button></h2><div${ssrRenderAttr("id", "collapse-menu-" + category.id)} class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><div class="d-flex align-items-center justify-content-end accordion-action-button">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.article.categories.edit", category.slug),
          as: "button",
          class: "btn btn-white btn-sm btn-square shadow-1 ms-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-pencil-line"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "ri-pencil-line" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`<button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#statistics-" + category.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-bar-chart-2-line"></i></button><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-cat-" + category.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-delete-bin-line"></i></button></div><div class="modal fade"${ssrRenderAttr("id", "statistics-" + category.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.category_statistics"))}: <span class="ms-1">${ssrInterpolate(category.title)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.word.view"))}</td><td>${ssrInterpolate(category.get_formatted_view_count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.articles_count"))}</td><td>${ssrInterpolate(category.articles_count)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-cat-" + category.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_category"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.article.categories.destroy", category.slug),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></div></div></div>`);
      });
      _push(`<!--]--></div></div>`);
      if (_ctx.categories.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05 p-4 d-flex align-items-center justify-content-center flex-column">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_category_yet"))} `);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.article.categories.create"),
          class: "btn btn-primary shadow-1 lts-05 mt-4"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_new_category"))} <i class="ri-add-line"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_new_category")) + " ", 1),
                createVNode("i", { class: "ri-add-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Blog/Categories/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
