import { defineComponent, unref, withCtx, createTextVNode, createVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    forms: {},
    keyword: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.forms")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.forms")
      }, null, _parent));
      _push(`<div class="form-list product-list list mb-4"><div class="card"><div class="card-body"><div class="action-container mb-4 d-flex align-items-center justify-content-end">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("admin.forms.create"),
        as: "button",
        class: "btn btn-primary"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_new_form"))} <i class="ri-add-line"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_new_form")) + " ", 1),
              createVNode("i", { class: "ri-add-line" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.form_title") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: { publish: _ctx.$t("messages.word.published"), draft: _ctx.$t("messages.word.draft") }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.answer_count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.form_type"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.forms.data, (form) => {
        _push(`<tr><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "product-title product-title-min-300",
          href: _ctx.route("admin.forms.show", form.slug)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(form.title)} `);
              if (form.get_unread_count != "0") {
                _push2(`<span class="count-badge"${_scopeId}>${ssrInterpolate(form.get_unread_count)}</span>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<span class="text-badge"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.word.show"))}</span>`);
            } else {
              return [
                createTextVNode(toDisplayString(form.title) + " ", 1),
                form.get_unread_count != "0" ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "count-badge"
                }, toDisplayString(form.get_unread_count), 1)) : createCommentVNode("", true),
                createVNode("span", { class: "text-badge" }, toDisplayString(_ctx.$t("messages.word.show")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>${ssrInterpolate(form.form_answers_count)}</td><td>${ssrInterpolate(form.get_formatted_view_count)}</td><td>${ssrInterpolate(form.flag == "system" ? _ctx.$t("messages.word.system") : _ctx.$t("messages.word.normal"))}</td><td class="lts-05">`);
        if (form.status == "publish") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.published"))}</span>`);
        } else if (form.status == "draft") {
          _push(`<span class="badge bg-warning">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(form.jalali_updated_at[3])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul>`);
        if (form.status == "publish") {
          _push(`<li><a class="dropdown-item lts-05" target="_blank"${ssrRenderAttr("href", _ctx.route("main.forms.show", form.slug))}><i class="ri-eye-line"></i> ${ssrInterpolate(_ctx.$t("messages.sentence.show_form"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.forms.show", form.slug),
          as: "button",
          class: "dropdown-item lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-question-answer-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.show_answers"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-question-answer-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.show_answers")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li><li>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.forms.edit", form.slug),
          as: "button",
          class: "dropdown-item lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.edit_form"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-pencil-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.edit_form")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
        if (form.flag != "system") {
          _push(`<li>`);
          if (form.status == "publish") {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("admin.forms.destroy", form.slug),
              method: "delete",
              as: "button",
              data: { status: "draft" },
              class: "dropdown-item no-btn"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<i class="ri-spam-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.unpublish"))}`);
                } else {
                  return [
                    createVNode("i", { class: "ri-spam-3-line" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.unpublish")), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else if (form.status == "draft") {
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("admin.forms.destroy", form.slug),
              method: "delete",
              as: "button",
              data: { status: "publish" },
              class: "dropdown-item no-btn"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<i class="ri-spam-3-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.word.publish"))}`);
                } else {
                  return [
                    createVNode("i", { class: "ri-spam-3-line" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("messages.word.publish")), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        if (form.flag != "system") {
          _push(`<li><a href="javascript:void(0)" data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-form-" + form.id)} class="dropdown-item no-btn"><i class="ri-delete-bin-line"></i> ${ssrInterpolate(_ctx.$t("messages.word.delete"))}</a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div><div class="modal fade"${ssrRenderAttr("id", "remove-form-" + form.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_form"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.forms.destroy", form.slug),
          method: "delete",
          data: { status: "deleted" },
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.forms.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.forms.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Forms/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
