import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Pagination-C1AQrLe3.js";
import { u as useNumberFormat } from "../ssr.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    product_favorites: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.favorites")
      }, null, _parent));
      _push(`<div class="card shadow-1 panel-content" style="${ssrRenderStyle({ "min-height": "100%" })}"><div class="card-body"><div class="row"><div class="col-lg-12 full-product-horizontal-container mb-3"><div class="panel-content--title mb-4 lts-05">${ssrInterpolate(_ctx.$t("messages.word.favorites"))}</div><div class="product-list"><div class="row"><!--[-->`);
      ssrRenderList(_ctx.product_favorites.data, (favorite) => {
        _push(`<!--[-->`);
        if (favorite.product.status == "publish") {
          _push(`<div class="col-lg-6 col-12 mb-3"><div class="card product-horizontal"><div class="card-body"><div class="product-horizontal--content d-flex flex-row align-items-center"><img${ssrRenderAttr("src", favorite.product.get_images[0]["link"])}${ssrRenderAttr("alt", favorite.product.title)}><h3>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", favorite.product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(favorite.product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(favorite.product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</h3></div><div class="product-horizontal--footer d-flex flex-row align-items-center justify-content-between"><div><ul class="product-colors el-center"><!--[-->`);
          ssrRenderList(favorite.product.unique_color, (color, index) => {
            _push(`<li style="${ssrRenderStyle({ "background-color": color.value.color })}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)}></li>`);
          });
          _push(`<!--]--></ul></div><div><span class="product-rating-average">${ssrInterpolate(favorite.product.comments_info.rating == "0" ? "-" : favorite.product.comments_info.rating)} <i class="ri-star-fill"></i></span><span class="divider">|</span>`);
          if (!favorite.product.in_stock_status) {
            _push(`<span class="product-price-now fs-9 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span>`);
          } else if (favorite.product.inventory) {
            _push(`<span class="product-price-now lts-05">${ssrInterpolate(unref(useNumberFormat)(favorite.product.best_price))} <span class="unit unit-sm"></span></span>`);
          } else {
            _push(`<span class="product-price-now fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span>`);
          }
          _push(`</div></div>`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.favorites", favorite.product.slug),
            as: "button",
            method: "post",
            class: "remove-item btn"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-close-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-close-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></div></div>`);
      if (_ctx.product_favorites.data.length == 0) {
        _push(`<div class="cart-empty"><div class="empty-content-icon"><img${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/orders.svg")}></div><div class="empty-content-message text-center"><p class="mb-4 lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</p></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.product_favorites.data.length != 0) {
        _push(ssrRenderComponent(_sfc_main$2, {
          links: _ctx.product_favorites.links
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Favorites/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
