import { defineComponent, resolveDirective, unref, withCtx, createTextVNode, createVNode, toDisplayString, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1, a as _sfc_main$2 } from "./StoreLayout-D2_RagXW.js";
import { u as useNl2br } from "./useNl2br-BIw8h5gy.js";
import { u as useNumberFormat } from "../ssr.js";
import { Head, Link } from "@inertiajs/vue3";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "jquery";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "./useRandomNum-DNNSqR7b.js";
import "bootstrap";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "swiper/bundle";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    product: {},
    inventories: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.manage_inventories")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.manage_inventories"),
        item: _ctx.$t("messages.word.storages")
      }, null, _parent));
      _push(`<div class="product-list prices-section manage-inventory list mb-4"><div class="card"><div class="card-body"><div class="d-flex align-items-center justify-content-end mb-4">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("seller.inventories.create", { uuid: _ctx.product.uuid }),
        as: "button",
        class: "btn btn-primary ms-2"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_inventory"))} <i class="ri-add-line ms-1"${_scopeId}></i>`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_inventory")) + " ", 1),
              createVNode("i", { class: "ri-add-line ms-1" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "1100px" })}"><tbody><tr><td class="first-small"><img class="br-10" width="35" height="35"${ssrRenderAttr("src", _ctx.product.get_images[0]["link"])}${ssrRenderAttr("alt", _ctx.product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { bottom: true }))}><a class="product-title"${ssrRenderAttr("href", _ctx.route("main.products.show", _ctx.product.slug))} target="_blank">${ssrInterpolate(_ctx.product.title)}</a>`);
      if (_ctx.product.is_vip) {
        _push(`<i class="ri-star-s-fill vip-product"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</td><td class="table-td-options">${ssrInterpolate(_ctx.$t("messages.sentence.sale_variables"))}: `);
      if (Object.keys(_ctx.product.price_model).length > 0) {
        _push(`<!--[-->`);
        ssrRenderList(_ctx.product.price_model, (pm, index) => {
          _push(`<span class="badge bg-success">${ssrInterpolate(pm.name)}</span>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.sentence.single_price"))}</span>`);
      }
      _push(`</td><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.word.comission"))}: <span class="badge-simple bg-dark fs-7 fw-bold">${ssrInterpolate(_ctx.product.commission)} <i class="ri-percent-fill fs-10"></i></span></td><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.total_inventory"))}: ${ssrInterpolate(_ctx.inventories.main.length + _ctx.inventories.stores.length)}</td></tr></tbody></table><a${ssrRenderAttrs(mergeProps({
        class: "btn btn-light btn-square btn-xs lts-05 text-dark me-2",
        href: _ctx.route("main.products.show", _ctx.product.slug),
        target: "_blank"
      }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.sentence.show_product_in_site"), void 0, { top: true })))}><i class="ri-eye-fill"></i></a></div><div class="col-12 dynamic-container mt-2"><ul class="nav nav-tabs nav-pager mb-3" id="inventoriesTab" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link active" id="main-tab" data-bs-toggle="tab" data-bs-target="#main-tab-pane" type="button" role="tab" aria-controls="main-tab-pane" aria-selected="true">${ssrInterpolate(_ctx.$t("messages.sentence.your_store"))}</button></li><li class="nav-item" role="presentation"><button class="nav-link" id="stores-tab" data-bs-toggle="tab" data-bs-target="#stores-tab-pane" type="button" role="tab" aria-controls="stores-tab-pane" aria-selected="false">${ssrInterpolate(_ctx.$t("messages.sentence.other_sellers"))}</button></li></ul><div class="tab-content" id="inventoriesTabContent"><div class="tab-pane fade show active" id="main-tab-pane" role="tabpanel" aria-labelledby="main-tab" tabindex="0"><div class="price-items"><!--[-->`);
      ssrRenderList(_ctx.inventories.main, (inventory, index) => {
        _push(`<div class="price-item pt-3 mb-4"><div class="row"><div class="col-12 store-details mb-3"><div class="d-flex align-items-center justify-content-between flex-column flex-sm-row pb-3 border-bottom"><div class="store-right d-flex align-items-center">`);
        if (inventory.store_id == null) {
          _push(`<div class="seller-avatar shadow-1">`);
          if (_ctx.$page.props.appFavicon != null) {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appFavicon)}${ssrRenderAttr("alt", _ctx.$page.props.appName)}>`);
          } else {
            _push(`<i class="ri-store-2-line"></i>`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="seller-avatar shadow-1"><img${ssrRenderAttr("src", inventory.store.get_logo)}${ssrRenderAttr("alt", inventory.store.name)}></div>`);
        }
        _push(`<div class="ms-3">`);
        if (inventory.store_id == null) {
          _push(`<div class="seller-username">`);
          if (_ctx.$page.props.appName != null) {
            _push(`<span>${ssrInterpolate(_ctx.$page.props.appName)}</span>`);
          } else {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span>`);
          }
          _push(`<i class="ri-verified-badge-fill"></i></div>`);
        } else {
          _push(`<div class="seller-username"><a${ssrRenderAttr("href", _ctx.route("main.stores.show", inventory.store.uuid))} target="_blank" class="link text-dark">${ssrInterpolate(inventory.store.name)}</a><i class="ri-verified-badge-fill"></i></div>`);
        }
        if (inventory.store_id != null) {
          _push(`<div class="registrations-date lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.price_status"))}: `);
          if (inventory.status == "publish") {
            _push(`<span class="text-success fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.verified"))}</span>`);
          } else if (inventory.status == "awaiting") {
            _push(`<span class="text-info fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
          } else if (inventory.status == "deactive") {
            _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</span>`);
          } else if (inventory.status == "rejected") {
            _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="registrations-date lts-05 mb-2"><span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span></div>`);
        }
        _push(`</div></div><div class="d-flex mt-sm-0 mt-3">`);
        if (inventory.status == "publish" || inventory.status == "awaiting") {
          _push(ssrRenderComponent(unref(Link), mergeProps({
            href: _ctx.route("seller.inventories.edit", { inventory: inventory.id, uuid: _ctx.product.uuid }),
            as: "button",
            class: "btn btn-square btn-sm btn-white shadow-1"
          }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.edit"), void 0, { top: true })), {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="ri-pencil-line"${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "ri-pencil-line" })
                ];
              }
            }),
            _: 2
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<button${ssrRenderAttrs(mergeProps({
          class: "btn btn-square btn-sm btn-white shadow-1 ms-2",
          "data-bs-toggle": "modal",
          "data-bs-target": "#remove-price-" + inventory.id
        }, ssrGetDirectiveProps(_ctx, _directive_tooltip, _ctx.$t("messages.word.delete"), void 0, { top: true })))}><i class="ri-delete-bin-line"></i></button></div><div class="modal fade"${ssrRenderAttr("id", "remove-price-" + inventory.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_inventory"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("seller.inventories.destroy", inventory.id),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div></div></div><div class="col-12 mb-3"><span class="fs-8 text-gray">${ssrInterpolate(_ctx.$t("messages.word.uuid"))}: <span class="fs-7 text-dark">${ssrInterpolate(inventory.uuid)}</span></span></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.word.storage"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.storage)}</div></label></div><!--[-->`);
        ssrRenderList(inventory.props, (inp) => {
          _push(`<!--[-->`);
          if (inp.type == "color") {
            _push(`<div class="choose-widget col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold lts-05">${ssrInterpolate(inp.name)} <div class="form-control same-as-input"><span class="dropdown-color-item shadow-1" style="${ssrRenderStyle({
              "background-color": inp.value["color"],
              border: inp.value["color"].includes("#ffffff") ? "solid 1px #dddddd" : ""
            })}"></span>${ssrInterpolate(inp.value["label"])}</div></label></div>`);
          } else {
            _push(`<div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(inp.name)} <div class="form-control same-as-input">${ssrInterpolate(inp.value)}</div></label></div>`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_price"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><div class="form-control same-as-input">${ssrInterpolate(inventory.get_formatted_price)}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.discount_price"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><div class="form-control same-as-input">${ssrInterpolate(inventory.discount_price != null ? inventory.get_formatted_discount_price : _ctx.$t("messages.word.not_applied"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.discount_expire"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.jalali_discount_expire != null ? inventory.jalali_discount_expire[1] : _ctx.$t("messages.word.not_applied"))} `);
        if (inventory.jalali_discount_expire != null && !inventory.is_discount_valid) {
          _push(`<span class="badge bg-danger ms-2">${ssrInterpolate(_ctx.$t("messages.word.expired"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_count"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.count)} `);
        if (inventory.count == 0) {
          _push(`<span class="badge bg-danger ms-2">${ssrInterpolate(_ctx.$t("messages.word.outofstock"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.min_sale"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.min_sale)}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.max_sale"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.max_sale != null ? inventory.max_sale : _ctx.$t("messages.word.infinity"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_weight"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.weight != null ? unref(useNumberFormat)(inventory.weight) + " " + _ctx.$t("messages.word.gram") : _ctx.$t("messages.word.not_applied"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.send_time"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.send_time != null && inventory.send_time != "" ? inventory.send_time : _ctx.$t("messages.sentence.ready_to_send"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.purchase_price"))} <span class="currency mb-0">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><div class="form-control same-as-input">${ssrInterpolate(inventory.purchase_price != null && inventory.purchase_price > 0 ? unref(useNumberFormat)(inventory.purchase_price) : _ctx.$t("messages.word.empty"))}</div><span class="input-desc fw-normal">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_5487123"))}</span></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_original_type"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.original ? _ctx.$t("messages.sentence.original_product") : _ctx.$t("messages.sentence.unoriginal_product"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_used_type"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.used ? _ctx.$t("messages.sentence.used_product") : _ctx.$t("messages.sentence.unused_product"))}</div></label></div>`);
        if (inventory.description) {
          _push(`<div class="col-12 mb-4"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.word.description"))} <div class="form-control same-as-input lh-30 lts-05">${unref(useNl2br)(inventory.description) ?? ""}</div></label><span class="input-desc fw-normal">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_5487123"))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (inventory.get_image.id != null && inventory.get_image.url != null) {
          _push(`<div class="col-12 mb-4"><label class="form-label lts-05 mb-3 fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_image"))}</label><div class="image-grid"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + inventory.get_image.url + ")")}"></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (inventory.get_discount_tree.length > 0) {
          _push(`<div class="col-12 mb-4 count-discount-container mb-3"><div class="count-discount"><div class="tab-title mb-3"><div><div class="d-flex align-items-center mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.tiered_discount_according_to_quantity"))} <span class="ms-1 text-info">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></div><span>${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_399852"))}</span></div></div><div class="sub sub-same-as-input"><!--[-->`);
          ssrRenderList(inventory.get_discount_tree, (dt, dti) => {
            _push(`<div class="row mb-1"><div class="col-sm-6 col-12 p-0 mb-1 mb-md-0"><div class="form-control same-as-input">${ssrInterpolate(dt.count)}</div></div><div class="col-sm-6 col-12 p-0 ps-md-2"><div class="form-control same-as-input">${ssrInterpolate(dt.price)} <span class="ms-1 currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div></div></div>`);
          });
          _push(`<!--]--></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.inventories.main.length == 0) {
        _push(`<div class="product-list-empty mt-5"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="tab-pane fade" id="stores-tab-pane" role="tabpanel" aria-labelledby="stores-tab" tabindex="0"><div class="price-items"><!--[-->`);
      ssrRenderList(_ctx.inventories.stores, (inventory, index) => {
        _push(`<div class="price-item pt-3 mb-4"><div class="row"><div class="col-12 store-details mb-3"><div class="d-flex align-items-center justify-content-between flex-column flex-sm-row pb-3 border-bottom"><div class="store-right d-flex align-items-center">`);
        if (inventory.store_id == null) {
          _push(`<div class="seller-avatar shadow-1">`);
          if (_ctx.$page.props.appFavicon != null) {
            _push(`<img${ssrRenderAttr("src", _ctx.$page.props.appFavicon)}${ssrRenderAttr("alt", _ctx.$page.props.appName)}>`);
          } else {
            _push(`<i class="ri-store-2-line"></i>`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="seller-avatar shadow-1"><img${ssrRenderAttr("src", inventory.store.get_logo)}${ssrRenderAttr("alt", inventory.store.name)}></div>`);
        }
        _push(`<div class="ms-3">`);
        if (inventory.store_id == null) {
          _push(`<div class="seller-username">`);
          if (_ctx.$page.props.appName != null) {
            _push(`<span>${ssrInterpolate(_ctx.$page.props.appName)}</span>`);
          } else {
            _push(`<span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span>`);
          }
          _push(`<i class="ri-verified-badge-fill"></i></div>`);
        } else {
          _push(`<div class="seller-username"><a${ssrRenderAttr("href", _ctx.route("main.stores.show", inventory.store.uuid))} target="_blank" class="link text-dark">${ssrInterpolate(inventory.store.name)}</a><i class="ri-verified-badge-fill"></i></div>`);
        }
        if (inventory.store_id != null) {
          _push(`<div class="registrations-date lts-05 mb-2">${ssrInterpolate(_ctx.$t("messages.sentence.price_status"))}: `);
          if (inventory.status == "publish") {
            _push(`<span class="text-success fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.verified"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (inventory.status == "awaiting") {
            _push(`<span class="text-info fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
          } else if (inventory.status == "deactive") {
            _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.deactive"))}</span>`);
          } else if (inventory.status == "rejected") {
            _push(`<span class="text-danger fw-bold">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="registrations-date lts-05 mb-2"><span>${ssrInterpolate(_ctx.$t("messages.sentence.main_shop"))}</span></div>`);
        }
        _push(`</div></div></div></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.word.storage"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.storage)}</div></label></div><!--[-->`);
        ssrRenderList(inventory.props, (inp) => {
          _push(`<!--[-->`);
          if (inp.type == "color") {
            _push(`<div class="choose-widget col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold lts-05">${ssrInterpolate(inp.name)} <div class="form-control same-as-input"><span class="dropdown-color-item shadow-1" style="${ssrRenderStyle({
              "background-color": inp.value["color"],
              border: inp.value["color"].includes("#ffffff") ? "solid 1px #dddddd" : ""
            })}"></span>${ssrInterpolate(inp.value["label"])}</div></label></div>`);
          } else {
            _push(`<div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(inp.name)} <div class="form-control same-as-input">${ssrInterpolate(inp.value)}</div></label></div>`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_price"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><div class="form-control same-as-input">${ssrInterpolate(inventory.get_formatted_price)}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.discount_price"))} <span class="currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><div class="form-control same-as-input">${ssrInterpolate(inventory.discount_price != null ? inventory.get_formatted_discount_price : _ctx.$t("messages.word.not_applied"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.discount_expire"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.jalali_discount_expire != null ? inventory.jalali_discount_expire[1] : _ctx.$t("messages.word.not_applied"))} `);
        if (inventory.jalali_discount_expire != null && !inventory.is_discount_valid) {
          _push(`<span class="badge bg-danger ms-2">${ssrInterpolate(_ctx.$t("messages.word.expired"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_count"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.count)} `);
        if (inventory.count == 0) {
          _push(`<span class="badge bg-danger ms-2">${ssrInterpolate(_ctx.$t("messages.word.outofstock"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.min_sale"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.min_sale)}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.max_sale"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.max_sale != null ? inventory.max_sale : _ctx.$t("messages.word.infinity"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_weight"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.weight != null ? unref(useNumberFormat)(inventory.weight) + " " + _ctx.$t("messages.word.gram") : _ctx.$t("messages.word.not_applied"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.send_time"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.send_time != null && inventory.send_time != "" ? inventory.send_time : _ctx.$t("messages.sentence.ready_to_send"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_original_type"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.original ? _ctx.$t("messages.sentence.original_product") : _ctx.$t("messages.sentence.unoriginal_product"))}</div></label></div><div class="col-md-4 col-sm-6 col-12 mb-3"><label class="form-label fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.product_used_type"))} <div class="form-control same-as-input">${ssrInterpolate(inventory.used ? _ctx.$t("messages.sentence.used_product") : _ctx.$t("messages.sentence.unused_product"))}</div></label></div>`);
        if (inventory.get_image.id != null && inventory.get_image.url != null) {
          _push(`<div class="col-12 mb-4"><label class="form-label lts-05 mb-3 fw-bold">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_image"))}</label><div class="image-grid"><div class="image-grid--level-one"><div class="image-grid--level-two"><div class="image" style="${ssrRenderStyle("background-image: url(" + inventory.get_image.url + ")")}"></div></div></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (inventory.get_discount_tree.length > 0) {
          _push(`<div class="col-12 mb-4 count-discount-container mb-3"><div class="count-discount"><div class="tab-title mb-3"><div><div class="d-flex align-items-center mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.tiered_discount_according_to_quantity"))} <span class="ms-1 text-info">(${ssrInterpolate(_ctx.$t("messages.word.optional"))})</span></div><span>${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_399852"))}</span></div></div><div class="sub sub-same-as-input"><!--[-->`);
          ssrRenderList(inventory.get_discount_tree, (dt, dti) => {
            _push(`<div class="row mb-1"><div class="col-sm-6 col-12 p-0 mb-1 mb-md-0"><div class="form-control same-as-input">${ssrInterpolate(dt.count)}</div></div><div class="col-sm-6 col-12 p-0 ps-md-2"><div class="form-control same-as-input">${ssrInterpolate(dt.price)} <span class="ms-1 currency">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div></div></div>`);
          });
          _push(`<!--]--></div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div>`);
      if (_ctx.inventories.stores.length == 0) {
        _push(`<div class="product-list-empty mt-5"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Store/Storage/Inventory/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
