import { defineComponent, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { useForm, Head, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$6 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$4 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$5 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import Dropdown from "primevue/dropdown/dropdown.esm.js";
import { _ as _sfc_main$3 } from "./NumInput-Bt6uFGO4.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    stores: {},
    keyword: {},
    sellerTypeList: {}
  },
  setup(__props) {
    const addSellerForm = useForm({
      phone: null,
      user_name: null,
      type: "genuine",
      name: null,
      store_name: null
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.store_list")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.stores")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><div class="action-container mb-4 d-flex align-items-center justify-content-end"><button type="button" class="btn btn-light lts-05 me-2" data-bs-toggle="modal" data-bs-target="#add-seller">${ssrInterpolate(_ctx.$t("messages.sentence.add_seller"))}</button></div><div class="modal fade add-seller" id="add-seller" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lg modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.add_seller"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-lg-6 col-12 mb-4"><label for="eaStoreName" class="form-label required">${ssrInterpolate(_ctx.$t("messages.word.phone"))}</label>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        modelValue: unref(addSellerForm).phone,
        "onUpdate:modelValue": ($event) => unref(addSellerForm).phone = $event,
        name: "phone",
        minlength: "11",
        maxlength: "11",
        autocomplete: "phone",
        type: "tel",
        inputmode: "numeric",
        placeholder: _ctx.$t("messages.word.phone"),
        required: "",
        class: "form-control",
        id: "eaStoreName"
      }, null, _parent));
      _push(`<span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_220015"))}</span></div><div class="col-lg-6 col-12 mb-4"><label for="eaStoreName" class="form-label">${ssrInterpolate(_ctx.$t("messages.word.fullname"))}</label><input${ssrRenderAttr("value", unref(addSellerForm).user_name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.word.fullname"))} class="form-control" id="eaStoreName"></div><div class="col-lg-6 col-12 mb-4"><label for="eaProductStatus" class="form-label required lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.seller_type"))}: </label>`);
      _push(ssrRenderComponent(unref(Dropdown), {
        class: "pvc-dropdown",
        modelValue: unref(addSellerForm).type,
        "onUpdate:modelValue": ($event) => unref(addSellerForm).type = $event,
        options: _ctx.sellerTypeList,
        display: "chip",
        optionLabel: "label",
        optionValue: "id",
        placeholder: _ctx.$t("messages.sentence.select_status")
      }, null, _parent));
      _push(`</div><div class="col-lg-6 col-12 mb-4"><label for="eaStoreName" class="form-label required">${ssrInterpolate(_ctx.$t("messages.sentence.store_title"))}</label><input${ssrRenderAttr("value", unref(addSellerForm).store_name)} type="text"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.msg_id_985532") + " ...")} required class="form-control" id="eaStoreName"><span class="form-control-description">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_478552"))}</span></div><div class="col-12 mb-3 mt-3"><div class="border"></div></div><div class="col-12 mb-3"><p class="lts-05 lh-30 mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_500148"))}</p></div><div class="col-12"><div class="border"></div></div></div></div><div class="modal-footer"><button class="btn btn-sm btn-primary px-3">${ssrInterpolate(_ctx.$t("messages.word.add"))}</button></div></form></div></div></div>`);
      _push(ssrRenderComponent(_sfc_main$4, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.store_title") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$5, {
        filters: { active: _ctx.$t("messages.word.active"), banned: _ctx.$t("messages.word.banned"), awaiting: _ctx.$t("messages.sentence.awaiting_verify"), reject: _ctx.$t("messages.word.rejected") }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.logo"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.store_title"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.user"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.code"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.inventory"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.status"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.register_date"))}</th><th class="first-small"><i class="ri-settings-4-line"></i></th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.stores.data, (store) => {
        _push(`<tr><td><img width="35" height="35" class="br-10 border-gray-2 shadow-1"${ssrRenderAttr("src", store.get_logo)}${ssrRenderAttr("alt", store.name)}></td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          target: "_blank",
          href: _ctx.route("admin.stores.show", store.uuid)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(store.name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(store.name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "link",
          href: _ctx.route("admin.users.show", store.user.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(store.user.get_name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(store.user.get_name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</td><td>${ssrInterpolate(store.uuid)}</td><td>${ssrInterpolate(store.user.wallet.get_formatted_amount)} <span class="text-badge">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td><td>${ssrInterpolate(store.get_formatted_view_count)}</td><td>`);
        if (store.status == "active") {
          _push(`<span class="badge bg-success">${ssrInterpolate(_ctx.$t("messages.word.active"))}</span>`);
        } else if (store.status == "banned") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.banned"))}</span>`);
        } else if (store.status == "awaiting") {
          _push(`<span class="badge bg-info">${ssrInterpolate(_ctx.$t("messages.sentence.awaiting_verify"))}</span>`);
        } else if (store.status == "reject") {
          _push(`<span class="badge bg-danger">${ssrInterpolate(_ctx.$t("messages.word.rejected"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td>${ssrInterpolate(store.jalali_created_at[0])}</td><td class="dropdown"><i class="ri-more-2-fill" data-bs-toggle="dropdown"></i><div class="dropdown-menu shadow-smooth-2"><ul><li>`);
        _push(ssrRenderComponent(unref(Link), {
          class: "dropdown-item lts-05",
          href: _ctx.route("admin.stores.show", store.uuid)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-pencil-line"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("messages.sentence.show_and_edit"))}`);
            } else {
              return [
                createVNode("i", { class: "ri-pencil-line" }),
                createTextVNode(" " + toDisplayString(_ctx.$t("messages.sentence.show_and_edit")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
        if (store.status == "active") {
          _push(`<li><a target="_blank" class="dropdown-item lts-05"${ssrRenderAttr("href", _ctx.route("main.stores.show", store.uuid))}><i class="ri-eye-line"></i><span>${ssrInterpolate(_ctx.$t("messages.sentence.show_in_site"))}</span></a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul></div></td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.stores.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$6, {
        links: _ctx.stores.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Stores/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
