import { defineComponent, onMounted, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { router, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$5 } from "./Pagination-C1AQrLe3.js";
import { _ as _sfc_main$3 } from "./SearchList-BZnYMQPN.js";
import { _ as _sfc_main$4 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "lodash/debounce.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./useRandomNum-DNNSqR7b.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    reports: {},
    keyword: {}
  },
  setup(__props) {
    onMounted(() => {
      $(document).on("click", ".link-to-target", (e) => {
        let targetType = $(e.target).attr("target");
        let parameter = $(e.target).attr("parameter");
        if (targetType == "user") {
          router.visit(route("admin.users.show", parameter), {
            replace: false
          });
        } else if (targetType == "brand") {
          window.open(route("main.brands.show", parameter), "_blank");
        } else if (targetType == "category") {
          window.open(route("main.products.index", { cat: parameter }), "_blank");
        } else if (targetType == "article_category") {
          window.open(route("blog.articles.index", { cat: parameter }), "_blank");
        } else if (targetType == "tag") {
          window.open(route("main.products.index", { tag: parameter }), "_blank");
        } else if (targetType == "article_tag") {
          window.open(route("blog.articles.index", { tag: parameter }), "_blank");
        } else if (targetType == "product") {
          window.open(route("main.products.show", parameter), "_blank");
        } else if (targetType == "page") {
          window.open(route("main.pages.show", parameter), "_blank");
        } else if (targetType == "form") {
          window.open(route("main.forms.show", parameter), "_blank");
        } else if (targetType == "article") {
          window.open(route("blog.articles.show", parameter), "_blank");
        } else if (targetType == "ticket") {
          router.visit(route("admin.tickets.show", parameter), {
            replace: false
          });
        } else if (targetType == "store") {
          router.visit(route("admin.stores.show", parameter), {
            replace: false
          });
        }
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.reports_history")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.word.reports")
      }, null, _parent));
      _push(`<div class="user-list list mb-4"><div class="card"><div class="card-body"><span class="d-inline-flex alert alert-light lts-05 fs-8 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_529936"))}</span>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        keyword: _ctx.keyword,
        placeholder: _ctx.$t("messages.sentence.phone_or_username_full") + " ..."
      }, null, _parent));
      _push(ssrRenderComponent(_sfc_main$4, {
        filters: { owner: _ctx.$t("messages.word.owner"), admin: _ctx.$t("messages.word.admin"), seller: _ctx.$t("messages.word.seller"), user: _ctx.$t("messages.word.user") }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th>${ssrInterpolate(_ctx.$t("messages.word.report"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.date"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.reports.data, (report) => {
        _push(`<tr><td>${report.full_content ?? ""}</td><td>${ssrInterpolate(report.jalali_created_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.reports.data.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_sfc_main$5, {
        links: _ctx.reports.links
      }, null, _parent));
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Reports/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
