import { defineComponent, ref, onMounted, unref, withCtx, createVNode, resolveDynamicComponent, createTextVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttr, ssrRenderVNode, ssrInterpolate, ssrRenderStyle, ssrRenderClass, ssrRenderList, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { useForm, router, usePage, Head, Link } from "@inertiajs/vue3";
import * as noUiSlider from "nouislider";
import wNumb from "wnumb";
/* empty css                        */
import { _ as _sfc_main$2 } from "./FilterList-CWxGcEKk.js";
import { _ as _sfc_main$3 } from "./Pagination-C1AQrLe3.js";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
import "jquery";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    products: {},
    filters: {},
    keywords: {},
    seo: {}
  },
  setup(__props) {
    const props = __props;
    const pfStatus = ref(false);
    const search = ref(props.keywords.search.query);
    useForm({
      search: search.value
    });
    const minPrice = ref(props.keywords.price.min != null ? props.keywords.price.min : props.filters.price.min);
    const maxPrice = ref(props.keywords.price.max != null ? props.keywords.price.max : props.filters.price.max);
    const minRangePrice = ref(props.filters.price.min);
    const maxRangePrice = ref(props.filters.price.max);
    onMounted(() => {
      if ($(".filter-price").length) {
        let skipSlider = document.getElementById("slider-price-linear");
        let sliderFrom = document.querySelector(".slider-range-from");
        let sliderTo = document.querySelector(".slider-range-to");
        let min = parseInt(sliderFrom.dataset.range), max = parseInt(sliderTo.dataset.range);
        noUiSlider.create(skipSlider, {
          start: [sliderFrom.value, sliderTo.value],
          connect: true,
          direction: "rtl",
          format: wNumb({
            thousand: ",",
            decimals: 0
          }),
          step: 1,
          range: {
            min,
            max
          }
        });
        let skipValues = [document.getElementById("skip-value-lower"), document.getElementById("skip-value-upper")];
        skipSlider.noUiSlider.on("update", function(values, handle) {
          skipValues[handle].value = values[handle];
        });
        skipSlider.noUiSlider.on("change", function(values, handle) {
          let params = { ...$queryStrings().search, price: values[0].replaceAll(",", "") + "-" + values[1].replaceAll(",", "") };
          if (values[0] == null || values[1] == null) {
            delete params["price"];
          }
          router.get(route(usePage().props.currentRouteName), params, { replace: true });
        });
      }
    });
    const $queryStrings = (...args) => {
      let queryString = usePage().url;
      if (queryString.indexOf("?") === -1) {
        return {};
      }
      queryString = queryString.substring(queryString.indexOf("?") + 1);
      let object = Object.fromEntries(new URLSearchParams(queryString));
      for (let qs in object) {
        if (qs == "search" || qs == "cat" || qs == "tag" || qs == "profile" || qs == "random" || qs == "color" || qs == "brand" || qs == "price") {
          continue;
        }
        delete object[qs];
      }
      return {
        search: Object.assign(object, ...args),
        all: Object.fromEntries(new URLSearchParams(queryString))
      };
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="canonical"${ssrRenderAttr("href", _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.description != null) {
              _push2(`<meta name="description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.keywords != null) {
              _push2(`<meta name="keywords"${ssrRenderAttr("content", _ctx.seo.keywords)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.author != null) {
              _push2(`<meta name="author"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta property="og:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta property="og:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:url"${ssrRenderAttr("content", _ctx.$page.props.currentUrl)}${_scopeId}>`);
            if (_ctx.seo.image != null) {
              _push2(`<meta property="og:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.type != null) {
              _push2(`<meta property="og:type"${ssrRenderAttr("content", _ctx.seo.type)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<meta property="og:site_name"${ssrRenderAttr("content", _ctx.seo.site_name)}${_scopeId}><meta property="og:locale" content="fa_IR"${_scopeId}><meta name="twitter:card" content="summary_large_image"${_scopeId}><meta name="twitter:site"${ssrRenderAttr("content", _ctx.$page.props.appUrl)}${_scopeId}>`);
            if (_ctx.seo.author != null) {
              _push2(`<meta name="twitter:creator"${ssrRenderAttr("content", _ctx.seo.author)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.title != null) {
              _push2(`<meta name="twitter:title"${ssrRenderAttr("content", _ctx.seo.title)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.description != null) {
              _push2(`<meta name="twitter:description"${ssrRenderAttr("content", _ctx.seo.description)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.seo.image != null) {
              _push2(`<meta name="twitter:image"${ssrRenderAttr("content", _ctx.seo.image)}${_scopeId}>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.products && _ctx.products.data && _ctx.products.data.length > 0) {
              _push2(`<meta name="robots" content="index, follow"${_scopeId}>`);
            } else {
              _push2(`<meta name="robots" content="noindex, follow"${_scopeId}>`);
            }
            if (_ctx.seo.schema != null) {
              ssrRenderVNode(_push2, createVNode(resolveDynamicComponent("script"), { type: "application/ld+json" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.seo.schema)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                    ];
                  }
                }),
                _: 1
              }), _parent2, _scopeId);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("link", {
                rel: "canonical",
                href: _ctx.seo.canonical != null && _ctx.seo.canonical != "" ? _ctx.seo.canonical : _ctx.$page.props.currentUrl
              }, null, 8, ["href"]),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 0,
                name: "description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.keywords != null ? (openBlock(), createBlock("meta", {
                key: 1,
                name: "keywords",
                content: _ctx.seo.keywords
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 2,
                name: "author",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 3,
                property: "og:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 4,
                property: "og:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:url",
                content: _ctx.$page.props.currentUrl
              }, null, 8, ["content"]),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 5,
                property: "og:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.type != null ? (openBlock(), createBlock("meta", {
                key: 6,
                property: "og:type",
                content: _ctx.seo.type
              }, null, 8, ["content"])) : createCommentVNode("", true),
              createVNode("meta", {
                property: "og:site_name",
                content: _ctx.seo.site_name
              }, null, 8, ["content"]),
              createVNode("meta", {
                property: "og:locale",
                content: "fa_IR"
              }),
              createVNode("meta", {
                name: "twitter:card",
                content: "summary_large_image"
              }),
              createVNode("meta", {
                name: "twitter:site",
                content: _ctx.$page.props.appUrl
              }, null, 8, ["content"]),
              _ctx.seo.author != null ? (openBlock(), createBlock("meta", {
                key: 7,
                name: "twitter:creator",
                content: _ctx.seo.author
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.title != null ? (openBlock(), createBlock("meta", {
                key: 8,
                name: "twitter:title",
                content: _ctx.seo.title
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.description != null ? (openBlock(), createBlock("meta", {
                key: 9,
                name: "twitter:description",
                content: _ctx.seo.description
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.seo.image != null ? (openBlock(), createBlock("meta", {
                key: 10,
                name: "twitter:image",
                content: _ctx.seo.image
              }, null, 8, ["content"])) : createCommentVNode("", true),
              _ctx.products && _ctx.products.data && _ctx.products.data.length > 0 ? (openBlock(), createBlock("meta", {
                key: 11,
                name: "robots",
                content: "index, follow"
              })) : (openBlock(), createBlock("meta", {
                key: 12,
                name: "robots",
                content: "noindex, follow"
              })),
              _ctx.seo.schema != null ? (openBlock(), createBlock(resolveDynamicComponent("script"), {
                key: 13,
                type: "application/ld+json"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.seo.schema), 1)
                ]),
                _: 1
              })) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<h1 class="d-none m-0">${ssrInterpolate(_ctx.seo.title + " - " + _ctx.$page.props.appName)}</h1><div class="container"><div style="${ssrRenderStyle(pfStatus.value ? null : { display: "none" })}" class="bg-black-cover"></div><div class="row mb-3"><div class="${ssrRenderClass(pfStatus.value ? "col-xl-3 col-lg-4 col-md-5 responsive-sidebar show" : "col-xl-3 col-lg-4 col-md-5 responsive-sidebar")}"><button style="${ssrRenderStyle(!pfStatus.value ? null : { display: "none" })}" class="btn btn-primary shadow-primary d-md-none toggle-responsive-sidebar"><i class="ri-equalizer-fill"></i></button><div class="archive-sidebar"><nav class="mb-3" aria-label="breadcrumb"><ol class="breadcrumb"><li class="breadcrumb-item">`);
      _push(ssrRenderComponent(unref(Link), {
        href: _ctx.route("index")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$page.props.appName)}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$page.props.appName), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li><li class="breadcrumb-item">${ssrInterpolate(_ctx.seo.title.replace(" - " + _ctx.$page.props.appName, ""))}</li></ol></nav>`);
      if (_ctx.$page.props.payment_meta.free_post_min_price > 0) {
        _push(`<div class="card shadow-1 mb-3"><div class="widget-send-free card-body"><div class="title"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_free_send"))}</div><span class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.orders_above_price", { price: _ctx.$page.props.payment_meta.get_formatted_free_post_min_price }))}</span></div><i class="ri-truck-line"></i></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="card shadow-1 mb-3"><div class="widget-search card-body"><div class="d-flex align-items-center justify-content-between title lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.search_in_result"))} `);
      if (_ctx.keywords.search.query != null) {
        _push(`<span class="left-side-text text-danger lts-05 fs-9 fw-normal clickable">${ssrInterpolate(_ctx.$t("messages.sentence.delete_filter"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><form><input${ssrRenderAttr("value", search.value)} class="form-control search-field shadow-1 lts-05" type="text" name="keyword"${ssrRenderAttr("placeholder", _ctx.$t("messages.sentence.search_keyword") + " ...")}><button class="btn" type="submit"><i class="ri-search-2-line"></i></button></form></div></div><div class="card shadow-1 mb-3"><div class="widget-brands widget-dropdown-list card-body"><div class="${ssrRenderClass({ title: true, collapsed: _ctx.keywords.brand.query == null })}" data-bs-toggle="collapse" data-bs-target="#collapseBrandFilter" aria-expanded="false" aria-controls="collapseBrandFilter" role="button">${ssrInterpolate(_ctx.$t("messages.word.brands"))} `);
      if (_ctx.keywords.brand.query != null) {
        _push(`<span class="left-side-text text-danger lts-05 fs-9 fw-normal clickable">${ssrInterpolate(_ctx.$t("messages.sentence.delete_filter"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass({ content: true, collapse: true, show: _ctx.keywords.brand.query != null })}" id="collapseBrandFilter"><div class="filter-options simplebar-container border-top pt-2 mt-2"><!--[-->`);
      ssrRenderList(_ctx.filters.brands, (brand) => {
        _push(`<div class="form-check">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { ...$queryStrings().search, brand: brand.slug }),
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<input${ssrIncludeBooleanAttr(_ctx.keywords.brand.query == brand.slug) ? " checked" : ""} class="form-check-input" type="checkbox"${ssrRenderAttr("id", "brand-" + brand.id)}${_scopeId}><label class="form-check-label d-block"${ssrRenderAttr("for", "brand-" + brand.id)}${_scopeId}><span class="d-flex align-items-center justify-content-between"${_scopeId}><span${_scopeId}>${ssrInterpolate(brand.title)}</span><span class="text-muted en_text fs-7"${_scopeId}>${ssrInterpolate(brand.title_en)}</span></span></label>`);
            } else {
              return [
                createVNode("input", {
                  checked: _ctx.keywords.brand.query == brand.slug,
                  class: "form-check-input",
                  type: "checkbox",
                  id: "brand-" + brand.id
                }, null, 8, ["checked", "id"]),
                createVNode("label", {
                  class: "form-check-label d-block",
                  for: "brand-" + brand.id
                }, [
                  createVNode("span", { class: "d-flex align-items-center justify-content-between" }, [
                    createVNode("span", null, toDisplayString(brand.title), 1),
                    createVNode("span", { class: "text-muted en_text fs-7" }, toDisplayString(brand.title_en), 1)
                  ])
                ], 8, ["for"])
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div>`);
      });
      _push(`<!--]--></div></div></div></div><div class="card shadow-1 mb-3"><div class="widget-colors widget-dropdown-list card-body"><div class="${ssrRenderClass({ title: true, collapsed: _ctx.keywords.color.query == null })}" data-bs-toggle="collapse" data-bs-target="#collapseColorFilter" aria-expanded="false" aria-controls="collapseColorFilter" role="button">${ssrInterpolate(_ctx.$t("messages.sentence.select_color"))} `);
      if (_ctx.keywords.color.query != null) {
        _push(`<span class="left-side-text text-danger lts-05 fs-9 fw-normal clickable">${ssrInterpolate(_ctx.$t("messages.sentence.delete_filter"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass({ content: true, collapse: true, show: _ctx.keywords.color.query != null })}" id="collapseColorFilter"><div class="filter-options simplebar-container border-top pt-2 mt-2"><!--[-->`);
      ssrRenderList(_ctx.filters.colors, (color) => {
        _push(`<div class="form-check">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { ...$queryStrings().search, color: color.color }),
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<input${ssrIncludeBooleanAttr(_ctx.keywords.color.query == color.color) ? " checked" : ""} class="form-check-input" type="checkbox"${ssrRenderAttr("id", "color-" + color.id)}${_scopeId}><label class="form-check-label d-block"${ssrRenderAttr("for", "color-" + color.id)}${_scopeId}><span class="d-flex align-items-center justify-content-between"${_scopeId}><span${_scopeId}>${ssrInterpolate(color.label)}</span><span class="color-preview shadow-1" style="${ssrRenderStyle({ "background-color": color.color, border: color.color == "#ffffff" ? "solid 1px #ddd" : "" })}"${_scopeId}></span></span></label>`);
            } else {
              return [
                createVNode("input", {
                  checked: _ctx.keywords.color.query == color.color,
                  class: "form-check-input",
                  type: "checkbox",
                  id: "color-" + color.id
                }, null, 8, ["checked", "id"]),
                createVNode("label", {
                  class: "form-check-label d-block",
                  for: "color-" + color.id
                }, [
                  createVNode("span", { class: "d-flex align-items-center justify-content-between" }, [
                    createVNode("span", null, toDisplayString(color.label), 1),
                    createVNode("span", {
                      class: "color-preview shadow-1",
                      style: { "background-color": color.color, border: color.color == "#ffffff" ? "solid 1px #ddd" : "" }
                    }, null, 4)
                  ])
                ], 8, ["for"])
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div>`);
      });
      _push(`<!--]--></div></div></div></div><div class="card shadow-1 mb-3"><div class="widget-brands widget-dropdown-list card-body"><div class="${ssrRenderClass({ title: true, collapsed: _ctx.keywords.tag.query == null })}" data-bs-toggle="collapse" data-bs-target="#collapseTagsFilter" aria-expanded="false" aria-controls="collapseTagsFilter" role="button">${ssrInterpolate(_ctx.$t("messages.word.tags"))} `);
      if (_ctx.keywords.tag.query != null) {
        _push(`<span class="left-side-text text-danger lts-05 fs-9 fw-normal clickable">${ssrInterpolate(_ctx.$t("messages.sentence.delete_filter"))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="${ssrRenderClass({ content: true, collapse: true, show: _ctx.keywords.tag.query != null })}" id="collapseTagsFilter"><div class="filter-options simplebar-container border-top pt-3 mt-2"><!--[-->`);
      ssrRenderList(_ctx.filters.tags, (tag) => {
        _push(`<div class="form-check">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { ...$queryStrings().search, tag: tag.slug }),
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<input${ssrIncludeBooleanAttr(_ctx.keywords.tag.query == tag.slug) ? " checked" : ""} class="form-check-input" type="checkbox"${ssrRenderAttr("id", "tag-" + tag.id)}${_scopeId}><label class="form-check-label d-block"${ssrRenderAttr("for", "tag-" + tag.id)}${_scopeId}><span class="d-flex align-items-center justify-content-between"${_scopeId}><span${_scopeId}>${ssrInterpolate(tag.title)}</span></span></label>`);
            } else {
              return [
                createVNode("input", {
                  checked: _ctx.keywords.tag.query == tag.slug,
                  class: "form-check-input",
                  type: "checkbox",
                  id: "tag-" + tag.id
                }, null, 8, ["checked", "id"]),
                createVNode("label", {
                  class: "form-check-label d-block",
                  for: "tag-" + tag.id
                }, [
                  createVNode("span", { class: "d-flex align-items-center justify-content-between" }, [
                    createVNode("span", null, toDisplayString(tag.title), 1)
                  ])
                ], 8, ["for"])
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div>`);
      });
      _push(`<!--]--></div></div></div></div>`);
      if (!(_ctx.filters.price.min == 0 && _ctx.filters.price.max == 0)) {
        _push(`<div class="card shadow-1 mb-3"><div class="widget-price card-body"><div class="d-flex align-items-center justify-content-between mb-3"><div class="title lts-05 mb-0">${ssrInterpolate(_ctx.$t("messages.sentence.price_range"))}</div>`);
        if (_ctx.keywords.price.min != null && _ctx.keywords.price.max != null) {
          _push(`<span class="text-danger lts-05 fs-9 clickable">${ssrInterpolate(_ctx.$t("messages.sentence.delete_filter"))}</span>`);
        } else {
          _push(`<span></span>`);
        }
        _push(`</div><div class="filter-price"><div class="filter-slider"><div id="slider-price-linear" class="price-slider"></div></div><ul class="filter-range"><li><input${ssrRenderAttr("value", minPrice.value)} type="text"${ssrRenderAttr("data-value", minPrice.value)}${ssrRenderAttr("data-range", minRangePrice.value)} class="form-control slider-range-from" id="skip-value-lower" disabled><span>${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></li><li class="label">${ssrInterpolate(_ctx.$t("messages.word.up_to"))}</li><li><input${ssrRenderAttr("value", maxPrice.value)} type="text"${ssrRenderAttr("data-value", maxPrice.value)}${ssrRenderAttr("data-range", maxRangePrice.value)} class="form-control slider-range-to" id="skip-value-upper" disabled><span>${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></li></ul></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="card shadow-1 mb-3"><div class="widget-check-item card-body">`);
      if (_ctx.keywords.discount == null) {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { ...$queryStrings().all, discount: true }),
          class: "form-check form-switch text-decoration-none",
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<label class="form-check-label flex-grow-1 title lts-05" for="justDicounted1"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.discounted_products_only"))}</label><input${ssrIncludeBooleanAttr(_ctx.keywords.discount != null) ? " checked" : ""} class="form-check-input clickable" type="checkbox" role="switch" id="justDicounted1"${_scopeId}>`);
            } else {
              return [
                createVNode("label", {
                  class: "form-check-label flex-grow-1 title lts-05",
                  for: "justDicounted1"
                }, toDisplayString(_ctx.$t("messages.sentence.discounted_products_only")), 1),
                createVNode("input", {
                  checked: _ctx.keywords.discount != null,
                  class: "form-check-input clickable",
                  type: "checkbox",
                  role: "switch",
                  id: "justDicounted1"
                }, null, 8, ["checked"])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<div class="form-check form-switch text-decoration-none"><label class="form-check-label flex-grow-1 title lts-05" for="justDicounted2">${ssrInterpolate(_ctx.$t("messages.sentence.discounted_products_only"))}</label><input${ssrIncludeBooleanAttr(_ctx.keywords.discount != null) ? " checked" : ""} class="form-check-input clickable" type="checkbox" role="switch" id="justDicounted2"></div>`);
      }
      _push(`</div></div><div class="card shadow-1 mb-3"><div class="widget-check-item card-body">`);
      if (_ctx.keywords.available == null) {
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index", { ...$queryStrings().all, available: true }),
          class: "form-check form-switch text-decoration-none",
          as: "button"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<label class="form-check-label flex-grow-1 title lts-05" for="justAvailable1"${_scopeId}>${ssrInterpolate(_ctx.$t("messages.sentence.available_products_only"))}</label><input${ssrIncludeBooleanAttr(_ctx.keywords.available != null) ? " checked" : ""} class="form-check-input clickable" type="checkbox" role="switch" id="justAvailable1"${_scopeId}>`);
            } else {
              return [
                createVNode("label", {
                  class: "form-check-label flex-grow-1 title lts-05",
                  for: "justAvailable1"
                }, toDisplayString(_ctx.$t("messages.sentence.available_products_only")), 1),
                createVNode("input", {
                  checked: _ctx.keywords.available != null,
                  class: "form-check-input clickable",
                  type: "checkbox",
                  role: "switch",
                  id: "justAvailable1"
                }, null, 8, ["checked"])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<div class="form-check form-switch text-decoration-none"><label class="form-check-label flex-grow-1 title lts-05" for="justAvailable2">${ssrInterpolate(_ctx.$t("messages.sentence.available_products_only"))}</label><input${ssrIncludeBooleanAttr(_ctx.keywords.available != null) ? " checked" : ""} class="form-check-input clickable" type="checkbox" role="switch" id="justAvailable2"></div>`);
      }
      _push(`</div></div></div></div><div class="col-xl-9 col-lg-8 col-md-7">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        filters: {
          most_viewed: _ctx.$t("messages.word.most_viewed"),
          popular: _ctx.$t("messages.word.popular"),
          most_sale: _ctx.$t("messages.word.most_sale"),
          expensive: _ctx.$t("messages.word.expensive"),
          cheapest: _ctx.$t("messages.word.cheapest")
        }
      }, null, _parent));
      if (((_b = (_a = _ctx.products) == null ? void 0 : _a.data) == null ? void 0 : _b.length) > 0) {
        _push(`<div class="archive-products"><div class="row shadow-1 mx-0"><!--[-->`);
        ssrRenderList(_ctx.products.data, (product) => {
          _push(`<div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12"><div class="card product"><div class="card-body">`);
          _push(ssrRenderComponent(unref(Link), {
            class: "product--link",
            href: _ctx.route("main.products.show", product.slug)
          }, null, _parent));
          _push(`<div class="top-section"><div class="product-thumbnail">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", product.slug)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])} loading="lazy"${_scopeId}>`);
              } else {
                return [
                  createVNode("img", {
                    src: product.get_images[0]["link"],
                    alt: product.get_images[0]["alt"],
                    loading: "lazy"
                  }, null, 8, ["src", "alt"])
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`<ul class="product-colors"><!--[-->`);
          ssrRenderList(Array.isArray(product.unique_color) ? product.unique_color.slice(0, 8) : Object.values(product.unique_color || {}).slice(0, 8), (color, index) => {
            _push(`<li style="${ssrRenderStyle("background-color:" + color.value.color)}" data-bs-toggle="tooltip" data-bs-placement="top"${ssrRenderAttr("title", color.value.label)} class="${ssrRenderClass({ "color-is-white": color.value.color === "#ffffff" })}"></li>`);
          });
          _push(`<!--]-->`);
          if ((Array.isArray(product.unique_color) ? product.unique_color.length : Object.keys(product.unique_color || {}).length) > 8) {
            _push(`<li class="more-colors" title="مشاهده رنگ‌های بیشتر"> + </li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</ul></div><div class="product-body">`);
          if (product.is_vip) {
            _push(`<span class="vip-product-badge lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.vip_product"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<h2 class="product-title">`);
          _push(ssrRenderComponent(unref(Link), {
            href: _ctx.route("main.products.show", product.slug),
            class: "lts-05"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(product.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(product.title), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</h2></div></div><div class="product-footer d-flex justify-content-between"><div class="d-flex flex-row align-items-end"><span class="product-rating-average">${ssrInterpolate(product.comments_info.rating == "0" ? "-" : product.comments_info.rating)} <i class="ri-star-fill"></i></span></div>`);
          if (!product.in_stock_status) {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.inventory_inquiry"))}</span></div>`);
          } else if (product.inventory) {
            _push(`<!--[-->`);
            if (product.best_normal_price.discount_price != null) {
              _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-old lts-05">${ssrInterpolate(product.best_normal_price.price)}</span><span class="product-price-now lts-05">${ssrInterpolate(product.best_normal_price.discount_price)} <span class="unit unit-sm"></span></span></div>`);
            } else {
              _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now lts-05">${ssrInterpolate(product.best_normal_price.price)} <span class="unit unit-sm"></span></span></div>`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<div class="d-flex flex-column justify-content-end"><span class="product-price-now lts-05 fs-8">${ssrInterpolate(_ctx.$t("messages.word.non_existent"))}</span></div>`);
          }
          _push(`</div>`);
          if (product.best_normal_price.discount_price != null) {
            _push(`<div class="discount-percent bg-secondary shadow-secondary">${ssrInterpolate(product.best_normal_price.percent)} <i class="ri-percent-fill"></i></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.products.data.length == 0) {
        _push(`<div class="col-12 archive-empty-container"><div class="w-100 d-flex flex-column align-items-center p-5 br-20"><img width="200"${ssrRenderAttr("src", _ctx.$page.props.appUrl + "/img/template/products_empty.png")} class="mt-4 mb-4" loading="lazy"><p class="text-gray fw-bold text-center lts-05 fs-6 mb-1">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_products"))}</p><p class="text-light-gray fs-9 text-center lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_548125"))}</p><div class="d-flex align-items-center justify-content-center">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("main.products.index"),
          class: "link d-inline-block lts-05 fs-8 text-center color-secondary"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.product_archive"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.product_archive")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`<span class="circle-divider bg-light-gray"></span>`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("index"),
          class: "link d-inline-block lts-05 fs-8 text-center color-secondary"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.home_page"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.home_page")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.keywords.page != null || _ctx.products.data.length >= 28) {
        _push(`<div class="product-archive-pagination col-12 d-flex align-items-center justify-content-center mt-4">`);
        _push(ssrRenderComponent(_sfc_main$3, {
          links: _ctx.products.links,
          "preserve-scroll": false
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.keywords.cat.query && (((_c = _ctx.keywords.cat.content) == null ? void 0 : _c.length) || 0) > 20) {
        _push(`<div class="archive-category-content card mt-4"><div class="card-body p-4 pt-1 pb-1"><div class="main-content">${_ctx.keywords.cat.content ?? ""}</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Main/Products/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
