import { defineComponent, unref, withCtx, createTextVNode, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrRenderStyle } from "vue/server-renderer";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head, Link } from "@inertiajs/vue3";
import "toastify-js";
import "./useToastify-D_n0s7Uc.js";
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "simplebar";
import "resize-observer-polyfill";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "List",
  __ssrInlineRender: true,
  props: {
    categories: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.product_categories")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.product_categories")
      }, null, _parent));
      _push(`<div class="category-container row mb-4 mt-4"><div class="col-12 mb-4">`);
      if (_ctx.categories.length != 0) {
        _push(`<div class="mb-4"><div class="card-body"><div class="d-flex align-items-center justify-content-end">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.product.categories.add"),
          class: "btn btn-primary shadow-1 lts-05"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_main_category"))} <i class="ri-add-line"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_main_category")) + " ", 1),
                createVNode("i", { class: "ri-add-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="row"><div class="col-12 mb-4"><div class="accordion" id="accordionMenu"><!--[-->`);
      ssrRenderList(_ctx.categories, (category, index) => {
        _push(`<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-menu-" + category.id)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-menu-" + category.id)}><i class="ri-arrow-drop-left-line me-1"></i> ${ssrInterpolate(category.title)}</button></h2><div${ssrRenderAttr("id", "collapse-menu-" + category.id)} class="accordion-collapse collapse" data-bs-parent="#accordionMenu"><div class="accordion-body"><div class="d-flex align-items-center justify-content-end accordion-action-button">`);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.product.categories.add", category.id),
          as: "button",
          class: "btn btn-white shadow-1"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.add_sub_category"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.add_sub_category")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.product.categories.edit", category.slug),
          as: "button",
          class: "btn btn-white btn-sm btn-square shadow-1 ms-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="ri-pencil-line"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "ri-pencil-line" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`<button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#statistics-" + category.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-bar-chart-2-line"></i></button><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-cat-" + category.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-delete-bin-line"></i></button></div><div class="modal fade"${ssrRenderAttr("id", "statistics-" + category.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.category_statistics"))}: <span class="ms-1">${ssrInterpolate(category.title)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.word.view"))}</td><td>${ssrInterpolate(category.get_formatted_view_count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.products_count"))}</td><td>${ssrInterpolate(category.products_count)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-cat-" + category.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_category"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
        _push(ssrRenderComponent(unref(Link), {
          as: "button",
          href: _ctx.route("admin.product.categories.destroy", category.slug),
          method: "delete",
          class: "btn btn-sm btn-danger px-3",
          "data-bs-dismiss": "modal",
          "aria-label": "Close"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></form></div></div></div>`);
        if (category.childs.length > 0) {
          _push(`<div class="accordion accordin-between mt-3"${ssrRenderAttr("id", "accordionMenu-" + category.id)}><!--[-->`);
          ssrRenderList(category.childs, (category_level_two) => {
            _push(`<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-menu-" + category_level_two.id)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-menu-" + category_level_two.id)}><i class="ri-arrow-drop-left-line me-1"></i> ${ssrInterpolate(category_level_two.title)}</button></h2><div${ssrRenderAttr("id", "collapse-menu-" + category_level_two.id)} class="accordion-collapse collapse"${ssrRenderAttr("data-bs-parent", "#accordionMenu-" + category.id)}><div class="accordion-body"><div class="d-flex align-items-center justify-content-end accordion-action-button">`);
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("admin.product.categories.add", category_level_two.id),
              as: "button",
              class: "btn btn-white shadow-1"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`افزودن زیردسته`);
                } else {
                  return [
                    createTextVNode("افزودن زیردسته")
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(ssrRenderComponent(unref(Link), {
              href: _ctx.route("admin.product.categories.edit", category_level_two.slug),
              as: "button",
              class: "btn btn-white btn-sm btn-square shadow-1 ms-2"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<i class="ri-pencil-line"${_scopeId}></i>`);
                } else {
                  return [
                    createVNode("i", { class: "ri-pencil-line" })
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`<button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#statistics-" + category_level_two.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-bar-chart-2-line"></i></button><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-cat-" + category_level_two.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-delete-bin-line"></i></button></div><div class="modal fade"${ssrRenderAttr("id", "statistics-" + category_level_two.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.category_statistics"))}: <span class="ms-1">${ssrInterpolate(category_level_two.title)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.word.view"))}</td><td>${ssrInterpolate(category_level_two.get_formatted_view_count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.products_count"))}</td><td>${ssrInterpolate(category_level_two.products_count)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" type="button" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-cat-" + category_level_two.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_category"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
            _push(ssrRenderComponent(unref(Link), {
              as: "button",
              href: _ctx.route("admin.product.categories.destroy", category_level_two.slug),
              method: "delete",
              class: "btn btn-sm btn-danger px-3",
              "data-bs-dismiss": "modal",
              "aria-label": "Close"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</div></form></div></div></div>`);
            if (category_level_two.childs.length > 0) {
              _push(`<div class="accordion accordion-last mt-3"${ssrRenderAttr("id", "accordionMenu-" + category_level_two.id)}><!--[-->`);
              ssrRenderList(category_level_two.childs, (category_level_three) => {
                _push(`<div class="accordion-item"><h2 class="accordion-header"><button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"${ssrRenderAttr("data-bs-target", "#collapse-menu-" + category_level_three.id)} aria-expanded="false"${ssrRenderAttr("aria-controls", "collapse-menu-" + category_level_three.id)}><i class="ri-arrow-drop-left-line me-1"></i> ${ssrInterpolate(category_level_three.title)}</button></h2><div${ssrRenderAttr("id", "collapse-menu-" + category_level_three.id)} class="accordion-collapse collapse"${ssrRenderAttr("data-bs-parent", "#accordionMenu-" + category_level_two.id)}><div class="accordion-body"><div class="d-flex align-items-center justify-content-end accordion-action-button">`);
                _push(ssrRenderComponent(unref(Link), {
                  href: _ctx.route("admin.product.categories.edit", category_level_three.slug),
                  as: "button",
                  class: "btn btn-white btn-sm btn-square shadow-1 ms-2"
                }, {
                  default: withCtx((_, _push2, _parent2, _scopeId) => {
                    if (_push2) {
                      _push2(`<i class="ri-pencil-line"${_scopeId}></i>`);
                    } else {
                      return [
                        createVNode("i", { class: "ri-pencil-line" })
                      ];
                    }
                  }),
                  _: 2
                }, _parent));
                _push(`<button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#statistics-" + category_level_three.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-bar-chart-2-line"></i></button><button data-bs-toggle="modal"${ssrRenderAttr("data-bs-target", "#remove-cat-" + category_level_three.id)} class="btn btn-white btn-sm btn-square shadow-1 ms-2"><i class="ri-delete-bin-line"></i></button></div><div class="modal fade"${ssrRenderAttr("id", "statistics-" + category_level_three.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-lgs modal-dialog-centered"><div class="modal-content"><form style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.category_statistics"))}: <span class="ms-1">${ssrInterpolate(category_level_three.title)}</span></div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-body"><div class="row"><div class="col-12"><div class="table-responsive"><table class="table" style="${ssrRenderStyle({ "width": "100%", "min-width": "100%" })}"><tbody><tr><td>${ssrInterpolate(_ctx.$t("messages.word.view"))}</td><td>${ssrInterpolate(category_level_three.get_formatted_view_count)}</td></tr><tr><td class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.products_count"))}</td><td>${ssrInterpolate(category_level_three.products_count)}</td></tr></tbody></table></div></div></div></div><div class="modal-footer"><button class="btn btn-primary" data-bs-dismiss="modal" aria-label="Close">${ssrInterpolate(_ctx.$t("messages.word.close"))}</button></div></form></div></div></div><div class="modal fade"${ssrRenderAttr("id", "remove-cat-" + category_level_three.id)} tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered"><div class="modal-content"><form action="#" style="${ssrRenderStyle({ "direction": "rtl" })}"><div class="modal-header"><div class="modal-title lts-05 fs-5">${ssrInterpolate(_ctx.$t("messages.sentence.are_you_sure_delete_category"))}</div><button type="button" class="btn modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="ri-close-line"></i></button></div><div class="modal-footer">`);
                _push(ssrRenderComponent(unref(Link), {
                  as: "button",
                  href: _ctx.route("admin.product.categories.destroy", category_level_three.slug),
                  method: "delete",
                  class: "btn btn-sm btn-danger px-3",
                  "data-bs-dismiss": "modal",
                  "aria-label": "Close"
                }, {
                  default: withCtx((_, _push2, _parent2, _scopeId) => {
                    if (_push2) {
                      _push2(`${ssrInterpolate(_ctx.$t("messages.word.delete"))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("messages.word.delete")), 1)
                      ];
                    }
                  }),
                  _: 2
                }, _parent));
                _push(`</div></form></div></div></div></div></div></div>`);
              });
              _push(`<!--]--></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div></div></div>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div></div>`);
      if (_ctx.categories.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05 p-4 d-flex align-items-center justify-content-center flex-column">${ssrInterpolate(_ctx.$t("messages.sentence.no_any_category_yet"))} `);
        _push(ssrRenderComponent(unref(Link), {
          href: _ctx.route("admin.product.categories.add"),
          class: "btn btn-primary shadow-1 lts-05 mt-4"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("messages.sentence.create_main_category"))} <i class="ri-add-line"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("messages.sentence.create_main_category")) + " ", 1),
                createVNode("i", { class: "ri-add-line" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Products/Categories/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
