import { defineComponent, ref, onMounted, onUnmounted, mergeProps, useSSRContext, inject, computed, watch, unref, withCtx, createVNode, resolveDynamicComponent } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrRenderStyle, ssrRenderAttr, ssrInterpolate, ssrRenderComponent, ssrRenderVNode, ssrRenderSlot } from "vue/server-renderer";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import SimpleBar from "simplebar";
import ResizeObserver from "resize-observer-polyfill";
import { u as useToast } from "./useToastify-D_n0s7Uc.js";
import { usePage, Head } from "@inertiajs/vue3";
import { _ as _sfc_main$2, a as _sfc_main$3, b as _sfc_main$4 } from "./AdminNavigation-BYBoZNuA.js";
import { u as useHexToRgb } from "./useHexToRgb-G7J9N7Ap.js";
import { u as useRandomStr } from "./useRandomStr-4MeWbtRd.js";
import $ from "jquery";
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "SupportFloatingButton",
  __ssrInlineRender: true,
  setup(__props) {
    const status = ref(false);
    const handleClickOutside = (event) => {
      const clickedElement = event.target;
      const supportBox = document.querySelector(".support-floating-button");
      if (status.value && supportBox && !supportBox.contains(clickedElement)) {
        status.value = false;
      }
    };
    onMounted(() => {
      document.addEventListener("click", handleClickOutside);
    });
    onUnmounted(() => {
      document.removeEventListener("click", handleClickOutside);
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: { "support-floating-button": true, "sfb-cart": _ctx.$page.props.currentRouteName.includes("cart"), "sfb-product": _ctx.$page.props.currentRouteName.includes("main.products.show") }
      }, _attrs))}><button type="button" class="${ssrRenderClass({ active: status.value })}">`);
      if (status.value) {
        _push(`<i class="ri-close-line" style="${ssrRenderStyle({ "font-size": "2.2rem" })}"></i>`);
      } else {
        _push(`<i class="ri-customer-service-fill"></i>`);
      }
      _push(`</button><div class="${ssrRenderClass({ panel: true, active: status.value })}"><ul>`);
      if (_ctx.$page.props.mobilePhone != null) {
        _push(`<li class="lts-05"><a${ssrRenderAttr("href", "tel://" + _ctx.$page.props.mobilePhone)}>${ssrInterpolate(_ctx.$t("messages.word.mobile_phone"))}</a><i class="ri-smartphone-line"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.staticPhone != null) {
        _push(`<li class="lts-05"><a${ssrRenderAttr("href", "tel://" + _ctx.$page.props.staticPhone)}>${ssrInterpolate(_ctx.$t("messages.word.static_phone"))}</a><i class="ri-phone-fill"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.telegramPhone != null) {
        _push(`<li class="lts-05"><a${ssrRenderAttr("href", "https://t.me/" + _ctx.$page.props.telegramPhone)} target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.message_by_telegram"))}</a><i class="ri-telegram-fill" style="${ssrRenderStyle({ "color": "#00a8ff" })}"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.whatsappPhone != null) {
        _push(`<li class="lts-05"><a${ssrRenderAttr("href", "https://wa.me/" + _ctx.$page.props.whatsappPhone)} target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.message_by_whatsapp"))}</a><i class="ri-whatsapp-fill" style="${ssrRenderStyle({ "color": "#1abc9c" })}"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.$page.props.instagramSupport != null) {
        _push(`<li class="lts-05"><a${ssrRenderAttr("href", _ctx.$page.props.instagramSupport)} target="_blank">${ssrInterpolate(_ctx.$t("messages.sentence.message_by_instagram"))}</a><i class="ri-instagram-fill" style="${ssrRenderStyle({ "color": "#df155e" })}"></i></li>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</ul></div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/UI/Widgets/SupportFloatingButton.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "MainLayout",
  __ssrInlineRender: true,
  setup(__props) {
    let Bootstrap = null;
    onMounted(() => {
      if (typeof window !== "undefined") {
        Bootstrap = inject("bootstrap");
        new Bootstrap.Tooltip(document.body, {
          selector: "[data-bs-toggle='tooltip']",
          trigger: "hover"
        });
      }
    });
    const dark = ref(usePage().props.dark);
    if (typeof window !== "undefined") {
      $(() => {
        let config = { attributes: true, attributeFilter: ["id"] };
        let callback = function(mutationsList, observer2) {
          for (let mutation of mutationsList) {
            if (mutation.type === "attributes" && mutation.attributeName === "id") {
              if (document.body.id == "dark") dark.value = true;
              else dark.value = false;
            }
          }
        };
        let observer = new MutationObserver(callback);
        observer.observe(document.body, config);
      });
    }
    onMounted(() => {
      if (typeof window !== "undefined") {
        window.ResizeObserver = ResizeObserver;
        document.querySelectorAll(".simplebar-container").forEach((el) => {
          new SimpleBar(el, {
            autoHide: true
          });
        });
      }
    });
    onMounted(() => {
      if (typeof window !== "undefined") {
        window.jalaliDatepicker.startWatch({});
      }
    });
    const errorMessages = computed(() => {
      if (typeof usePage().props.errors !== "undefined") {
        return usePage().props.errors;
      }
      return [];
    });
    watch(errorMessages, (errors) => {
      for (let i in errors) {
        useToast(errors[i], "fail", 4e3);
      }
    });
    const flashMessage = computed(() => {
      if (typeof usePage().props.flash !== "undefined") {
        return usePage().props.flash.message;
      }
      return [];
    });
    watch(flashMessage, (messages) => {
      for (let i in messages) {
        useToast(messages[i], "success", 4e3);
      }
    });
    onMounted(() => {
      if (usePage().props.template != null) {
        document.documentElement.style.setProperty("--main-background", usePage().props.template.get_options.style.site_background_color);
        document.documentElement.style.setProperty("--primary", usePage().props.template.get_options.style.site_main_color);
        document.documentElement.style.setProperty("--primary-rgb", useHexToRgb(usePage().props.template.get_options.style.site_main_color));
        document.documentElement.style.setProperty("--secondary", usePage().props.template.get_options.style.site_secondary_color);
        document.documentElement.style.setProperty("--secondary-rgb", useHexToRgb(usePage().props.template.get_options.style.site_secondary_color));
        document.documentElement.style.setProperty("--shadow-1", usePage().props.template.get_options.style.site_main_shadow);
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<link rel="apple-touch-icon"${ssrRenderAttr("href", _ctx.$page.props.appFavicon)}${_scopeId}><meta name="theme-color"${ssrRenderAttr("content", dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25")}${_scopeId}>`);
          } else {
            return [
              createVNode("link", {
                rel: "apple-touch-icon",
                href: _ctx.$page.props.appFavicon
              }, null, 8, ["href"]),
              createVNode("meta", {
                name: "theme-color",
                content: dark.value ? "#262631" : unref(usePage)().props.template != null ? unref(usePage)().props.template.get_options.style.site_main_color : "#1c1c25"
              }, null, 8, ["content"])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (_ctx.$page.props.template != null) {
        _push(`<div class="${ssrRenderClass({
          "page-wrapper": true,
          "admin-loggedin": _ctx.$page.props.auth.user != null && _ctx.$page.props.template != null && (_ctx.$page.props.auth.user.type == "owner" || _ctx.$page.props.auth.user.type == "admin")
        })}">`);
        _push(ssrRenderComponent(_sfc_main$2, {
          key: unref(useRandomStr)(10)
        }, null, _parent));
        if (_ctx.$page.props.currentRouteName.includes("user.orders.sales_factor") || _ctx.$page.props.currentRouteName.includes("admin.orders.sales_factor")) {
          _push(`<!--[--><!--]-->`);
        } else if ((_ctx.$page.props.currentRouteName.includes("cart.") || _ctx.$page.props.currentRouteName.startsWith("prefactor")) && !_ctx.$page.props.currentRouteName.includes("cart.order.status")) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent("HeaderType5"), { status: "prod" }, null), _parent);
        } else {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$page.props.template.header), { status: "prod" }, null), _parent);
        }
        _push(`<div class="page-content" style="${ssrRenderStyle(_ctx.$page.props.currentRouteName == "index" || _ctx.$page.props.currentRouteName == "blog.index" ? "" : "padding-top: 20px")}">`);
        if (_ctx.$page.props.currentRouteName.includes("user.orders.sales_factor")) {
          ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
        } else if (_ctx.$page.props.currentRouteName.includes("user.")) {
          _push(`<div class="container mb-5"><div class="row"><div class="col-xl-3 col-lg-4 col-md-4 mb-md-0 mb-4">`);
          _push(ssrRenderComponent(_sfc_main$3, null, null, _parent));
          _push(`</div><div class="col-xl-9 col-lg-8 col-md-8">`);
          ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
          _push(`</div></div></div>`);
        } else {
          ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
        }
        _push(`</div>`);
        if (_ctx.$page.props.currentRouteName.includes("main.categories") || _ctx.$page.props.currentRouteName.includes("user.orders.sales_factor") || _ctx.$page.props.currentRouteName.includes("admin.orders.sales_factor")) {
          _push(`<!--[--><!--]-->`);
        } else if (_ctx.$page.props.currentRouteName.includes("cart") || _ctx.$page.props.currentRouteName.includes("user.")) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent("FooterType2"), { status: "prod" }, null), _parent);
        } else {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$page.props.template.footer), { status: "prod" }, null), _parent);
        }
        if (_ctx.$page.props.currentRouteName.includes("main.products.show") || _ctx.$page.props.currentRouteName.includes("cart") || _ctx.$page.props.currentRouteName.includes("user.orders.sales_factor") || _ctx.$page.props.currentRouteName.includes("admin.orders.sales_factor")) {
          _push(`<!--[--><!--]-->`);
        } else {
          _push(ssrRenderComponent(_sfc_main$4, {
            key: unref(useRandomStr)(10)
          }, null, _parent));
        }
        if (_ctx.$page.props.supportFloatingButton) {
          _push(ssrRenderComponent(_sfc_main$1, null, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<div class="page-wrapper d-flex align-items-center justify-content-center"><p class="fw-bold fs-6">${ssrInterpolate(_ctx.$t("messages.sentence.no_template_has_been_activated"))}</p></div>`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/MainLayout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
