import { defineComponent, resolveDirective, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr, ssrRenderAttrs, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _sfc_main$1 } from "./AdminLayout-CD07IMsK.js";
import { Head } from "@inertiajs/vue3";
import { _ as _sfc_main$2 } from "./Files-B6eiTnN6.js";
import { u as useNumberFormat } from "../ssr.js";
import { _ as _sfc_main$3 } from "./FilterList-CWxGcEKk.js";
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
/* empty css                 */
/* empty css                              */
/* empty css                       */
/* empty css               */
import "primevue/progressbar/progressbar.esm.js";
import "primevue/confirmdialog/confirmdialog.esm.js";
import "primevue/useconfirm/useconfirm.esm.js";
import "laravel-vue-i18n";
import "./Pagination-C1AQrLe3.js";
import "./SearchList-BZnYMQPN.js";
import "lodash/debounce.js";
import "./useRandomNum-DNNSqR7b.js";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "axios";
import "swiper/bundle";
import "jquery";
import "swiper";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "Products",
  __ssrInlineRender: true,
  props: {
    productsSales: {},
    productsVisit: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _directive_tooltip = resolveDirective("tooltip");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.products_statistics")
      }, null, _parent));
      _push(`<div class="container-fluid">`);
      _push(ssrRenderComponent(_sfc_main$2, {
        title: _ctx.$t("messages.sentence.products_statistics")
      }, null, _parent));
      _push(`<div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex fw-bold fs-6 lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.x_most_sales_products", { count: "10" }))}</div><div class="border mb-3"></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: {
          sale_today: _ctx.$t("messages.word.today"),
          sale_week: _ctx.$t("messages.word.week"),
          sale_month: _ctx.$t("messages.word.month")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.sales_count"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.productsSales, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { top: true }))}><a class="product-title product-title-min-300"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))} target="_blank">${ssrInterpolate(product.title)}</a>`);
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="first-small white-space-nowrap">${ssrInterpolate(product.consignment_items_count != null ? unref(useNumberFormat)(product.consignment_items_count) : 0)}</td><td class="first-small white-space-nowrap">${ssrInterpolate(product.jalali_updated_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.productsSales.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div><div class="product-list list mb-4"><div class="card"><div class="card-body"><div class="d-flex fw-bold fs-6 lts-05 mb-3">${ssrInterpolate(_ctx.$t("messages.sentence.x_most_viewed_products", { count: "10" }))}</div><div class="border mb-3"></div>`);
      _push(ssrRenderComponent(_sfc_main$3, {
        filters: {
          visit_today: _ctx.$t("messages.word.today"),
          visit_week: _ctx.$t("messages.word.week"),
          visit_month: _ctx.$t("messages.word.month")
        }
      }, null, _parent));
      _push(`<div class="table-responsive mb-4"><table class="table" style="${ssrRenderStyle({ "min-width": "900px" })}"><thead><tr><th class="first-small">${ssrInterpolate(_ctx.$t("messages.word.image"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.title"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.view"))}</th><th class="first-small white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.word.last_update"))}</th></tr></thead><tbody><!--[-->`);
      ssrRenderList(_ctx.productsVisit, (product) => {
        _push(`<tr><td><img class="br-10" width="35" height="35"${ssrRenderAttr("src", product.get_images[0]["link"])}${ssrRenderAttr("alt", product.get_images[0]["alt"])}></td><td${ssrRenderAttrs(ssrGetDirectiveProps(_ctx, _directive_tooltip, product.is_vip ? _ctx.$t("messages.sentence.vip_product") : null, void 0, { top: true }))}><a class="product-title product-title-min-300"${ssrRenderAttr("href", _ctx.route("main.products.show", product.slug))} target="_blank">${ssrInterpolate(product.title)}</a>`);
        if (product.is_vip) {
          _push(`<i class="ri-star-s-fill vip-product"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</td><td class="first-small white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(parseInt(product.view_count)))}</td><td class="first-small white-space-nowrap">${ssrInterpolate(product.jalali_updated_at[2])}</td></tr>`);
      });
      _push(`<!--]--></tbody></table></div>`);
      if (_ctx.productsVisit.length == 0) {
        _push(`<div class="product-list-empty"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.no_items_found"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Admin/Statistics/Products.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
