import { defineComponent, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderStyle, ssrRenderList } from "vue/server-renderer";
import { u as useNumberFormat } from "../ssr.js";
import { _ as _sfc_main$1 } from "./MainLayout-CahYFWjG.js";
import { Head } from "@inertiajs/vue3";
import "@vue/server-renderer";
import "@inertiajs/vue3/server";
import "ziggy-js";
import "laravel-vue-i18n";
import "axios";
import "lodash/debounce.js";
import "swiper/bundle";
import "jquery";
import "swiper";
/* empty css                       */
/* empty css                              */
/* empty css                           */
/* empty css             */
import "simplebar";
import "resize-observer-polyfill";
import "./useToastify-D_n0s7Uc.js";
import "toastify-js";
import "./AdminNavigation-BYBoZNuA.js";
import "./useHexToRgb-G7J9N7Ap.js";
import "./useRandomStr-4MeWbtRd.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    layout: _sfc_main$1
  },
  __name: "SalesFactor",
  __ssrInlineRender: true,
  props: {
    order: {},
    consignmentItems: {},
    user_national_number: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      _push(ssrRenderComponent(unref(Head), {
        title: _ctx.$t("messages.title.sales_factor") + " - " + _ctx.$page.props.appName
      }, null, _parent));
      _push(`<div class="container mt-4 mb-5"><div class="row"><div class="col-12 d-flex pre-factor-top-actions align-items-center justify-content-between"><div></div><div class="card shadow-1 print-button"><div class="card-body"><button class="btn btn-primary">${ssrInterpolate(_ctx.$t("messages.sentence.print_factor"))}</button></div></div></div></div><div id="preFactor" class="card shadow-1 pre-factor mb-3"><div class="card-body"><div class="row"><div class="col-lg-3 col-sm-4 d-sm-flex d-none align-items-center"><div class="logo-container"><div class="logo"><img${ssrRenderAttr("src", _ctx.$page.props.appLogo)} alt="logo" style="${ssrRenderStyle({ "width": "100px" })}"></div></div></div><div class="col-lg-6 col-sm-4 col-6 d-flex align-items-center justify-content-center pre-factor--title"><div class="lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.sales_factor"))}</div></div><div class="col-lg-3 col-sm-4 col-6 d-flex align-items-center justify-content-end"><ul class="pre-factor--details"><li>${ssrInterpolate(_ctx.$t("messages.word.date"))}: <span>${ssrInterpolate(_ctx.order.jalali_created_at[1])}</span></li><li>${ssrInterpolate(_ctx.$t("messages.sentence.order_uuid"))}: <span>${ssrInterpolate(_ctx.order.uuid)}</span></li></ul></div><div class="col-12 divider"><div></div></div><div class="col-12 pre-factor--main-table"><div class="row"><div class="col-lg-6"><div class="main-table--title lts-05">${ssrInterpolate(_ctx.$t("messages.word.seller"))}</div><div class="main-table--content"><ul><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.title"))}: </span><span class="value">${ssrInterpolate(_ctx.$page.props.appFullName)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.town"))}: </span><span class="value">${ssrInterpolate(_ctx.$page.props.shopAddressTown)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.city"))}: </span><span class="value">${ssrInterpolate(_ctx.$page.props.shopAddressCity)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: </span><span class="value">${ssrInterpolate(_ctx.$page.props.shopAddressPostalCode)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: </span><span class="value">${ssrInterpolate(_ctx.$page.props.supportPhone)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.address"))}: </span><span class="value">${ssrInterpolate(_ctx.$page.props.shopAddress)}</span></li></ul></div></div><div class="col-lg-6"><div class="main-table--title lts-05">${ssrInterpolate(_ctx.$t("messages.word.buyer"))}</div><div class="main-table--content">`);
      if (_ctx.order.get_address.type == "user") {
        _push(`<ul><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.name"))}: </span><span class="value">${ssrInterpolate(_ctx.order.user.get_name)}</span></li>`);
        if (_ctx.user_national_number != null) {
          _push(`<li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.national_number"))}: </span><span class="value">${ssrInterpolate(_ctx.user_national_number)}</span></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.town"))}: </span><span class="value">${ssrInterpolate(_ctx.order.get_address.address.state.replace("استان", "").replace("state", ""))}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.city"))}: </span><span class="value">${ssrInterpolate(_ctx.order.get_address.address.city)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.postal_code"))}: </span><span class="value">${ssrInterpolate(_ctx.order.get_address.address.postal_code)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: </span><span class="value">${ssrInterpolate(_ctx.order.get_address.address.phone)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.address"))}: </span><span class="value">${ssrInterpolate(_ctx.order.get_address.address.full_address)}</span></li></ul>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.get_address.type == "shop") {
        _push(`<ul><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.name"))}: </span><span class="value">${ssrInterpolate(_ctx.order.user.get_name)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.word.telephone"))}: </span><span class="value">${ssrInterpolate(_ctx.$page.props.auth.user.phone)}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.sentence.send_method"))}: </span><span class="value">${ssrInterpolate(_ctx.$t("messages.sentence.receive_in_person"))}</span></li><li><span class="key">${ssrInterpolate(_ctx.$t("messages.sentence.receive_address"))}: </span><span class="value">${ssrInterpolate(_ctx.order.get_address.address.full_address)}</span></li></ul>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div></div><div class="col-12 pre-factor--product-details-table mb-3"><div style="${ssrRenderStyle({ "overflow-x": "auto" })}" class="mb-2"><table><tr><th class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.product_uuid"))}</th><th class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.description_of_goods_or_services"))}</th><th>${ssrInterpolate(_ctx.$t("messages.word.count"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.one_amount"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.total_discount"))}</th><th>${ssrInterpolate(_ctx.$t("messages.sentence.final_amount"))}</th></tr><!--[-->`);
      ssrRenderList(_ctx.consignmentItems, (item, index) => {
        _push(`<tr><td class="white-space-nowrap">${ssrInterpolate(item.product != null ? item.product.uuid : null)}</td><td><span>${ssrInterpolate(item.product != null ? item.product.title : item.title)}</span><!--[-->`);
        ssrRenderList(item.get_props, (prop, index2) => {
          _push(`<span class="ms-2 before-line">${ssrInterpolate(prop["name"])}: `);
          if (prop["type"] == "color") {
            _push(`<span>${ssrInterpolate(prop["value"]["label"])}</span>`);
          } else {
            _push(`<span>${ssrInterpolate(prop["value"])}</span>`);
          }
          _push(`</span>`);
        });
        _push(`<!--]--></td><td>${ssrInterpolate(unref(useNumberFormat)(item.count))}</td><td class="white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(item.price + item.discount))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td><td class="white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(item.discount * item.count))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td><td class="white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(item.price * item.count))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></td></tr>`);
      });
      _push(`<!--]--><tr><th style="${ssrRenderStyle({ "border": "none" })}" class="white-space-nowrap">${ssrInterpolate(_ctx.$t("messages.sentence.total_sum"))}:</th><th style="${ssrRenderStyle({ "border": "none" })}"></th><th>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.count))}</th><th class="white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.price + _ctx.order.get_total_bill.final.discount))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></th><th class="white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.discount))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></th><th class="white-space-nowrap">${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.price))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></th></tr></table></div><div style="${ssrRenderStyle({ "overflow-x": "auto" })}" class="mb-1"><table><tr>`);
      if (_ctx.order.get_send_method != null) {
        _push(`<th><div class="white-space-nowrap d-flex align-items-center justify-content-between"><div><span class="fs-8 lts-05 fw-normal me-1">${ssrInterpolate(_ctx.$t("messages.sentence.send_price"))}:</span></div>`);
        if (_ctx.order.get_send_method["type"] == "post") {
          _push(`<div>`);
          if (!_ctx.order.get_send_method["free"]) {
            _push(`<!--[-->`);
            if (_ctx.order.get_send_method["price"] != null) {
              _push(`<!--[-->${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_send_method["price"]))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span><!--]-->`);
            } else {
              _push(`<span class="fs-8 lts-05">${ssrInterpolate(_ctx.$t("messages.sentence.payment_on_spot"))}</span>`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<span class="fs-8">${ssrInterpolate(_ctx.$t("messages.word.free"))}</span>`);
          }
          _push(`</div>`);
        } else {
          _push(`<div class="fs-8">${ssrInterpolate(_ctx.$t("messages.sentence.receive_in_person"))}</div>`);
        }
        _push(`</div></th>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.order.get_discount != null) {
        _push(`<th><div class="white-space-nowrap d-flex align-items-center justify-content-between"><div><span class="fs-8 lts-05 fw-normal me-1">${ssrInterpolate(_ctx.$t("messages.sentence.deduction_with_discount_code"))}:</span></div><div>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_discount["amount"]))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div></div></th>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<th><div class="white-space-nowrap d-flex align-items-center justify-content-between"><span class="fs-8 lts-05 fw-normal me-1">${ssrInterpolate(_ctx.$t("messages.sentence.total_paid_amount"))}:</span>`);
      if (_ctx.order.get_send_method != null && _ctx.order.get_send_method["type"] == "post" && _ctx.order.get_send_method["price"] != null && !_ctx.order.get_send_method["free"]) {
        _push(`<!--[-->`);
        if (_ctx.order.get_discount != null) {
          _push(`<div>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.price + _ctx.order.get_send_method["price"] - _ctx.order.get_discount["amount"]))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div>`);
        } else {
          _push(`<div>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.price + _ctx.order.get_send_method["price"]))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div>`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        if (_ctx.order.get_discount != null) {
          _push(`<div>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.price - _ctx.order.get_discount["amount"]))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div>`);
        } else {
          _push(`<div>${ssrInterpolate(unref(useNumberFormat)(_ctx.order.get_total_bill.final.price))} <span class="fs-10 lts-05">${ssrInterpolate(_ctx.$t("messages.word.toman"))}</span></div>`);
        }
        _push(`<!--]-->`);
      }
      _push(`</div></th></tr></table></div></div><div class="col-12 pre-factor--descriptions"><ul><li><span>*</span> ${ssrInterpolate(_ctx.$t("messages.sentence.msg_id_885423"))}</li></ul></div></div></div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/User/Orders/SalesFactor.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
